/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Annotation;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfAnnotation
extends RtfElement {
    private static final byte[] ANNOTATION_ID = "\\*\\atnid".getBytes();
    private static final byte[] ANNOTATION_AUTHOR = "\\*\\atnauthor".getBytes();
    private static final byte[] ANNOTATION = "\\*\\annotation".getBytes();
    private String title = "";
    private String content = "";

    public RtfAnnotation(RtfDocument doc, Annotation annotation) {
        super(doc);
        this.title = annotation.title();
        this.content = annotation.content();
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(OPEN_GROUP);
            result.write(ANNOTATION_ID);
            result.write(DELIMITER);
            result.write(this.intToByteArray(this.document.getRandomInt()));
            result.write(CLOSE_GROUP);
            result.write(OPEN_GROUP);
            result.write(ANNOTATION_AUTHOR);
            result.write(DELIMITER);
            result.write(this.title.getBytes());
            result.write(CLOSE_GROUP);
            result.write(OPEN_GROUP);
            result.write(ANNOTATION);
            result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
            result.write(DELIMITER);
            result.write(this.content.getBytes());
            result.write(CLOSE_GROUP);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

