/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets.out;

import java.nio.ByteBuffer;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets.out.ClusterCommandPacket;

public class ClusterAuthPacket
extends ClusterCommandPacket {
    public int type;
    private String message;
    private int receiver;

    public ClusterAuthPacket(QQUser qQUser) {
        super(qQUser);
        this.subCommand = (byte)8;
        this.message = "";
        this.receiver = 0;
    }

    public ClusterAuthPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    public String getPacketName() {
        return "Cluster Auth _08Packet";
    }

    protected void putBody(ByteBuffer byteBuffer) {
        byteBuffer.put(this.subCommand);
        byteBuffer.putInt(this.clusterId);
        byteBuffer.put((byte)this.type);
        switch (this.type) {
            case 1: {
                byteBuffer.putChar((char)this.user.getAuthToken().length);
                byteBuffer.put(this.user.getAuthToken());
                byteBuffer.putInt(0);
                byte[] byArray = this.message.getBytes();
                byteBuffer.put((byte)(byArray.length & 0xFF));
                byteBuffer.put(byArray);
                break;
            }
            case 2: 
            case 3: {
                byteBuffer.putInt(this.receiver);
                byte[] byArray = this.message.getBytes();
                byteBuffer.put((byte)(byArray.length & 0xFF));
                byteBuffer.put(byArray);
                byteBuffer.putChar((char)this.user.getAuthToken().length);
                byteBuffer.put(this.user.getAuthToken());
            }
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getReceiver() {
        return this.receiver;
    }

    public void setReceiver(int n) {
        this.receiver = n;
    }
}

