/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.xmpp;

import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

final class IQUtils {
    private static XmlPullParserFactory xmlPullParserFactory;

    public static org.xmpp.packet.IQ convert(IQ smackIQ) throws Exception {
        String xml = smackIQ.getChildElementXML();
        Element element = null;
        if (xml != null && xml.length() != 0) {
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read((Reader)new StringReader(xml));
            element = document.getRootElement();
        }
        org.xmpp.packet.IQ iq = new org.xmpp.packet.IQ();
        String from = smackIQ.getFrom();
        if (from != null && from.length() != 0) {
            iq.setFrom(new JID(from));
        }
        iq.setID(smackIQ.getPacketID());
        String to = smackIQ.getTo();
        if (to != null && to.length() != 0) {
            iq.setTo(new JID(to));
        }
        iq.setType(IQUtils.convert(smackIQ.getType()));
        if (element != null) {
            iq.setChildElement(element);
        }
        return iq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static IQ convert(org.xmpp.packet.IQ iq) throws Exception {
        Element element = iq.getChildElement();
        IQProvider iqProvider = (IQProvider)ProviderManager.getInstance().getIQProvider(element.getName(), element.getNamespaceURI());
        IQ smackIQ = null;
        if (iqProvider != null) {
            Class<IQUtils> clazz = IQUtils.class;
            // MONITORENTER : org.jitsi.videobridge.xmpp.IQUtils.class
            if (xmlPullParserFactory == null) {
                xmlPullParserFactory = XmlPullParserFactory.newInstance();
                xmlPullParserFactory.setNamespaceAware(true);
            }
            XmlPullParserFactory xmlPullParserFactory = IQUtils.xmlPullParserFactory;
            // MONITOREXIT : clazz
            XmlPullParser parser = xmlPullParserFactory.newPullParser();
            parser.setInput((Reader)new StringReader(iq.toXML()));
            int eventType = parser.next();
            if (2 != eventType) throw new IllegalStateException(Integer.toString(eventType) + " != XmlPullParser.START_TAG");
            String name = parser.getName();
            if (!"iq".equals(name)) throw new IllegalStateException(name + " != iq");
            eventType = parser.next();
            if (2 != eventType) throw new IllegalStateException(Integer.toString(eventType) + " != XmlPullParser.START_TAG");
            smackIQ = iqProvider.parseIQ(parser);
            if (smackIQ != null && 3 != (eventType = parser.getEventType())) {
                throw new IllegalStateException(Integer.toString(eventType) + " != XmlPullParser.END_TAG");
            }
        }
        if (smackIQ == null) return smackIQ;
        JID fromJID = iq.getFrom();
        if (fromJID != null) {
            smackIQ.setFrom(fromJID.toString());
        }
        smackIQ.setPacketID(iq.getID());
        JID toJID = iq.getTo();
        if (toJID != null) {
            smackIQ.setTo(toJID.toString());
        }
        smackIQ.setType(IQUtils.convert(iq.getType()));
        return smackIQ;
    }

    public static IQ.Type convert(IQ.Type smackType) {
        return IQ.Type.valueOf((String)smackType.toString());
    }

    public static IQ.Type convert(IQ.Type type) {
        return IQ.Type.fromString((String)type.name());
    }

    private IQUtils() {
    }
}

