/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.MultiplexedDatagramSocket;
import org.ice4j.socket.SafeCloseDatagramSocket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplexingDatagramSocket
extends SafeCloseDatagramSocket {
    private static final Logger logger = Logger.getLogger(MultiplexingDatagramSocket.class.getName());
    private static final MultiplexedDatagramSocket[] NO_SOCKETS = new MultiplexedDatagramSocket[0];
    private boolean inReceive = false;
    private final List<DatagramPacket> received = new LinkedList<DatagramPacket>();
    private int receiveBufferSize;
    private final Object receiveSyncRoot = new Object();
    private boolean setReceiveBufferSize = false;
    private MultiplexedDatagramSocket[] sockets = NO_SOCKETS;
    private final Object socketsSyncRoot = new Object();
    private int soTimeout = 0;

    public MultiplexingDatagramSocket() throws SocketException {
    }

    public MultiplexingDatagramSocket(DatagramSocket delegate) throws SocketException {
        super(delegate);
    }

    public MultiplexingDatagramSocket(int port) throws SocketException {
        super(port);
    }

    public MultiplexingDatagramSocket(int port, InetAddress laddr) throws SocketException {
        super(port, laddr);
    }

    public MultiplexingDatagramSocket(SocketAddress bindaddr) throws SocketException {
        super(bindaddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatagramPacket clone(DatagramPacket p) {
        DatagramPacket datagramPacket = p;
        synchronized (datagramPacket) {
            byte[] data = (byte[])p.getData().clone();
            InetAddress address = p.getAddress();
            int port = p.getPort();
            if (address == null || port < 0) {
                return new DatagramPacket(data, p.getOffset(), p.getLength());
            }
            return new DatagramPacket(data, p.getOffset(), p.getLength(), address, port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(MultiplexedDatagramSocket multiplexed) {
        Object object = this.socketsSyncRoot;
        synchronized (object) {
            int socketCount = this.sockets.length;
            for (int i = 0; i < socketCount; ++i) {
                if (!this.sockets[i].equals(multiplexed)) continue;
                if (socketCount == 1) {
                    this.sockets = NO_SOCKETS;
                    break;
                }
                MultiplexedDatagramSocket[] newSockets = new MultiplexedDatagramSocket[socketCount - 1];
                System.arraycopy(this.sockets, 0, newSockets, 0, i);
                System.arraycopy(this.sockets, i + 1, newSockets, i, newSockets.length - i);
                this.sockets = newSockets;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(DatagramPacket src, DatagramPacket dest) {
        DatagramPacket datagramPacket = dest;
        synchronized (datagramPacket) {
            dest.setAddress(src.getAddress());
            dest.setPort(src.getPort());
            byte[] srcData = src.getData();
            if (srcData == null) {
                dest.setLength(0);
            } else {
                byte[] destData = dest.getData();
                if (destData == null) {
                    dest.setLength(0);
                } else {
                    int srcLength;
                    int destOffset = dest.getOffset();
                    int destLength = destData.length - destOffset;
                    if (destLength >= (srcLength = src.getLength())) {
                        destLength = srcLength;
                    } else if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "Truncating received DatagramPacket data!");
                    }
                    System.arraycopy(srcData, src.getOffset(), destData, destOffset, destLength);
                    dest.setLength(destLength);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiplexedDatagramSocket getSocket(DatagramPacketFilter filter) throws SocketException {
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        Object object = this.socketsSyncRoot;
        synchronized (object) {
            for (MultiplexedDatagramSocket socket : this.sockets) {
                if (!filter.equals(socket.getFilter())) continue;
                return socket;
            }
            MultiplexedDatagramSocket socket = new MultiplexedDatagramSocket(this, filter);
            int socketCount = this.sockets.length;
            if (socketCount == 0) {
                this.sockets = new MultiplexedDatagramSocket[]{socket};
            } else {
                MultiplexedDatagramSocket[] newSockets = new MultiplexedDatagramSocket[socketCount + 1];
                System.arraycopy(this.sockets, 0, newSockets, 0, socketCount);
                newSockets[socketCount] = socket;
                this.sockets = newSockets;
            }
            return socket;
        }
    }

    @Override
    public void receive(DatagramPacket p) throws SocketTimeoutException, IOException {
        this.receive(this.received, p, this.soTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive(List<DatagramPacket> received, DatagramPacket p, int timeout) throws SocketTimeoutException, IOException {
        long start = System.currentTimeMillis();
        DatagramPacket r = null;
        while (true) {
            boolean wait;
            long now = System.currentTimeMillis();
            if (timeout > 0 && now - start >= (long)timeout) {
                throw new SocketTimeoutException("Socket timeout");
            }
            List<DatagramPacket> list = received;
            synchronized (list) {
                if (!received.isEmpty() && (r = received.remove(0)) != null) {
                    break;
                }
            }
            Object object = this.receiveSyncRoot;
            synchronized (object) {
                if (this.inReceive) {
                    wait = true;
                } else {
                    wait = false;
                    this.inReceive = true;
                }
            }
            try {
                if (wait) {
                    object = received;
                    synchronized (object) {
                        if (received.isEmpty()) {
                            try {
                                received.wait(timeout > 0 ? (long)timeout - (now - start) : 1000L);
                            }
                            catch (InterruptedException ie) {}
                        } else {
                            received.notifyAll();
                        }
                        continue;
                    }
                }
                DatagramPacket c = MultiplexingDatagramSocket.clone(p);
                Object object2 = this.receiveSyncRoot;
                synchronized (object2) {
                    block50: {
                        if (this.setReceiveBufferSize) {
                            this.setReceiveBufferSize = false;
                            try {
                                super.setReceiveBufferSize(this.receiveBufferSize);
                            }
                            catch (Throwable t) {
                                if (!(t instanceof ThreadDeath)) break block50;
                                throw (ThreadDeath)t;
                            }
                        }
                    }
                }
                super.receive(c);
                object2 = this.socketsSyncRoot;
                synchronized (object2) {
                    boolean accepted = false;
                    for (MultiplexedDatagramSocket socket : this.sockets) {
                        if (!socket.getFilter().accept(c)) continue;
                        List<DatagramPacket> list2 = socket.received;
                        synchronized (list2) {
                            socket.received.add(accepted ? MultiplexingDatagramSocket.clone(c) : c);
                            socket.received.notifyAll();
                        }
                        accepted = true;
                    }
                    if (!accepted) {
                        List<DatagramPacket> list3 = this.received;
                        synchronized (list3) {
                            this.received.add(c);
                            this.received.notifyAll();
                        }
                    }
                    continue;
                }
            }
            finally {
                object = this.receiveSyncRoot;
                synchronized (object) {
                    if (!wait) {
                        this.inReceive = false;
                    }
                }
                continue;
            }
            break;
        }
        MultiplexingDatagramSocket.copy(r, p);
    }

    void receive(MultiplexedDatagramSocket multiplexed, DatagramPacket p) throws SocketTimeoutException, IOException {
        this.receive(multiplexed.received, p, multiplexed.getSoTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReceiveBufferSize(int receiveBufferSize) throws SocketException {
        Object object = this.receiveSyncRoot;
        synchronized (object) {
            this.receiveBufferSize = receiveBufferSize;
            if (this.inReceive) {
                this.setReceiveBufferSize = true;
            } else {
                super.setReceiveBufferSize(receiveBufferSize);
                this.setReceiveBufferSize = false;
            }
        }
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        super.setSoTimeout(timeout);
        this.soTimeout = timeout;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }
}

