/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.sctp4j;

import java.io.IOException;
import org.jitsi.sctp4j.NetworkLink;
import org.jitsi.sctp4j.Sctp;
import org.jitsi.sctp4j.SctpDataCallback;
import org.jitsi.sctp4j.SctpNotification;
import org.jitsi.util.Logger;

public class SctpSocket {
    private static final Logger logger = Logger.getLogger(SctpSocket.class);
    long socketPtr;
    int localPort;
    private NetworkLink link;
    private SctpDataCallback dataCallback;
    private NotificationListener notificationListener = new NotificationListener(){

        @Override
        public void onSctpNotification(SctpSocket socket, SctpNotification notification) {
            logger.trace("SctpSocket(0x" + SctpSocket.this.socketPtr + ")event: " + notification);
        }
    };

    SctpSocket(long socketPtr, int localPort) {
        if (socketPtr == 0L) {
            throw new NullPointerException();
        }
        this.socketPtr = socketPtr;
        this.localPort = localPort;
    }

    public void setLink(NetworkLink link) {
        this.link = link;
    }

    public int getPort() {
        return this.localPort;
    }

    public synchronized void listen() throws IOException {
        this.checkIsPointerValid();
        Sctp.usrsctp_listen(this.socketPtr);
    }

    public synchronized boolean accept() throws IOException {
        this.checkIsPointerValid();
        return Sctp.usrsctp_accept(this.socketPtr);
    }

    public synchronized void connect(int remotePort) throws IOException {
        this.checkIsPointerValid();
        if (!Sctp.usrsctp_connect(this.socketPtr, remotePort)) {
            throw new IOException("Failed to connect SCTP");
        }
    }

    public synchronized int send(byte[] data, boolean ordered, int sid, int ppid) throws IOException {
        this.checkIsPointerValid();
        return Sctp.usrsctp_send(this.socketPtr, data, ordered, sid, ppid);
    }

    int onSctpOut(byte[] packet, int tos, int set_df) {
        if (this.link == null) {
            return -1;
        }
        try {
            this.link.onConnOut(this, packet);
            return 0;
        }
        catch (IOException e) {
            logger.error("Error while sending packet trough the link: " + this.link, e);
            return -1;
        }
    }

    void onSctpIn(byte[] data, int sid, int ssn, int tsn, long ppid, int context, int flags) {
        if (this.dataCallback != null) {
            this.dataCallback.onSctpPacket(data, sid, ssn, tsn, ppid, context, flags);
        }
    }

    public void setDataCallback(SctpDataCallback callback) {
        this.dataCallback = callback;
    }

    public synchronized void onConnIn(byte[] packet) throws IOException {
        if (packet == null) {
            throw new NullPointerException("packet");
        }
        this.checkIsPointerValid();
        Sctp.onConnIn(this.socketPtr, packet);
    }

    public synchronized void close() {
        if (this.socketPtr != 0L) {
            Sctp.closeSocket(this.socketPtr);
            this.socketPtr = 0L;
        }
    }

    private void checkIsPointerValid() throws IOException {
        if (this.socketPtr == 0L) {
            throw new IOException("Socket is closed");
        }
    }

    public void setNotificationListener(NotificationListener l) {
        this.notificationListener = l;
    }

    void onNotification(SctpNotification notification) {
        if (this.notificationListener != null) {
            this.notificationListener.onSctpNotification(this, notification);
        }
    }

    public static synchronized void debugSctpPacket(byte[] packet, String id) {
        System.out.println(id);
        if (packet.length >= 12) {
            boolean i = false;
            int srcPort = SctpSocket.bytes_to_short(packet, 0);
            int dstPort = SctpSocket.bytes_to_short(packet, 2);
            long verificationTag = SctpSocket.bytes_to_long(packet, 4);
            long checksum = SctpSocket.bytes_to_long(packet, 8);
            logger.debug("SRC P: " + srcPort + " DST P: " + dstPort + " VTAG: 0x" + Long.toHexString(verificationTag) + " CHK: 0x" + Long.toHexString(checksum));
            SctpSocket.debugChunks(packet);
        }
    }

    static void debugChunks(byte[] packet) {
        int offset = 12;
        while (packet.length - offset >= 4) {
            int chunkType = packet[offset++] & 0xFF;
            int chunkFlags = packet[offset++] & 0xFF;
            int chunkLength = SctpSocket.bytes_to_short(packet, offset);
            offset += 2;
            logger.debug("CH: " + chunkType + " FL: " + chunkFlags + " L: " + chunkLength);
            if (chunkType == 1) {
                long initTag = SctpSocket.bytes_to_long(packet, offset);
                long a_rwnd = SctpSocket.bytes_to_long(packet, offset += 4);
                int nOutStream = SctpSocket.bytes_to_short(packet, offset += 4);
                int nInStream = SctpSocket.bytes_to_short(packet, offset += 2);
                long initTSN = SctpSocket.bytes_to_long(packet, offset += 2);
                offset += 4;
                logger.debug("ITAG: 0x" + Long.toHexString(initTag) + " a_rwnd: " + a_rwnd + " nOutStream: " + nOutStream + " nInStream: " + nInStream + " initTSN: 0x" + Long.toHexString(initTSN));
                offset += chunkLength - 4 - 16;
                continue;
            }
            if (chunkType == 0) {
                boolean U = (chunkFlags & 4) > 0;
                boolean B = (chunkFlags & 2) > 0;
                boolean E = (chunkFlags & 1) > 0;
                long TSN = SctpSocket.bytes_to_long(packet, offset);
                int streamIdS = SctpSocket.bytes_to_short(packet, offset += 4);
                int streamSeq = SctpSocket.bytes_to_short(packet, offset += 2);
                long PPID = SctpSocket.bytes_to_long(packet, offset += 2);
                offset += 4;
                logger.debug("U: " + U + " B: " + B + " E: " + E + " TSN: 0x" + Long.toHexString(TSN) + " SID: 0x" + Integer.toHexString(streamIdS) + " SSEQ: 0x" + Integer.toHexString(streamSeq) + " PPID: 0x" + Long.toHexString(PPID));
                offset += chunkLength - 4 - 12;
                continue;
            }
            if (chunkType == 6) {
                logger.debug("We have abort!!!");
                if (offset >= chunkLength) {
                    logger.debug("No abort CAUSE!!!");
                }
                while (offset < chunkLength) {
                    int causeCode = SctpSocket.bytes_to_short(packet, offset);
                    int causeLength = SctpSocket.bytes_to_short(packet, offset += 2);
                    offset += 2;
                    logger.debug("Cause: " + causeCode + " L: " + causeLength);
                }
                continue;
            }
            offset += chunkLength - 4;
        }
    }

    private static long bytes_to_long(byte[] buffer, int offset) {
        int fByte = 0xFF & buffer[offset];
        int sByte = 0xFF & buffer[offset + 1];
        int tByte = 0xFF & buffer[offset + 2];
        int foByte = 0xFF & buffer[offset + 3];
        return (long)(fByte << 24 | sByte << 16 | tByte << 8 | foByte) & 0xFFFFFFFFL;
    }

    private static int bytes_to_short(byte[] buffer, int offset) {
        int fByte = 0xFF & buffer[offset];
        int sByte = 0xFF & buffer[offset + 1];
        return (fByte << 8 | sByte) & 0xFFFF;
    }

    public static interface NotificationListener {
        public void onSctpNotification(SctpSocket var1, SctpNotification var2);
    }
}

