/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.util.ServiceUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.rest.JSONDeserializer;
import org.jitsi.videobridge.rest.JSONSerializer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.osgi.framework.BundleContext;

class HandlerImpl
extends AbstractHandler {
    private static final String CONFERENCES = "conferences";
    private static final String DEFAULT_COLIBRI_TARGET = "/colibri/";
    private static final String DEFAULT_JSON_TARGET = null;
    private static final String GET_HTTP_METHOD = "GET";
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String JSON_CONTENT_TYPE_WITH_CHARSET = "application/json;charset=UTF-8";
    private static final String PATCH_HTTP_METHOD = "PATCH";
    private static final String POST_HTTP_METHOD = "POST";
    private final BundleContext bundleContext;
    private String colibriTarget;
    private String jsonTarget;

    public HandlerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.colibriTarget = DEFAULT_COLIBRI_TARGET;
        if (!this.colibriTarget.endsWith("/")) {
            this.colibriTarget = this.colibriTarget + "/";
        }
        this.jsonTarget = DEFAULT_JSON_TARGET;
        if (this.jsonTarget != null && !this.jsonTarget.startsWith(".")) {
            this.jsonTarget = "." + this.jsonTarget;
        }
    }

    private void doGetConferenceJSON(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Videobridge videobridge = this.getVideobridge();
        if (videobridge == null) {
            response.setStatus(503);
        } else {
            Conference conference = videobridge.getConference(target, null);
            if (conference == null) {
                response.setStatus(404);
            } else {
                ColibriConferenceIQ conferenceIQ = new ColibriConferenceIQ();
                conference.describeDeep(conferenceIQ);
                JSONObject conferenceJSONObject = JSONSerializer.serializeConference(conferenceIQ);
                if (conferenceJSONObject == null) {
                    response.setStatus(500);
                } else {
                    response.setStatus(200);
                    conferenceJSONObject.writeJSONString((Writer)response.getWriter());
                }
            }
        }
    }

    private void doGetConferencesJSON(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Videobridge videobridge = this.getVideobridge();
        if (videobridge == null) {
            response.setStatus(503);
        } else {
            Conference[] conferences = videobridge.getConferences();
            ArrayList<ColibriConferenceIQ> conferenceIQs = new ArrayList<ColibriConferenceIQ>();
            for (Conference conference : conferences) {
                ColibriConferenceIQ conferenceIQ = new ColibriConferenceIQ();
                conferenceIQ.setID(conference.getID());
                conferenceIQs.add(conferenceIQ);
            }
            JSONArray conferencesJSONArray = JSONSerializer.serializeConferences(conferenceIQs);
            if (conferencesJSONArray == null) {
                conferencesJSONArray = new JSONArray();
            }
            response.setStatus(200);
            conferencesJSONArray.writeJSONString((Writer)response.getWriter());
        }
    }

    private void doPatchConferenceJSON(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Videobridge videobridge = this.getVideobridge();
        if (videobridge == null) {
            response.setStatus(503);
        } else {
            Conference conference = videobridge.getConference(target, null);
            if (conference == null) {
                response.setStatus(404);
            } else if (this.isJSONContentType(request.getContentType())) {
                Object requestJSONObject = null;
                int status = 0;
                try {
                    requestJSONObject = new JSONParser().parse((Reader)request.getReader());
                    if (requestJSONObject == null || !(requestJSONObject instanceof JSONObject)) {
                        status = 400;
                    }
                }
                catch (ParseException pe) {
                    status = 400;
                }
                if (status == 0) {
                    ColibriConferenceIQ requestConferenceIQ = JSONDeserializer.deserializeConference((JSONObject)requestJSONObject);
                    if (requestConferenceIQ == null || requestConferenceIQ.getID() != null && !requestConferenceIQ.getID().equals(conference.getID())) {
                        status = 400;
                    } else {
                        ColibriConferenceIQ responseConferenceIQ = null;
                        try {
                            responseConferenceIQ = videobridge.handleColibriConferenceIQ(requestConferenceIQ, 1);
                        }
                        catch (Exception e) {
                            status = 500;
                        }
                        if (status == 0) {
                            JSONObject responseJSONObject = JSONSerializer.serializeConference(responseConferenceIQ);
                            if (responseJSONObject == null) {
                                responseJSONObject = new JSONObject();
                            }
                            response.setStatus(200);
                            responseJSONObject.writeJSONString((Writer)response.getWriter());
                        }
                    }
                }
                if (status != 0) {
                    response.setStatus(status);
                }
            } else {
                response.setStatus(406);
            }
        }
    }

    private void doPostConferencesJSON(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Videobridge videobridge = this.getVideobridge();
        if (videobridge == null) {
            response.setStatus(503);
        } else if (this.isJSONContentType(request.getContentType())) {
            Object requestJSONObject = null;
            int status = 0;
            try {
                requestJSONObject = new JSONParser().parse((Reader)request.getReader());
                if (requestJSONObject == null || !(requestJSONObject instanceof JSONObject)) {
                    status = 400;
                }
            }
            catch (ParseException pe) {
                status = 400;
            }
            if (status == 0) {
                ColibriConferenceIQ requestConferenceIQ = JSONDeserializer.deserializeConference((JSONObject)requestJSONObject);
                if (requestConferenceIQ == null || requestConferenceIQ.getID() != null) {
                    status = 400;
                } else {
                    ColibriConferenceIQ responseConferenceIQ = null;
                    try {
                        responseConferenceIQ = videobridge.handleColibriConferenceIQ(requestConferenceIQ, 1);
                    }
                    catch (Exception e) {
                        status = 500;
                    }
                    if (status == 0) {
                        JSONObject responseJSONObject = JSONSerializer.serializeConference(responseConferenceIQ);
                        if (responseJSONObject == null) {
                            responseJSONObject = new JSONObject();
                        }
                        response.setStatus(200);
                        responseJSONObject.writeJSONString((Writer)response.getWriter());
                    }
                }
            }
            if (status != 0) {
                response.setStatus(status);
            }
        } else {
            response.setStatus(406);
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Videobridge getVideobridge() {
        BundleContext bundleContext = this.getBundleContext();
        Videobridge videobridge = bundleContext == null ? null : (Videobridge)ServiceUtils.getService((BundleContext)bundleContext, Videobridge.class);
        return videobridge;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (target != null && target.startsWith(this.colibriTarget)) {
            int jsonTargetLength;
            target = target.substring(this.colibriTarget.length());
            int n = jsonTargetLength = this.jsonTarget == null ? 0 : this.jsonTarget.length();
            if (jsonTargetLength == 0 || target.endsWith(this.jsonTarget)) {
                target = target.substring(0, target.length() - jsonTargetLength);
                response.setContentType(JSON_CONTENT_TYPE_WITH_CHARSET);
                this.handleColibriJSON(target, baseRequest, request, response);
                if (!baseRequest.isHandled()) {
                    if (response.getStatus() == 0) {
                        response.setStatus(404);
                    }
                    baseRequest.setHandled(true);
                }
            }
        }
    }

    private void handleColibriJSON(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (target != null && target.startsWith(CONFERENCES)) {
            if ((target = target.substring(CONFERENCES.length())).startsWith("/")) {
                target = target.substring(1);
            }
            String requestMethod = request.getMethod();
            if ("".equals(target)) {
                if (GET_HTTP_METHOD.equals(requestMethod)) {
                    this.doGetConferencesJSON(baseRequest, request, response);
                } else if (POST_HTTP_METHOD.equals(requestMethod)) {
                    this.doPostConferencesJSON(baseRequest, request, response);
                } else {
                    response.setStatus(405);
                }
            } else if (GET_HTTP_METHOD.equals(requestMethod)) {
                this.doGetConferenceJSON(target, baseRequest, request, response);
            } else if (PATCH_HTTP_METHOD.equals(requestMethod)) {
                this.doPatchConferenceJSON(target, baseRequest, request, response);
            } else {
                response.setStatus(405);
            }
        }
    }

    private boolean isJSONContentType(String contentType) {
        return JSON_CONTENT_TYPE.equals(contentType) || JSON_CONTENT_TYPE_WITH_CHARSET.equals(contentType);
    }
}

