/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.Logger;
import org.jitsi.util.event.PropertyChangeNotifier;
import org.jitsi.util.event.WeakReferencePropertyChangeListener;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.ConferenceSpeechActivity;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.Videobridge;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conference
extends PropertyChangeNotifier
implements PropertyChangeListener {
    public static final String ENDPOINTS_PROPERTY_NAME = Conference.class.getName() + ".endpoints";
    private static final Logger logger = Logger.getLogger(Conference.class);
    private final List<Content> contents = new LinkedList<Content>();
    private final List<WeakReference<Endpoint>> endpoints = new LinkedList<WeakReference<Endpoint>>();
    private boolean expired = false;
    private final String focus;
    private final String id;
    private long lastActivityTime;
    private final PropertyChangeListener propertyChangeListener;
    private final ConferenceSpeechActivity speechActivity;
    private final Videobridge videobridge;

    private static void logd(String s) {
        logger.info((Object)s);
    }

    public Conference(Videobridge videobridge, String id, String focus) {
        if (videobridge == null) {
            throw new NullPointerException("videobridge");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.videobridge = videobridge;
        this.id = id;
        this.focus = focus;
        this.propertyChangeListener = new WeakReferencePropertyChangeListener((PropertyChangeListener)this);
        this.speechActivity = new ConferenceSpeechActivity(this);
        this.speechActivity.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void describeDeep(ColibriConferenceIQ iq) {
        this.describeShallow(iq);
        for (Content content : this.getContents()) {
            ColibriConferenceIQ.Content contentIQ = iq.getOrCreateContent(content.getName());
            for (Channel channel : content.getChannels()) {
                ColibriConferenceIQ.Channel channelIQ = new ColibriConferenceIQ.Channel();
                channel.describe(channelIQ);
                contentIQ.addChannel(channelIQ);
            }
        }
    }

    public void describeShallow(ColibriConferenceIQ iq) {
        iq.setID(this.getID());
    }

    private void dominantSpeakerChanged() {
        Endpoint dominantSpeaker = this.speechActivity.getDominantEndpoint();
        Conference.logd("The dominant speaker in conference " + this.getID() + " is now the endpoint " + (dominantSpeaker == null ? "(null)" : dominantSpeaker.getID()) + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        Conference conference = this;
        synchronized (conference) {
            if (this.expired) {
                return;
            }
            this.expired = true;
        }
        Videobridge videobridge = this.getVideobridge();
        try {
            videobridge.expireConference(this);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            for (Content content : this.getContents()) {
                try {
                    content.expire();
                }
                catch (Throwable t) {
                    logger.warn((Object)("Failed to expire content " + content.getName() + " of conference " + this.getID() + "!"), t);
                    if (!(t instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)t;
                }
            }
            Conference.logd("Expired conference " + this.getID() + ". The total number of" + " conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + ".");
            throw throwable;
        }
        for (Content content : this.getContents()) {
            try {
                content.expire();
            }
            catch (Throwable t) {
                logger.warn((Object)("Failed to expire content " + content.getName() + " of conference " + this.getID() + "!"), t);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        {
        }
        Conference.logd("Expired conference " + this.getID() + ". The total number of" + " conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireContent(Content content) {
        boolean expireContent;
        List<Content> list = this.contents;
        synchronized (list) {
            if (this.contents.contains(content)) {
                this.contents.remove(content);
                expireContent = true;
            } else {
                expireContent = false;
            }
        }
        if (expireContent) {
            content.expire();
        }
    }

    Channel findChannelByReceiveSSRC(long receiveSSRC, MediaType mediaType) {
        for (Content content : this.getContents()) {
            Channel channel;
            if (!mediaType.equals((Object)content.getMediaType()) || (channel = content.findChannelByReceiveSSRC(receiveSSRC)) == null) continue;
            return channel;
        }
        return null;
    }

    Endpoint findEndpointByReceiveSSRC(long receiveSSRC, MediaType mediaType) {
        Channel channel = this.findChannelByReceiveSSRC(receiveSSRC, mediaType);
        return channel == null ? null : channel.getEndpoint();
    }

    public BundleContext getBundleContext() {
        return this.getVideobridge().getBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Content[] getContents() {
        List<Content> list = this.contents;
        synchronized (list) {
            return this.contents.toArray(new Content[this.contents.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Endpoint> getEndpoints() {
        ArrayList<Endpoint> endpoints;
        boolean changed = false;
        List<WeakReference<Endpoint>> list = this.endpoints;
        synchronized (list) {
            endpoints = new ArrayList<Endpoint>(this.endpoints.size());
            Iterator<WeakReference<Endpoint>> i = this.endpoints.iterator();
            while (i.hasNext()) {
                Endpoint endpoint = (Endpoint)((Object)i.next().get());
                if (endpoint == null) {
                    i.remove();
                    changed = true;
                    continue;
                }
                endpoints.add(endpoint);
            }
        }
        if (changed) {
            this.firePropertyChange(ENDPOINTS_PROPERTY_NAME, null, null);
        }
        return endpoints;
    }

    public final String getFocus() {
        return this.focus;
    }

    public final String getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastActivityTime() {
        Conference conference = this;
        synchronized (conference) {
            return this.lastActivityTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Content getOrCreateContent(String name) {
        Content content;
        List<Content> list = this.contents;
        synchronized (list) {
            for (Content aContent : this.contents) {
                if (!aContent.getName().equals(name)) continue;
                aContent.touch();
                return aContent;
            }
            content = new Content(this, name);
            this.contents.add(content);
        }
        Videobridge videobridge = this.getVideobridge();
        Conference.logd("Created content " + name + " of conference " + this.getID() + ". The total number of conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + ".");
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getOrCreateEndpoint(String id) {
        Endpoint endpoint = null;
        boolean changed = false;
        List<WeakReference<Endpoint>> list = this.endpoints;
        synchronized (list) {
            Iterator<WeakReference<Endpoint>> i = this.endpoints.iterator();
            while (i.hasNext()) {
                Endpoint e = (Endpoint)((Object)i.next().get());
                if (e == null) {
                    i.remove();
                    changed = true;
                    continue;
                }
                if (!e.getID().equals(id)) continue;
                endpoint = e;
            }
            if (endpoint == null) {
                endpoint = new Endpoint(id);
                endpoint.addPropertyChangeListener(this.propertyChangeListener);
                this.endpoints.add(new WeakReference<Endpoint>(endpoint));
                changed = true;
            }
        }
        if (changed) {
            this.firePropertyChange(ENDPOINTS_PROPERTY_NAME, null, null);
        }
        return endpoint;
    }

    ConferenceSpeechActivity getSpeechActivity() {
        return this.speechActivity;
    }

    public final Videobridge getVideobridge() {
        return this.videobridge;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        Object source = ev.getSource();
        if (this.speechActivity == source) {
            String propertyName = ev.getPropertyName();
            if (ConferenceSpeechActivity.DOMINANT_ENDPOINT_PROPERTY_NAME.equals(propertyName)) {
                this.dominantSpeakerChanged();
            } else if (ConferenceSpeechActivity.ENDPOINTS_PROPERTY_NAME.equals(propertyName)) {
                this.speechActivityEndpointsChanged();
            }
        }
    }

    private void speechActivityEndpointsChanged() {
        List<Endpoint> endpoints = null;
        for (Content content : this.getContents()) {
            if (!MediaType.VIDEO.equals((Object)content.getMediaType())) continue;
            HashSet<Endpoint> endpointsToAskForKeyframes = null;
            endpoints = this.speechActivity.getEndpoints();
            for (Channel channel : content.getChannels()) {
                List<Endpoint> channelEndpointsToAskForKeyframes = channel.lastNEndpointsChanged(endpoints);
                if (channelEndpointsToAskForKeyframes == null || channelEndpointsToAskForKeyframes.isEmpty()) continue;
                if (endpointsToAskForKeyframes == null) {
                    endpointsToAskForKeyframes = new HashSet<Endpoint>();
                }
                endpointsToAskForKeyframes.addAll(channelEndpointsToAskForKeyframes);
            }
            if (endpointsToAskForKeyframes == null || endpointsToAskForKeyframes.isEmpty()) continue;
            content.askForKeyframes((Set<Endpoint>)endpointsToAskForKeyframes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch() {
        long now = System.currentTimeMillis();
        Conference conference = this;
        synchronized (conference) {
            if (this.getLastActivityTime() < now) {
                this.lastActivityTime = now;
            }
        }
    }
}

