/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.com.eclipsesource.json.JsonArray;
import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.com.eclipsesource.json.JsonValue;

public final class JsonUtil {
    private JsonUtil() {
    }

    public static int getInt(JsonObject object, String field) {
        JsonValue value = object.get(field);
        JsonUtil.throwExceptionIfNull(value, field);
        return value.asInt();
    }

    public static int getInt(JsonObject object, String field, int defaultValue) {
        JsonValue value = object.get(field);
        if (value == null) {
            return defaultValue;
        }
        return value.asInt();
    }

    public static long getLong(JsonObject object, String field) {
        JsonValue value = object.get(field);
        JsonUtil.throwExceptionIfNull(value, field);
        return value.asLong();
    }

    public static long getLong(JsonObject object, String field, long defaultValue) {
        JsonValue value = object.get(field);
        if (value == null) {
            return defaultValue;
        }
        return value.asLong();
    }

    public static double getDouble(JsonObject object, String field) {
        JsonValue value = object.get(field);
        JsonUtil.throwExceptionIfNull(value, field);
        return value.asDouble();
    }

    public static double getDouble(JsonObject object, String field, double defaultValue) {
        JsonValue value = object.get(field);
        if (value == null) {
            return defaultValue;
        }
        return value.asDouble();
    }

    public static float getFloat(JsonObject object, String field) {
        JsonValue value = object.get(field);
        JsonUtil.throwExceptionIfNull(value, field);
        return value.asFloat();
    }

    public static float getFloat(JsonObject object, String field, float defaultValue) {
        JsonValue value = object.get(field);
        if (value == null) {
            return defaultValue;
        }
        return value.asFloat();
    }

    public static String getString(JsonObject object, String field) {
        JsonValue value = object.get(field);
        JsonUtil.throwExceptionIfNull(value, field);
        return value.asString();
    }

    public static String getString(JsonObject object, String field, String defaultValue) {
        JsonValue value = object.get(field);
        if (value == null) {
            return defaultValue;
        }
        return value.asString();
    }

    public static boolean getBoolean(JsonObject object, String field) {
        JsonValue value = object.get(field);
        JsonUtil.throwExceptionIfNull(value, field);
        return value.asBoolean();
    }

    public static boolean getBoolean(JsonObject object, String field, boolean defaultValue) {
        JsonValue value = object.get(field);
        if (value == null) {
            return defaultValue;
        }
        return value.asBoolean();
    }

    public static JsonArray getArray(JsonObject object, String field) {
        JsonValue value = object.get(field);
        JsonUtil.throwExceptionIfNull(value, field);
        return value.asArray();
    }

    public static JsonArray getArray(JsonObject object, String field, JsonArray defaultValue) {
        JsonValue value = object.get(field);
        if (value == null) {
            return defaultValue;
        }
        return value.asArray();
    }

    public static JsonObject getObject(JsonObject object, String field) {
        JsonValue value = object.get(field);
        JsonUtil.throwExceptionIfNull(value, field);
        return value.asObject();
    }

    public static JsonObject getObject(JsonObject object, String field, JsonObject defaultValue) {
        JsonValue value = object.get(field);
        if (value == null) {
            return defaultValue;
        }
        return value.asObject();
    }

    private static void throwExceptionIfNull(JsonValue value, String field) {
        if (value == null) {
            throw new IllegalArgumentException("No field found named : " + field);
        }
    }
}

