/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CachePortableHook;
import com.hazelcast.cache.impl.operation.CacheKeyIteratorOperation;
import com.hazelcast.client.impl.client.PartitionClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class CacheIterateRequest
extends PartitionClientRequest
implements RetryableRequest {
    private String name;
    private int partitionId;
    private int tableIndex;
    private int batch;

    public CacheIterateRequest() {
    }

    public CacheIterateRequest(String name, int partitionId, int tableIndex, int batch) {
        this.name = name;
        this.partitionId = partitionId;
        this.tableIndex = tableIndex;
        this.batch = batch;
    }

    @Override
    protected Operation prepareOperation() {
        return new CacheKeyIteratorOperation(this.name, this.tableIndex, this.batch);
    }

    @Override
    protected int getPartition() {
        return this.partitionId;
    }

    @Override
    public final int getFactoryId() {
        return CachePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 11;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("n", this.name);
        writer.writeInt("p", this.partitionId);
        writer.writeInt("t", this.tableIndex);
        writer.writeInt("b", this.batch);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readUTF("n");
        this.partitionId = reader.readInt("p");
        this.tableIndex = reader.readInt("t");
        this.batch = reader.readInt("b");
    }
}

