/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util;

import java.lang.reflect.Field;

public final class Debug {
    public static int m_debugLevel = 0;

    public static final void println(String string) {
        Debug.println(3, string);
    }

    public static final void stAssert(boolean bl) {
        if (!bl && m_debugLevel != 0) {
            throw new RuntimeException("Assertion failed.");
        }
    }

    public static final boolean isDebugLevel(int n2) {
        return m_debugLevel >= n2;
    }

    public static final void print(int n2, String string) {
        if (n2 <= m_debugLevel) {
            System.err.print(string);
        }
    }

    public static final void print(String string) {
        Debug.print(3, string);
    }

    public static final void printException(int n2, String string, Throwable throwable) {
        if (n2 <= m_debugLevel) {
            if (string != null) {
                System.err.println(string);
            }
            throwable.printStackTrace();
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("DebugLevel");
            Field field = clazz.getField("m_debugLevel");
            m_debugLevel = field.getInt(null);
            if (m_debugLevel != 0) {
                System.out.println("Debug level set to: " + m_debugLevel);
            }
        }
        catch (Exception exception) {}
    }

    public static final void printByte(int n2, byte[] byArray) {
        if (n2 > m_debugLevel) {
            return;
        }
        int n3 = 0;
        while (n3 < byArray.length) {
            System.err.println("");
            Debug.printByte(n2, (byte)(n3 >> 8));
            Debug.printByte(n2, (byte)(n3 & 0xFF));
            System.err.print(" -  ");
            int n4 = byArray.length - n3;
            int n5 = n4 > 16 ? 16 : n4;
            int n6 = 0;
            while (n6 < n5) {
                Debug.printByte(n2, byArray[n3 + n6]);
                System.err.print(" ");
                ++n6;
            }
            if (n5 < 16) {
                while (n6 < 16) {
                    System.err.print("   ");
                    ++n6;
                }
            }
            n6 = 0;
            while (n6 < n5) {
                if (byArray[n3 + n6] > 32 && byArray[n3 + n6] <= 127) {
                    System.err.print("" + (char)byArray[n3 + n6]);
                } else {
                    System.err.print(".");
                }
                ++n6;
            }
            n3 += 16;
        }
        System.err.println("");
    }

    public static final void printByte(int n2, byte by) {
        if (n2 > m_debugLevel) {
            return;
        }
        int n3 = by & 0xFF;
        String string = Integer.toHexString(n3);
        if (string.length() < 2) {
            string = "0" + string;
        }
        System.err.print(string);
    }

    public static final boolean isDebug() {
        return m_debugLevel >= 3;
    }

    public static final void println(int n2, String string) {
        if (n2 <= m_debugLevel) {
            System.err.println(string);
        }
    }
}

