/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.NodeInformationProvider;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.commands.AdHocCommand;
import org.jivesoftware.smackx.commands.LocalCommand;
import org.jivesoftware.smackx.commands.LocalCommandFactory;
import org.jivesoftware.smackx.commands.RemoteCommand;
import org.jivesoftware.smackx.packet.AdHocCommandData;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

public class AdHocCommandManager {
    private static final Logger LOGGER = Logger.getLogger(AdHocCommandManager.class.getName());
    private static final String DISCO_NAMESPACE = "http://jabber.org/protocol/commands";
    private static final String discoNode = "http://jabber.org/protocol/commands";
    private static final int SESSION_TIMEOUT = 120;
    private static Map<Connection, AdHocCommandManager> instances = new ConcurrentHashMap<Connection, AdHocCommandManager>();
    private Thread sessionsSweeper;
    private Connection connection;
    private Map<String, AdHocCommandInfo> commands = new ConcurrentHashMap<String, AdHocCommandInfo>();
    private Map<String, LocalCommand> executingCommands = new ConcurrentHashMap<String, LocalCommand>();

    public static AdHocCommandManager getAddHocCommandsManager(Connection connection) {
        return instances.get(connection);
    }

    private AdHocCommandManager(Connection connection) {
        this.connection = connection;
        this.init();
    }

    public void registerCommand(String node, String name, final Class clazz) {
        this.registerCommand(node, name, new LocalCommandFactory(){

            @Override
            public LocalCommand getInstance() throws InstantiationException, IllegalAccessException {
                return (LocalCommand)clazz.newInstance();
            }
        });
    }

    public void registerCommand(String node, final String name, LocalCommandFactory factory) {
        AdHocCommandInfo commandInfo = new AdHocCommandInfo(node, name, this.connection.getUser(), factory);
        this.commands.put(node, commandInfo);
        ServiceDiscoveryManager.getInstanceFor(this.connection).setNodeInformationProvider(node, new NodeInformationProvider(){

            @Override
            public List<DiscoverItems.Item> getNodeItems() {
                return null;
            }

            @Override
            public List<String> getNodeFeatures() {
                ArrayList<String> answer = new ArrayList<String>();
                answer.add("http://jabber.org/protocol/commands");
                answer.add("jabber:x:data");
                return answer;
            }

            @Override
            public List<DiscoverInfo.Identity> getNodeIdentities() {
                ArrayList<DiscoverInfo.Identity> answer = new ArrayList<DiscoverInfo.Identity>();
                DiscoverInfo.Identity identity = new DiscoverInfo.Identity("automation", name);
                identity.setType("command-node");
                answer.add(identity);
                return answer;
            }
        });
    }

    public DiscoverItems discoverCommands(String jid) throws XMPPException {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        return serviceDiscoveryManager.discoverItems(jid, "http://jabber.org/protocol/commands");
    }

    public void publishCommands(String jid) throws XMPPException {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        DiscoverItems discoverItems = new DiscoverItems();
        Collection<AdHocCommandInfo> xCommandsList = this.getRegisteredCommands();
        for (AdHocCommandInfo info : xCommandsList) {
            DiscoverItems.Item item = new DiscoverItems.Item(info.getOwnerJID());
            item.setName(info.getName());
            item.setNode(info.getNode());
            discoverItems.addItem(item);
        }
        serviceDiscoveryManager.publishItems(jid, "http://jabber.org/protocol/commands", discoverItems);
    }

    public RemoteCommand getRemoteCommand(String jid, String node) {
        return new RemoteCommand(this.connection, node, jid);
    }

    private void init() {
        instances.put(this.connection, this);
        this.connection.addConnectionListener(new ConnectionListener(){

            public void connectionClosed() {
                instances.remove(AdHocCommandManager.this.connection);
            }

            public void connectionClosedOnError(Exception e) {
                instances.remove(AdHocCommandManager.this.connection);
            }

            public void reconnectionSuccessful() {
                instances.put(AdHocCommandManager.this.connection, AdHocCommandManager.this);
            }

            public void reconnectingIn(int seconds) {
            }

            public void reconnectionFailed(Exception e) {
            }
        });
        ServiceDiscoveryManager.getInstanceFor(this.connection).addFeature("http://jabber.org/protocol/commands");
        ServiceDiscoveryManager.getInstanceFor(this.connection).setNodeInformationProvider("http://jabber.org/protocol/commands", new NodeInformationProvider(){

            @Override
            public List<DiscoverItems.Item> getNodeItems() {
                ArrayList<DiscoverItems.Item> answer = new ArrayList<DiscoverItems.Item>();
                Collection commandsList = AdHocCommandManager.this.getRegisteredCommands();
                for (AdHocCommandInfo info : commandsList) {
                    DiscoverItems.Item item = new DiscoverItems.Item(info.getOwnerJID());
                    item.setName(info.getName());
                    item.setNode(info.getNode());
                    answer.add(item);
                }
                return answer;
            }

            @Override
            public List<String> getNodeFeatures() {
                return null;
            }

            @Override
            public List<DiscoverInfo.Identity> getNodeIdentities() {
                return null;
            }
        });
        PacketListener listener = new PacketListener(){

            public void processPacket(Packet packet) {
                AdHocCommandData requestData = (AdHocCommandData)packet;
                AdHocCommandManager.this.processAdHocCommand(requestData);
            }
        };
        PacketTypeFilter filter = new PacketTypeFilter(AdHocCommandData.class);
        this.connection.addPacketListener(listener, (PacketFilter)filter);
        this.sessionsSweeper = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    for (String sessionId : AdHocCommandManager.this.executingCommands.keySet()) {
                        LocalCommand command = (LocalCommand)AdHocCommandManager.this.executingCommands.get(sessionId);
                        if (command == null) continue;
                        long creationStamp = command.getCreationDate();
                        if (System.currentTimeMillis() - creationStamp <= 240000L) continue;
                        AdHocCommandManager.this.executingCommands.remove(sessionId);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        });
        this.sessionsSweeper.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAdHocCommand(AdHocCommandData requestData) {
        if (requestData.getType() != IQ.Type.SET) {
            return;
        }
        AdHocCommandData response = new AdHocCommandData();
        response.setTo(requestData.getFrom());
        response.setPacketID(requestData.getPacketID());
        response.setNode(requestData.getNode());
        response.setId(requestData.getTo());
        String sessionId = requestData.getSessionID();
        String commandNode = requestData.getNode();
        if (sessionId == null) {
            if (!this.commands.containsKey(commandNode)) {
                this.respondError(response, XMPPError.Condition.item_not_found);
                return;
            }
            sessionId = StringUtils.randomString((int)15);
            try {
                LocalCommand command = this.newInstanceOfCmd(commandNode, sessionId);
                response.setType(IQ.Type.RESULT);
                command.setData(response);
                if (!command.hasPermission(requestData.getFrom())) {
                    this.respondError(response, XMPPError.Condition.forbidden);
                    return;
                }
                AdHocCommand.Action action = requestData.getAction();
                if (action != null && action.equals((Object)AdHocCommand.Action.unknown)) {
                    this.respondError(response, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.malformedAction);
                    return;
                }
                if (action != null && !action.equals((Object)AdHocCommand.Action.execute)) {
                    this.respondError(response, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.badAction);
                    return;
                }
                command.incrementStage();
                command.execute();
                if (command.isLastStage()) {
                    response.setStatus(AdHocCommand.Status.completed);
                } else {
                    response.setStatus(AdHocCommand.Status.executing);
                    this.executingCommands.put(sessionId, command);
                    if (!this.sessionsSweeper.isAlive()) {
                        this.sessionsSweeper.start();
                    }
                }
                this.connection.sendPacket((Packet)response);
            }
            catch (XMPPException e) {
                XMPPError error = e.getXMPPError();
                if (XMPPError.Type.CANCEL.equals((Object)error.getType())) {
                    response.setStatus(AdHocCommand.Status.canceled);
                    this.executingCommands.remove(sessionId);
                }
                this.respondError(response, error);
                LOGGER.log(Level.SEVERE, "", e);
            }
        } else {
            LocalCommand command = this.executingCommands.get(sessionId);
            if (command == null) {
                this.respondError(response, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.badSessionid);
                return;
            }
            long creationStamp = command.getCreationDate();
            if (System.currentTimeMillis() - creationStamp > 120000L) {
                this.executingCommands.remove(sessionId);
                this.respondError(response, XMPPError.Condition.not_allowed, AdHocCommand.SpecificErrorCondition.sessionExpired);
                return;
            }
            LocalCommand localCommand = command;
            synchronized (localCommand) {
                AdHocCommand.Action action = requestData.getAction();
                if (action != null && action.equals((Object)AdHocCommand.Action.unknown)) {
                    this.respondError(response, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.malformedAction);
                    return;
                }
                if (action == null || AdHocCommand.Action.execute.equals((Object)action)) {
                    action = command.getExecuteAction();
                }
                if (!command.isValidAction(action)) {
                    this.respondError(response, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.badAction);
                    return;
                }
                try {
                    response.setType(IQ.Type.RESULT);
                    command.setData(response);
                    if (AdHocCommand.Action.next.equals((Object)action)) {
                        command.incrementStage();
                        command.next(new Form(requestData.getForm()));
                        if (command.isLastStage()) {
                            response.setStatus(AdHocCommand.Status.completed);
                        } else {
                            response.setStatus(AdHocCommand.Status.executing);
                        }
                    } else if (AdHocCommand.Action.complete.equals((Object)action)) {
                        command.incrementStage();
                        command.complete(new Form(requestData.getForm()));
                        response.setStatus(AdHocCommand.Status.completed);
                        this.executingCommands.remove(sessionId);
                    } else if (AdHocCommand.Action.prev.equals((Object)action)) {
                        command.decrementStage();
                        command.prev();
                    } else if (AdHocCommand.Action.cancel.equals((Object)action)) {
                        command.cancel();
                        response.setStatus(AdHocCommand.Status.canceled);
                        this.executingCommands.remove(sessionId);
                    }
                    this.connection.sendPacket((Packet)response);
                }
                catch (XMPPException e) {
                    XMPPError error = e.getXMPPError();
                    if (XMPPError.Type.CANCEL.equals((Object)error.getType())) {
                        response.setStatus(AdHocCommand.Status.canceled);
                        this.executingCommands.remove(sessionId);
                    }
                    this.respondError(response, error);
                    LOGGER.log(Level.SEVERE, "", e);
                }
            }
        }
    }

    private void respondError(AdHocCommandData response, XMPPError.Condition condition) {
        this.respondError(response, new XMPPError(condition));
    }

    private void respondError(AdHocCommandData response, XMPPError.Condition condition, AdHocCommand.SpecificErrorCondition specificCondition) {
        XMPPError error = new XMPPError(condition);
        error.addExtension((PacketExtension)new AdHocCommandData.SpecificError(specificCondition));
        this.respondError(response, error);
    }

    private void respondError(AdHocCommandData response, XMPPError error) {
        response.setType(IQ.Type.ERROR);
        response.setError(error);
        this.connection.sendPacket((Packet)response);
    }

    private LocalCommand newInstanceOfCmd(String commandNode, String sessionID) throws XMPPException {
        LocalCommand command;
        AdHocCommandInfo commandInfo = this.commands.get(commandNode);
        try {
            command = commandInfo.getCommandInstance();
            command.setSessionID(sessionID);
            command.setName(commandInfo.getName());
            command.setNode(commandInfo.getNode());
        }
        catch (InstantiationException e) {
            LOGGER.log(Level.SEVERE, "", e);
            throw new XMPPException(new XMPPError(XMPPError.Condition.interna_server_error));
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.SEVERE, "", e);
            throw new XMPPException(new XMPPError(XMPPError.Condition.interna_server_error));
        }
        return command;
    }

    private Collection<AdHocCommandInfo> getRegisteredCommands() {
        return this.commands.values();
    }

    static {
        Connection.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(Connection connection) {
                new AdHocCommandManager(connection);
            }
        });
    }

    private static class AdHocCommandInfo {
        private String node;
        private String name;
        private String ownerJID;
        private LocalCommandFactory factory;

        public AdHocCommandInfo(String node, String name, String ownerJID, LocalCommandFactory factory) {
            this.node = node;
            this.name = name;
            this.ownerJID = ownerJID;
            this.factory = factory;
        }

        public LocalCommand getCommandInstance() throws InstantiationException, IllegalAccessException {
            return this.factory.getInstance();
        }

        public String getName() {
            return this.name;
        }

        public String getNode() {
            return this.node;
        }

        public String getOwnerJID() {
            return this.ownerJID;
        }
    }
}

