/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import org.bouncycastle.crypto.ExtendedDigest;
import org.jitsi.util.JNIUtils;

public class OpenSSLDigest
implements ExtendedDigest {
    private static long EVP_sha1;
    private static boolean loadLibrary;
    public static final int SHA1 = 1;
    private final String algorithmName;
    private final int byteLength;
    private long ctx;
    private final int digestSize;
    private final long type;

    private static native int EVP_DigestFinal_ex(long var0, byte[] var2, int var3);

    private static native boolean EVP_DigestInit_ex(long var0, long var2, long var4);

    private static native boolean EVP_DigestUpdate(long var0, byte[] var2, int var3, int var4);

    private static native int EVP_MD_CTX_block_size(long var0);

    private static native long EVP_MD_CTX_create();

    private static native void EVP_MD_CTX_destroy(long var0);

    private static native int EVP_MD_CTX_size(long var0);

    private static native long EVP_sha1();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSSLDigest(int algorithm) {
        if (algorithm != 1) {
            throw new IllegalArgumentException("algorithm " + algorithm);
        }
        this.algorithmName = "SHA-1";
        Class<OpenSSLDigest> clazz = OpenSSLDigest.class;
        synchronized (OpenSSLDigest.class) {
            long EVP_sha1;
            if (loadLibrary) {
                try {
                    JNIUtils.loadLibrary("jnopenssl", OpenSSLDigest.class.getClassLoader());
                    OpenSSLDigest.EVP_sha1 = OpenSSLDigest.EVP_sha1();
                }
                finally {
                    loadLibrary = false;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (algorithm == 1) {
                EVP_sha1 = OpenSSLDigest.EVP_sha1;
                if (EVP_sha1 == 0L) {
                    throw new IllegalStateException("EVP_sha1");
                }
            } else {
                throw new IllegalArgumentException("algorithm " + algorithm);
            }
            long type = EVP_sha1;
            this.type = type;
            long ctx = OpenSSLDigest.EVP_MD_CTX_create();
            if (ctx == 0L) {
                throw new RuntimeException("EVP_MD_CTX_create");
            }
            boolean ok = false;
            this.ctx = ctx;
            try {
                this.reset();
                this.byteLength = OpenSSLDigest.EVP_MD_CTX_block_size(ctx);
                this.digestSize = OpenSSLDigest.EVP_MD_CTX_size(ctx);
                ok = true;
            }
            finally {
                if (!ok) {
                    if (this.ctx == ctx) {
                        this.ctx = 0L;
                    }
                    OpenSSLDigest.EVP_MD_CTX_destroy(ctx);
                }
            }
            return;
        }
    }

    public int doFinal(byte[] out, int off) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (off < 0 || out.length <= off) {
            throw new ArrayIndexOutOfBoundsException(off);
        }
        long ctx = this.ctx;
        if (ctx == 0L) {
            throw new IllegalStateException("ctx");
        }
        int s = OpenSSLDigest.EVP_DigestFinal_ex(ctx, out, off);
        if (s < 0) {
            throw new RuntimeException("EVP_DigestFinal_ex");
        }
        this.reset();
        return s;
    }

    protected void finalize() throws Throwable {
        try {
            long ctx = this.ctx;
            if (ctx != 0L) {
                this.ctx = 0L;
                OpenSSLDigest.EVP_MD_CTX_destroy(ctx);
            }
        }
        finally {
            super.finalize();
        }
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public int getDigestSize() {
        return this.digestSize;
    }

    public void reset() {
        long ctx = this.ctx;
        if (ctx == 0L) {
            throw new IllegalStateException("ctx");
        }
        if (!OpenSSLDigest.EVP_DigestInit_ex(ctx, this.type, 0L)) {
            throw new RuntimeException("EVP_DigestInit_ex(" + this.getAlgorithmName() + ")");
        }
    }

    public void update(byte in) {
    }

    public void update(byte[] in, int off, int len) {
        if (len != 0) {
            if (in == null) {
                throw new NullPointerException("in");
            }
            if (off < 0 || in.length <= off) {
                throw new ArrayIndexOutOfBoundsException(off);
            }
            if (len < 0 || in.length < off + len) {
                throw new IllegalArgumentException("len " + len);
            }
            long ctx = this.ctx;
            if (ctx == 0L) {
                throw new IllegalStateException("ctx");
            }
            if (!OpenSSLDigest.EVP_DigestUpdate(ctx, in, off, len)) {
                throw new RuntimeException("EVP_DigestUpdate");
            }
        }
    }

    static {
        loadLibrary = true;
    }
}

