/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.rtp.RTPSourceStream;

public class BufferControlImpl
implements BufferControl {
    private static final int AUDIO_DEFAULT_BUFFER = 250;
    private static final int AUDIO_DEFAULT_THRESHOLD = 125;
    private static final int AUDIO_MAX_BUFFER = 4000;
    private static final int AUDIO_MAX_THRESHOLD = 2000;
    private static final int NOT_SPECIFIED = Integer.MAX_VALUE;
    private static final int VIDEO_DEFAULT_BUFFER = 135;
    private static final int VIDEO_DEFAULT_THRESHOLD = 0;
    private static final int VIDEO_MAX_BUFFER = 4000;
    private static final int VIDEO_MAX_THRESHOLD = 0;
    BufferControlPanel controlComp = null;
    private long currBuffer = Integer.MAX_VALUE;
    private long currThreshold = Integer.MAX_VALUE;
    private long defBuffer = Integer.MAX_VALUE;
    private long defThreshold = Integer.MAX_VALUE;
    private boolean inited = false;
    private long maxBuffer = Integer.MAX_VALUE;
    private long maxThreshold = Integer.MAX_VALUE;
    private Vector<RTPSourceStream> sourcestreamlist = new Vector(1);
    boolean threshold_enabled = true;

    protected void addSourceStream(RTPSourceStream s) {
        this.sourcestreamlist.addElement(s);
        s.setBufferControl(this);
    }

    public long getBufferLength() {
        return this.currBuffer;
    }

    public Component getControlComponent() {
        if (this.controlComp == null) {
            this.controlComp = new BufferControlPanel();
        }
        return this.controlComp;
    }

    public boolean getEnabledThreshold() {
        return this.threshold_enabled;
    }

    public long getMinimumThreshold() {
        return this.currThreshold;
    }

    protected void initBufferControl(Format f) {
        if (f instanceof AudioFormat) {
            this.defBuffer = this.defBuffer != Integer.MAX_VALUE ? this.currBuffer : 250L;
            this.defThreshold = this.defThreshold != Integer.MAX_VALUE ? this.currThreshold : 125L;
            this.maxBuffer = this.maxBuffer != Integer.MAX_VALUE ? this.maxBuffer : 4000L;
            this.maxThreshold = this.maxThreshold != Integer.MAX_VALUE ? this.maxThreshold : 2000L;
            this.currBuffer = this.currBuffer != Integer.MAX_VALUE ? this.currBuffer : this.defBuffer;
            this.currThreshold = this.currThreshold != Integer.MAX_VALUE ? this.currThreshold : this.defThreshold;
        } else if (f instanceof VideoFormat) {
            this.defBuffer = this.defBuffer != Integer.MAX_VALUE ? this.currBuffer : 135L;
            this.defThreshold = this.defThreshold != Integer.MAX_VALUE ? this.currThreshold : 0L;
            this.maxBuffer = this.maxBuffer != Integer.MAX_VALUE ? this.maxBuffer : 4000L;
            this.maxThreshold = this.maxThreshold != Integer.MAX_VALUE ? this.maxThreshold : 0L;
            this.currBuffer = this.currBuffer != Integer.MAX_VALUE ? this.currBuffer : this.defBuffer;
            long l = this.currThreshold = this.currThreshold != Integer.MAX_VALUE ? this.currThreshold : this.defThreshold;
        }
        if (this.currBuffer == -2L) {
            this.currBuffer = this.maxBuffer;
        }
        if (this.currBuffer == -1L) {
            this.currBuffer = this.defBuffer;
        }
        if (this.currThreshold == -2L) {
            this.currThreshold = this.maxThreshold;
        }
        if (this.currThreshold == -1L) {
            this.currThreshold = this.defThreshold;
        }
        if (this.controlComp != null) {
            this.controlComp.updateBuffer(this.currBuffer);
            this.controlComp.updateThreshold(this.currThreshold);
        }
        this.inited = true;
    }

    protected void removeSourceStream(RTPSourceStream s) {
        this.sourcestreamlist.removeElement(s);
    }

    public long setBufferLength(long time) {
        if (!this.inited) {
            this.currBuffer = time;
            return time;
        }
        if (time == -1L) {
            time = this.defBuffer;
        }
        if (time == -2L) {
            time = this.maxBuffer;
        }
        if (time < this.currThreshold) {
            return this.currBuffer;
        }
        this.currBuffer = time >= this.maxBuffer ? this.maxBuffer : (time <= 0L || time == this.defBuffer ? this.defBuffer : time);
        for (int i = 0; i < this.sourcestreamlist.size(); ++i) {
            this.sourcestreamlist.elementAt(i).updateBuffer(this.currBuffer);
        }
        if (this.controlComp != null) {
            this.controlComp.updateBuffer(this.currBuffer);
        }
        return this.currBuffer;
    }

    public void setEnabledThreshold(boolean b) {
        this.threshold_enabled = b;
    }

    public long setMinimumThreshold(long t) {
        if (!this.inited) {
            this.currThreshold = t;
            return t;
        }
        if (t == -1L) {
            t = this.defThreshold;
        }
        if (t == -2L) {
            t = this.maxThreshold;
        }
        if (t > this.currBuffer) {
            return this.currThreshold;
        }
        this.currThreshold = t >= this.maxThreshold ? this.maxThreshold : (t == this.defThreshold ? this.defThreshold : t);
        if (t < 0L) {
            this.currThreshold = 0L;
        }
        for (int i = 0; i < this.sourcestreamlist.size(); ++i) {
            this.sourcestreamlist.elementAt(i).updateThreshold(this.currThreshold);
        }
        if (this.controlComp != null) {
            this.controlComp.updateThreshold(this.currThreshold);
        }
        return this.currThreshold;
    }

    private class BufferControlPanel
    extends Panel {
        Button bb;
        Choice bchoice;
        TextField bsize;
        TextField btext;
        Panel buffersize;
        Button tb;
        Choice tchoice;
        Panel threshold;
        TextField tsize;
        TextField ttext;

        public BufferControlPanel() {
            super(new BorderLayout());
            this.buffersize = null;
            this.threshold = null;
            this.btext = null;
            this.bchoice = null;
            this.tchoice = null;
            this.ttext = null;
            this.tb = null;
            this.buffersize = new Panel(new FlowLayout());
            this.buffersize.add(new Label("BufferSize"));
            this.bsize = new TextField(15);
            this.updateBuffer(BufferControlImpl.this.getBufferLength());
            this.bsize.setEnabled(false);
            this.buffersize.add(this.bsize);
            this.buffersize.add(new Label("Update"));
            this.bchoice = new Choice();
            this.buffersize.add(this.bchoice);
            this.bchoice.add("DEFAULT");
            this.bchoice.add("MAX");
            this.bchoice.add("User Defined");
            this.bchoice.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getItem().equals("User Defined")) {
                        BufferControlPanel.this.btext.setEnabled(true);
                    } else {
                        BufferControlPanel.this.btext.setEnabled(false);
                    }
                }
            });
            this.buffersize.add(new Label("If User Defined, Enter here:"));
            this.btext = new TextField(10);
            this.buffersize.add(this.btext);
            this.btext.setEnabled(false);
            this.bb = new Button("Commit");
            this.buffersize.add(this.bb);
            this.bb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BufferControlPanel.this.buffersizeUpdate();
                }
            });
            this.threshold = new Panel(new FlowLayout());
            this.threshold.add(new Label("Threshold"));
            this.tsize = new TextField(15);
            this.updateThreshold(BufferControlImpl.this.getMinimumThreshold());
            this.tsize.setEnabled(false);
            this.threshold.add(this.tsize);
            this.threshold.add(new Label("Update"));
            this.tchoice = new Choice();
            this.threshold.add(this.tchoice);
            this.tchoice.add("DEFAULT");
            this.tchoice.add("MAX");
            this.tchoice.add("User Defined");
            this.tchoice.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getItem().equals("User Defined")) {
                        BufferControlPanel.this.ttext.setEnabled(true);
                    } else {
                        BufferControlPanel.this.ttext.setEnabled(false);
                    }
                }
            });
            this.threshold.add(new Label("If User Defined, Enter here:"));
            this.ttext = new TextField(10);
            this.threshold.add(this.ttext);
            this.ttext.setEnabled(false);
            this.tb = new Button("Commit");
            this.threshold.add(this.tb);
            this.tb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BufferControlPanel.this.thresholdUpdate();
                }
            });
            this.add((Component)this.buffersize, "North");
            this.add((Component)new Label("Actual buffer & threshold sizes (in millisec) not displayed until media type is determined"), "Center");
            this.add((Component)this.threshold, "South");
            this.setVisible(true);
        }

        private void buffersizeUpdate() {
            String s = this.bchoice.getSelectedItem();
            long b = -1L;
            if (s.equals("MAX")) {
                b = -2L;
            } else if (s.equals("DEFAULT")) {
                b = -1L;
            } else {
                s = this.btext.getText();
                b = Long.parseLong(s);
            }
            b = BufferControlImpl.this.setBufferLength(b);
            this.updateBuffer(b);
        }

        private void thresholdUpdate() {
            String s = this.tchoice.getSelectedItem();
            long t = -1L;
            if (s.equals("DEFAULT")) {
                t = -1L;
            } else if (s.equals("MAX")) {
                t = -2L;
            } else {
                s = this.ttext.getText();
                t = Long.parseLong(s);
            }
            t = BufferControlImpl.this.setMinimumThreshold(t);
            this.updateThreshold(t);
        }

        public void updateBuffer(long b) {
            if (b != Integer.MAX_VALUE && b != -2L && b != -1L) {
                this.bsize.setText(Long.toString(b));
            }
        }

        public void updateThreshold(long d) {
            if (d != Integer.MAX_VALUE && d != -2L && d != -1L) {
                this.tsize.setText(Long.toString(d));
            }
        }
    }
}

