/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.media;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.ClockStartedError;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataStarvedEvent;
import javax.media.DeallocateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.IncompatibleTimeBaseException;
import javax.media.MediaTimeSetEvent;
import javax.media.NotPrefetchedError;
import javax.media.NotRealizedError;
import javax.media.PrefetchCompleteEvent;
import javax.media.RateChangeEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.RestartingEvent;
import javax.media.StartEvent;
import javax.media.StopAtTimeEvent;
import javax.media.StopByRequestEvent;
import javax.media.StopEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.TransitionEvent;
import net.sf.fmj.ejmf.toolkit.controls.RateControl;
import net.sf.fmj.ejmf.toolkit.media.AbstractClock;
import net.sf.fmj.ejmf.toolkit.media.ControllerEventQueue;
import net.sf.fmj.ejmf.toolkit.media.StopTimeMonitor;
import net.sf.fmj.ejmf.toolkit.media.ThreadQueue;
import net.sf.fmj.utility.LoggerSingleton;

public abstract class AbstractController
extends AbstractClock
implements Controller {
    private static final Logger logger = LoggerSingleton.logger;
    private int previousState;
    private int currentState = 100;
    private int targetState;
    private StopTimeMonitor stopTimeMonitor;
    private ControllerEventQueue eventqueue;
    private ThreadQueue threadqueue;
    private Object threadqueueMutex = new Object();
    private Vector controls = new Vector();
    private Vector listeners = new Vector();

    public AbstractController() {
        this.eventqueue = new ControllerEventQueue(this.listeners, "ControllerEventQueue for " + this);
        this.stopTimeMonitor = new StopTimeMonitor(this, "StopTimeMonitor for " + this);
        this.eventqueue.start();
        this.stopTimeMonitor.start();
        this.addControl(new RateControl(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addControl(Control newControl) {
        Vector vector = this.controls;
        synchronized (vector) {
            if (!this.controls.contains(newControl)) {
                this.controls.addElement(newControl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addControllerListener(ControllerListener listener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(listener)) {
                this.listeners.addElement(listener);
            }
        }
    }

    public void blockUntilStart(Time t) {
        long now;
        Time latencyTime = this.getStartLatency();
        long latency = latencyTime == LATENCY_UNKNOWN ? 0L : latencyTime.getNanoseconds();
        long start = t.getNanoseconds();
        long delay = (start - latency - (now = this.getTimeBase().getNanoseconds())) / 1000000L;
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public final synchronized void close() {
        this.stop();
        this.doClose();
        this.controls = null;
        this.postControllerClosedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void deallocate() {
        if (this.currentState == 600) {
            throw new ClockStartedError("deallocate() cannot be called on a started Controller");
        }
        Object object = this.threadqueueMutex;
        synchronized (object) {
            if (this.threadqueue != null) {
                this.threadqueue.stopThreads();
            }
        }
        if (this.doDeallocate()) {
            int state = this.currentState == 100 || this.currentState == 200 ? 100 : 300;
            this.setState(state);
            this.setTargetState(state);
            this.postDeallocateEvent();
        }
        object = this.threadqueueMutex;
        synchronized (object) {
            if (null != this.threadqueue) {
                this.threadqueue.close();
            }
            this.threadqueue = null;
        }
        if (null != this.stopTimeMonitor) {
            this.stopTimeMonitor.close();
        }
        this.stopTimeMonitor = null;
        if (null != this.eventqueue) {
            this.eventqueue.close();
        }
    }

    public abstract void doClose();

    public abstract boolean doDeallocate();

    public abstract boolean doPrefetch();

    public abstract boolean doRealize();

    public abstract void doSetMediaTime(Time var1);

    public abstract float doSetRate(float var1);

    public abstract boolean doStop();

    public abstract boolean doSyncStart(Time var1);

    protected synchronized void endOfMedia() throws ClockStoppedException {
        if (this.currentState != 600) {
            throw new ClockStoppedException();
        }
        super.stop();
        this.setState(500);
        this.setTargetState(500);
        this.postEndOfMediaEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Control getControl(String forName) {
        Class<?> c;
        try {
            c = Class.forName(forName);
        }
        catch (Exception e) {
            return null;
        }
        Vector vector = this.controls;
        synchronized (vector) {
            int n = this.controls.size();
            for (int i = 0; i < n; ++i) {
                Control control = (Control)this.controls.elementAt(i);
                if (!c.isInstance(control)) continue;
                return control;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Control[] getControls() {
        Object[] array;
        Vector vector = this.controls;
        synchronized (vector) {
            array = new Control[this.controls.size()];
            this.controls.copyInto(array);
        }
        return array;
    }

    public Time getDuration() {
        return DURATION_UNKNOWN;
    }

    public synchronized Time getMediaTime() {
        Time mediaTime = super.getMediaTime();
        Time duration = this.getDuration();
        if (duration != DURATION_UNKNOWN && duration != DURATION_UNBOUNDED && mediaTime.getNanoseconds() > duration.getNanoseconds()) {
            return duration;
        }
        return mediaTime;
    }

    public int getPreviousState() {
        return this.previousState;
    }

    public Time getStartLatency() {
        if (this.currentState == 100 || this.currentState == 200) {
            throw new NotRealizedError("Cannot get start latency from an unrealized Controller.");
        }
        return LATENCY_UNKNOWN;
    }

    public int getState() {
        return this.currentState;
    }

    public int getTargetState() {
        return this.targetState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadQueue getThreadQueue() {
        Object object = this.threadqueueMutex;
        synchronized (object) {
            if (null == this.threadqueue) {
                this.threadqueue = new ThreadQueue("ThreadQueue for " + this);
                this.threadqueue.start();
            }
            return this.threadqueue;
        }
    }

    public synchronized TimeBase getTimeBase() {
        if (this.currentState == 100 || this.currentState == 200) {
            throw new NotRealizedError("Cannot get time base from an Unrealized Controller");
        }
        return super.getTimeBase();
    }

    protected void postControllerClosedEvent() {
        this.postEvent(new ControllerClosedEvent(this));
    }

    protected void postControllerErrorEvent(String msg) {
        this.postEvent(new ControllerErrorEvent(this, msg));
    }

    protected void postDataStarvedEvent() {
        this.postEvent(new DataStarvedEvent(this, this.previousState, this.currentState, this.targetState, this.getMediaTime()));
    }

    protected void postDeallocateEvent() {
        this.postEvent(new DeallocateEvent(this, this.previousState, this.currentState, this.targetState, this.getMediaTime()));
    }

    protected void postEndOfMediaEvent() {
        this.postEvent(new EndOfMediaEvent(this, this.previousState, this.currentState, this.targetState, this.getMediaTime()));
    }

    protected void postEvent(ControllerEvent event) {
        this.eventqueue.postEvent(event);
    }

    protected void postPrefetchCompleteEvent() {
        this.postEvent(new PrefetchCompleteEvent(this, this.previousState, this.currentState, this.targetState));
    }

    protected void postRealizeCompleteEvent() {
        this.postEvent(new RealizeCompleteEvent(this, this.previousState, this.currentState, this.targetState));
    }

    protected void postRestartingEvent() {
        this.postEvent(new RestartingEvent(this, this.previousState, this.currentState, this.targetState, this.getMediaTime()));
    }

    protected void postStartEvent() {
        this.postEvent(new StartEvent(this, this.previousState, this.currentState, this.targetState, this.getMediaStartTime(), this.getTimeBaseStartTime()));
    }

    protected void postStopAtTimeEvent() {
        this.postEvent(new StopAtTimeEvent(this, this.previousState, this.currentState, this.targetState, this.getMediaTime()));
    }

    protected void postStopByRequestEvent() {
        this.postEvent(new StopByRequestEvent(this, this.previousState, this.currentState, this.targetState, this.getMediaTime()));
    }

    protected void postStopEvent() {
        this.postEvent(new StopEvent(this, this.previousState, this.currentState, this.targetState, this.getMediaTime()));
    }

    protected void postTransitionEvent() {
        this.postEvent(new TransitionEvent(this, this.previousState, this.currentState, this.targetState));
    }

    public final synchronized void prefetch() {
        if (this.currentState >= 500) {
            this.postPrefetchCompleteEvent();
            return;
        }
        if (this.targetState < 500) {
            this.setTargetState(500);
        }
        Thread thread = new Thread("Controller Prefetch Thread"){

            public void run() {
                if (AbstractController.this.getState() < 500) {
                    AbstractController.this.synchronousPrefetch();
                }
            }
        };
        this.getThreadQueue().addThread(thread);
    }

    public final synchronized void realize() {
        if (this.currentState >= 300) {
            this.postRealizeCompleteEvent();
            return;
        }
        if (this.targetState < 300) {
            this.setTargetState(300);
        }
        Thread thread = new Thread("Controller Realize Thread"){

            public void run() {
                if (AbstractController.this.getState() < 300) {
                    AbstractController.this.synchronousRealize();
                }
            }
        };
        this.getThreadQueue().addThread(thread);
    }

    public void removeControl(Control oldControl) {
        this.controls.removeElement(oldControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeControllerListener(ControllerListener listener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(listener);
        }
    }

    public synchronized void setMediaTime(Time t) {
        long limit;
        if (this.currentState == 100 || this.currentState == 200) {
            throw new NotRealizedError("Cannot set media time on an Unrealized Controller");
        }
        long nano = t.getNanoseconds();
        Time duration = this.getDuration();
        if (duration != DURATION_UNKNOWN && duration != DURATION_UNBOUNDED && nano > (limit = duration.getNanoseconds())) {
            t = new Time(limit);
        }
        super.setMediaTime(t);
        this.doSetMediaTime(t);
        this.postEvent(new MediaTimeSetEvent(this, t));
    }

    public synchronized float setRate(float rate) {
        if (this.currentState == 100 || this.currentState == 200) {
            throw new NotRealizedError("Cannot set rate on an Unrealized Controller.");
        }
        float oldRate = this.getRate();
        float superRate = super.setRate(rate);
        float subRate = this.doSetRate(superRate);
        if (rate != 1.0f && superRate != subRate && (superRate = super.setRate(subRate)) != subRate) {
            return this.setRate(1.0f);
        }
        if (superRate != oldRate) {
            this.postEvent(new RateChangeEvent(this, superRate));
        }
        return superRate;
    }

    protected synchronized void setState(int state) {
        if (state == this.currentState) {
            return;
        }
        this.previousState = this.currentState;
        this.currentState = state;
    }

    public synchronized void setStopTime(Time mediaStopTime) {
        if (this.currentState == 100 || this.currentState == 200) {
            throw new NotRealizedError("Cannot set stop time on an unrealized Controller");
        }
        Time oldStopTime = this.getStopTime();
        if (mediaStopTime.getNanoseconds() != oldStopTime.getNanoseconds()) {
            super.setStopTime(mediaStopTime);
            this.postEvent(new StopTimeChangeEvent(this, mediaStopTime));
        }
    }

    protected void setTargetState(int state) {
        this.targetState = state;
    }

    public synchronized void setTimeBase(TimeBase timebase) throws IncompatibleTimeBaseException {
        if (this.currentState == 100 || this.currentState == 200) {
            throw new NotRealizedError("Cannot set TimeBase on an Unrealized Controller.");
        }
        super.setTimeBase(timebase);
    }

    public final void stop() {
        if (this.stopController()) {
            this.postStopByRequestEvent();
        }
    }

    protected void stopAtTime() {
        if (this.stopController()) {
            this.postStopAtTimeEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean stopController() {
        Object object = this.threadqueueMutex;
        synchronized (object) {
            if (this.threadqueue != null) {
                this.threadqueue.stopThreads();
            }
        }
        switch (this.currentState) {
            case 100: 
            case 300: 
            case 500: {
                this.setTargetState(this.currentState);
                return true;
            }
            case 200: {
                this.setState(100);
                this.setTargetState(100);
                return true;
            }
            case 400: {
                this.setState(300);
                this.setTargetState(300);
                return true;
            }
        }
        if (!this.doStop()) {
            return false;
        }
        super.stop();
        this.setState(500);
        this.setTargetState(500);
        return true;
    }

    protected void stopInRestart() {
        if (this.stopController()) {
            this.postRestartingEvent();
        }
    }

    protected void synchronousPrefetch() {
        boolean result;
        if (this.currentState < 300) {
            this.synchronousRealize();
            if (this.currentState < 300) {
                return;
            }
        }
        this.setState(400);
        this.postTransitionEvent();
        try {
            result = this.doPrefetch();
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "" + e, e);
            this.postControllerErrorEvent("" + e);
            result = false;
        }
        if (result) {
            this.setState(500);
            this.postPrefetchCompleteEvent();
        } else {
            this.setState(300);
            this.setTargetState(300);
        }
    }

    protected void synchronousRealize() {
        boolean result;
        this.setState(200);
        this.postTransitionEvent();
        try {
            result = this.doRealize();
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "" + e, e);
            this.postControllerErrorEvent("" + e);
            result = false;
        }
        if (result) {
            this.setState(300);
            this.postRealizeCompleteEvent();
            this.setRate(1.0f);
        } else {
            this.setState(100);
            this.setTargetState(100);
        }
    }

    protected void synchronousSyncStart(Time t) {
        boolean result;
        this.setState(600);
        this.postStartEvent();
        Time latencyTime = this.getStartLatency();
        long latency = latencyTime == LATENCY_UNKNOWN ? 0L : latencyTime.getNanoseconds();
        long start = t.getNanoseconds();
        long now = this.getTimeBase().getNanoseconds();
        if (now + latency > start) {
            t = new Time(now + latency);
        }
        super.syncStart(t);
        try {
            result = this.doSyncStart(t);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "" + e, e);
            this.postControllerErrorEvent("" + e);
            result = false;
        }
        if (!result) {
            this.setState(500);
            this.setTargetState(500);
        }
    }

    public final synchronized void syncStart(final Time t) {
        if (this.currentState == 600) {
            throw new ClockStartedError("syncStart() cannot be called on a started Clock");
        }
        if (this.currentState != 500) {
            throw new NotPrefetchedError("Cannot start the Controller before it has been prefetched");
        }
        this.setTargetState(600);
        Thread thread = new Thread("Controller Start Thread"){

            public void run() {
                if (AbstractController.this.getState() < 600) {
                    AbstractController.this.synchronousSyncStart(t);
                }
            }
        };
        this.getThreadQueue().addThread(thread);
    }
}

