/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.net.InetAddress;
import java.util.Enumeration;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.event.LocalCollisionEvent;
import javax.media.rtp.event.RTPEvent;
import javax.media.rtp.event.RemoteCollisionEvent;
import net.sf.fmj.media.rtp.GenerateSSRCCause;
import net.sf.fmj.media.rtp.OverallStats;
import net.sf.fmj.media.rtp.OverallTransStats;
import net.sf.fmj.media.rtp.PassiveSSRCInfo;
import net.sf.fmj.media.rtp.RTPEventHandler;
import net.sf.fmj.media.rtp.RTPSessionMgr;
import net.sf.fmj.media.rtp.RTPSourceInfoCache;
import net.sf.fmj.media.rtp.RecvSSRCInfo;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.SendSSRCInfo;
import net.sf.fmj.media.rtp.TrueRandom;
import net.sf.fmj.media.rtp.util.SSRCTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSRCCache {
    public final SSRCTable<SSRCInfo> cache = new SSRCTable();
    RTPSourceInfoCache sourceInfoCache;
    private OverallStats stats;
    private OverallTransStats transstats;
    RTPEventHandler eventhandler;
    int[] clockrate = new int[128];
    static final int DATA = 1;
    static final int CONTROL = 2;
    static final int SRCDATA = 3;
    static final int RTCP_MIN_TIME = 5000;
    static final int BYE_THRESHOLD = 50;
    int sendercount;
    double rtcp_bw_fraction = 0.0;
    double rtcp_sender_bw_fraction = 0.0;
    private int rtcp_min_time = 5000;
    private static final int NOTIFYPERIOD = 500;
    int sessionbandwidth = 0;
    boolean initial = true;
    boolean byestate = false;
    boolean rtcpsent = false;
    private int avgrtcpsize = 128;
    SSRCInfo ourssrc;
    public final RTPSessionMgr sm;
    public boolean audio = true;

    SSRCCache(RTPSessionMgr rTPSessionMgr) {
        this.stats = rTPSessionMgr.defaultstats;
        this.transstats = rTPSessionMgr.transstats;
        this.sourceInfoCache = new RTPSourceInfoCache();
        this.sourceInfoCache.setMainCache(this.sourceInfoCache);
        this.sourceInfoCache.setSSRCCache(this);
        this.sm = rTPSessionMgr;
        this.eventhandler = new RTPEventHandler(rTPSessionMgr);
        this.setclockrates();
    }

    SSRCCache(RTPSessionMgr rTPSessionMgr, RTPSourceInfoCache rTPSourceInfoCache) {
        this.stats = rTPSessionMgr.defaultstats;
        this.transstats = rTPSessionMgr.transstats;
        this.sourceInfoCache = rTPSourceInfoCache;
        rTPSourceInfoCache.setSSRCCache(this);
        this.sm = rTPSessionMgr;
        this.eventhandler = new RTPEventHandler(rTPSessionMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int aliveCount() {
        int n = 0;
        SSRCTable<SSRCInfo> sSRCTable = this.cache;
        synchronized (sSRCTable) {
            Enumeration<SSRCInfo> enumeration = this.cache.elements();
            while (enumeration.hasMoreElements()) {
                SSRCInfo sSRCInfo = enumeration.nextElement();
                if (!sSRCInfo.alive) continue;
                ++n;
            }
        }
        return n;
    }

    double calcReportInterval(boolean bl, boolean bl2) {
        if (this.audio) {
            this.rtcp_min_time = 5000;
            double d = this.rtcp_bw_fraction;
            if (this.initial) {
                this.rtcp_min_time /= 2;
            }
            int n = this.aliveCount();
            if (this.sendercount > 0 && (double)this.sendercount < (double)n * this.rtcp_sender_bw_fraction) {
                if (bl) {
                    d *= this.rtcp_sender_bw_fraction;
                    n = this.sendercount;
                } else {
                    d *= 1.0 - this.rtcp_sender_bw_fraction;
                    n -= this.sendercount;
                }
            }
            if (bl2 && d == 0.0) {
                d = 0.05;
                if (this.sendercount > 0 && (double)this.sendercount < (double)n * 0.25) {
                    if (bl) {
                        d *= 0.25;
                        n = this.sendercount;
                    } else {
                        d *= 0.75;
                        n -= this.sendercount;
                    }
                }
            }
            double d2 = 0.0;
            if (d != 0.0 && (d2 = (double)(this.avgrtcpsize * n) / d) < (double)this.rtcp_min_time) {
                d2 = this.rtcp_min_time;
            }
            if (bl2) {
                return d2;
            }
            return d2 * (Math.random() + 0.5);
        }
        return 1000.0;
    }

    private void changessrc(SSRCInfo sSRCInfo) {
        sSRCInfo.setOurs(true);
        if (this.ourssrc != null) {
            sSRCInfo.sourceInfo = this.sourceInfoCache.get(this.ourssrc.sourceInfo.getCNAME(), sSRCInfo.ours);
            sSRCInfo.sourceInfo.addSSRC(sSRCInfo);
        }
        sSRCInfo.reporter.releasessrc("Local Collision Detected");
        this.ourssrc = sSRCInfo;
        sSRCInfo.reporter.restart = true;
    }

    synchronized void destroy() {
        this.cache.removeAll();
        if (this.eventhandler != null) {
            this.eventhandler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSRCInfo get(int n, InetAddress inetAddress, int n2) {
        SSRCCache sSRCCache = this;
        synchronized (sSRCCache) {
            return this.lookup(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSRCInfo get(int n, InetAddress inetAddress, int n2, int n3) {
        SSRCInfo sSRCInfo;
        boolean bl = false;
        SSRCCache sSRCCache = this;
        synchronized (sSRCCache) {
            Object object;
            if (this.ourssrc != null && this.ourssrc.ssrc == n && this.ourssrc.address != null && !this.ourssrc.address.equals(inetAddress)) {
                bl = true;
                this.localCollision(n);
            }
            if ((sSRCInfo = this.lookup(n)) != null) {
                object = sSRCInfo;
                synchronized (object) {
                    if (sSRCInfo.address == null || !sSRCInfo.alive) {
                        sSRCInfo.address = inetAddress;
                        sSRCInfo.port = n2;
                    } else if (!sSRCInfo.address.equals(inetAddress)) {
                        if (sSRCInfo.probation > 0) {
                            sSRCInfo.probation = 2;
                            sSRCInfo.address = inetAddress;
                            sSRCInfo.port = n2;
                        } else {
                            this.stats.update(4, 1);
                            ++this.transstats.remote_coll;
                            RemoteCollisionEvent remoteCollisionEvent = new RemoteCollisionEvent(this.sm, sSRCInfo.ssrc);
                            this.eventhandler.postEvent(remoteCollisionEvent);
                            return null;
                        }
                    }
                }
                if (n3 == 1) {
                    if (sSRCInfo.ours) {
                        return null;
                    }
                    if (!(sSRCInfo instanceof RecvSSRCInfo)) {
                        sSRCInfo = new RecvSSRCInfo(sSRCInfo);
                        this.cache.put(n, sSRCInfo);
                    }
                } else if (n3 == 2 && sSRCInfo.ours) {
                    return null;
                }
            }
            if (sSRCInfo == null) {
                if (n3 == 3) {
                    if (this.ourssrc != null && this.ourssrc.ssrc == n) {
                        return this.ourssrc;
                    }
                    sSRCInfo = new SendSSRCInfo(this, n);
                    sSRCInfo.initsource(TrueRandom.nextInt());
                }
                if (n3 == 1) {
                    sSRCInfo = new RecvSSRCInfo(this, n);
                }
                if (n3 == 2) {
                    sSRCInfo = new PassiveSSRCInfo(this, n);
                }
                if (sSRCInfo == null) {
                    return null;
                }
                sSRCInfo.address = inetAddress;
                sSRCInfo.port = n2;
                this.cache.put(n, sSRCInfo);
            }
            if (sSRCInfo.address == null && sSRCInfo.port == 0) {
                sSRCInfo.address = inetAddress;
                sSRCInfo.port = n2;
            }
            if (bl) {
                object = null;
                object = sSRCInfo instanceof RecvSSRCInfo ? new LocalCollisionEvent(this.sm, (ReceiveStream)((Object)sSRCInfo), this.ourssrc.ssrc) : new LocalCollisionEvent(this.sm, null, this.ourssrc.ssrc);
                this.eventhandler.postEvent((RTPEvent)object);
            }
        }
        return sSRCInfo;
    }

    SSRCTable<SSRCInfo> getMainCache() {
        return this.cache;
    }

    RTPSourceInfoCache getRTPSICache() {
        return this.sourceInfoCache;
    }

    int getSessionBandwidth() {
        if (this.sessionbandwidth == 0) {
            throw new IllegalArgumentException("Session Bandwidth not set");
        }
        return this.sessionbandwidth;
    }

    private void localCollision(int n) {
        int n2 = 0;
        while (this.lookup(n2 = (int)this.sm.generateSSRC(GenerateSSRCCause.LOCAL_COLLISION)) != null) {
        }
        PassiveSSRCInfo passiveSSRCInfo = new PassiveSSRCInfo(this.ourssrc);
        passiveSSRCInfo.ssrc = n2;
        this.cache.put(n2, passiveSSRCInfo);
        this.changessrc(passiveSSRCInfo);
        this.ourssrc = passiveSSRCInfo;
        this.stats.update(3, 1);
        ++this.transstats.local_coll;
    }

    SSRCInfo lookup(int n) {
        return this.cache.get(n);
    }

    void remove(int n) {
        SSRCInfo sSRCInfo = this.cache.remove(n);
        if (sSRCInfo != null) {
            sSRCInfo.delete();
        }
    }

    public void reset(int n) {
        this.initial = true;
        this.sendercount = 0;
        this.avgrtcpsize = n;
    }

    void setclockrates() {
        int n;
        for (n = 0; n < 16; ++n) {
            this.clockrate[n] = 8000;
        }
        this.clockrate[6] = 16000;
        this.clockrate[10] = 44100;
        this.clockrate[11] = 44100;
        this.clockrate[14] = 90000;
        this.clockrate[16] = 11025;
        this.clockrate[17] = 22050;
        this.clockrate[18] = 44100;
        for (n = 24; n < 34; ++n) {
            this.clockrate[n] = 90000;
        }
        for (n = 96; n < 128; ++n) {
            Format format = this.sm.formatinfo.get(n);
            this.clockrate[n] = format != null && format instanceof AudioFormat ? (int)((AudioFormat)format).getSampleRate() : 90000;
        }
    }

    synchronized void updateavgrtcpsize(int n) {
        this.avgrtcpsize = (int)(0.0625 * (double)n + 0.9375 * (double)this.avgrtcpsize);
    }
}

