/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.util;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.Control;
import javax.media.Controller;
import javax.media.GainControl;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.Time;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class Utility {
    public static MediaLocator appArgToMediaLocator(String string) {
        Object var1_1 = null;
        try {
            return new MediaLocator(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new MediaLocator(Utility.fileToURL(string));
            }
            catch (MalformedURLException malformedURLException2) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new MediaLocator(string);
        }
    }

    public static MediaLocator appletArgToMediaLocator(Applet applet, String string) {
        Object var2_2 = null;
        try {
            return new MediaLocator(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new MediaLocator(new URL(applet.getDocumentBase(), string));
            }
            catch (MalformedURLException malformedURLException2) {
                return new MediaLocator(string);
            }
        }
    }

    public static Icon createDisabledIcon(ImageIcon imageIcon) {
        Image image = GrayFilter.createDisabledImage(imageIcon.getImage());
        return new ImageIcon(image);
    }

    public static URL fileToURL(String string) throws IOException, MalformedURLException {
        File file = new File(string);
        if (!file.exists()) {
            throw new IOException("File " + string + " does not exist.");
        }
        return new URL("file:///" + file.getCanonicalPath());
    }

    public static String getExtension(File file) {
        return Utility.getExtension(file.getName());
    }

    public static String getExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        return string2;
    }

    public static Time getMaximumLatency(Controller[] controllerArray) {
        Time time = new Time(0.0);
        double d = 0.0;
        for (int i = 0; i < controllerArray.length; ++i) {
            double d2;
            Time time2;
            if (controllerArray[i].getState() < 300 || (time2 = controllerArray[i].getStartLatency()) == Controller.LATENCY_UNKNOWN || !((d2 = time2.getSeconds()) > d)) continue;
            time = time2;
        }
        return time;
    }

    public static int pickAMaster(Player[] playerArray) {
        for (int i = 0; i < playerArray.length; ++i) {
            GainControl gainControl = playerArray[i].getGainControl();
            if (gainControl == null || gainControl.getControlComponent() == null) continue;
            return i;
        }
        return 0;
    }

    public static void showControls(Controller controller) {
        Control[] controlArray = controller.getControls();
        for (int i = 0; i < controlArray.length; ++i) {
            Component component = controlArray[i].getControlComponent();
            if (component == null || component.isShowing()) continue;
            JFrame jFrame = new JFrame(controlArray[i].getClass().getName());
            jFrame.getContentPane().add(component);
            jFrame.pack();
            jFrame.setVisible(true);
        }
    }

    public static String stateToString(int n) {
        switch (n) {
            case 100: {
                return "Unrealized";
            }
            case 200: {
                return "Realizing";
            }
            case 300: {
                return "Realized";
            }
            case 400: {
                return "Prefetching";
            }
            case 500: {
                return "Prefetched";
            }
            case 600: {
                return "Started";
            }
        }
        return null;
    }
}

