/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;

final class InitiationListener
implements PacketListener {
    private final Socks5BytestreamManager manager;
    private final PacketFilter initFilter = new AndFilter(new PacketTypeFilter(Bytestream.class), new IQTypeFilter(IQ.Type.SET));
    private final ExecutorService initiationListenerExecutor;

    protected InitiationListener(Socks5BytestreamManager manager) {
        this.manager = manager;
        this.initiationListenerExecutor = Executors.newCachedThreadPool();
    }

    @Override
    public void processPacket(final Packet packet) {
        this.initiationListenerExecutor.execute(new Runnable(){

            @Override
            public void run() {
                InitiationListener.this.processRequest(packet);
            }
        });
    }

    private void processRequest(Packet packet) {
        Bytestream byteStreamRequest = (Bytestream)packet;
        if (this.manager.getIgnoredBytestreamRequests().remove(byteStreamRequest.getSessionID())) {
            return;
        }
        Socks5BytestreamRequest request = new Socks5BytestreamRequest(this.manager, byteStreamRequest);
        BytestreamListener userListener = this.manager.getUserListener(byteStreamRequest.getFrom());
        if (userListener != null) {
            userListener.incomingBytestreamRequest(request);
        } else if (!this.manager.getAllRequestListeners().isEmpty()) {
            for (BytestreamListener listener : this.manager.getAllRequestListeners()) {
                listener.incomingBytestreamRequest(request);
            }
        } else {
            this.manager.replyRejectPacket(byteStreamRequest);
        }
    }

    protected PacketFilter getFilter() {
        return this.initFilter;
    }

    protected void shutdown() {
        this.initiationListenerExecutor.shutdownNow();
    }
}

