/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class LocalTopicStatsImpl
implements LocalTopicStats {
    private long creationTime;
    private AtomicLong totalPublishes = new AtomicLong(0L);
    private AtomicLong totalReceivedMessages = new AtomicLong(0L);

    public LocalTopicStatsImpl() {
        this.creationTime = Clock.currentTimeMillis();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.creationTime);
        out.writeLong(this.totalPublishes.get());
        out.writeLong(this.totalReceivedMessages.get());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.creationTime = in.readLong();
        this.totalPublishes.set(in.readLong());
        this.totalReceivedMessages.set(in.readLong());
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getPublishOperationCount() {
        return this.totalPublishes.get();
    }

    public void incrementPublishes() {
        this.totalPublishes.incrementAndGet();
    }

    @Override
    public long getReceiveOperationCount() {
        return this.totalReceivedMessages.get();
    }

    public void incrementReceives() {
        this.totalReceivedMessages.incrementAndGet();
    }
}

