/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import uk.ltd.getahead.dwr.util.Logger;

public class Messages {
    private static final Logger log = Logger.getLogger(Messages.class);
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("uk.ltd.getahead.dwr.messages");

    private Messages() {
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException ex) {
            log.error("Missing I18N string: " + key, ex);
            return '!' + key + '!';
        }
    }

    public static String getString(String key, Object param) {
        return Messages.getString(key, new Object[]{param});
    }

    public static String getString(String key, Object param1, Object param2) {
        return Messages.getString(key, new Object[]{param1, param2});
    }

    public static String getString(String key, Object param1, Object param2, Object param3) {
        return Messages.getString(key, new Object[]{param1, param2, param3});
    }

    public static String getString(String key, Object param1, Object param2, Object param3, Object param4) {
        return Messages.getString(key, new Object[]{param1, param2, param3, param4});
    }

    public static String getString(String key, Object[] params) {
        try {
            String format = RESOURCE_BUNDLE.getString(key);
            return MessageFormat.format(format, params);
        }
        catch (MissingResourceException ex) {
            StringBuffer buffer = new StringBuffer();
            buffer.append('[');
            for (int i = 0; i < params.length; ++i) {
                if (i != 0) {
                    buffer.append(',');
                }
                buffer.append(params[i].toString());
            }
            buffer.append(']');
            log.error("Missing I18N string: " + key + ". Params: " + buffer.toString());
            return '!' + key + '!' + buffer.toString() + '!';
        }
    }
}

