/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.trust;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;

public class DistinguishedName {
    private final String name;
    private final String email;
    private final String orgUnit;
    private final String organization;
    private final String city;
    private final String state;
    private final String country;

    public static DistinguishedName getIssuerInstance(X509Certificate cert) {
        return DistinguishedName.getInstance(cert.getIssuerDN());
    }

    public static DistinguishedName getSubjectInstance(X509Certificate cert) {
        return DistinguishedName.getInstance(cert.getSubjectDN());
    }

    public static DistinguishedName getInstance(Principal principal) {
        X509Name x509Name = (X509Name)principal;
        Vector oids = x509Name.getOIDs();
        Vector values = x509Name.getValues();
        String name = null;
        String email = null;
        String orgUnit = null;
        String organization = null;
        String city = null;
        String state = null;
        String country = null;
        int size = Math.min(oids.size(), values.size());
        for (int i = 0; i < size; ++i) {
            DERObjectIdentifier oid = (DERObjectIdentifier)oids.get(i);
            String value = (String)values.get(i);
            if (oid == null) continue;
            if (oid.equals((Object)X509Name.CN)) {
                name = value;
                continue;
            }
            if (oid.equals((Object)X509Name.E)) {
                email = value;
                continue;
            }
            if (oid.equals((Object)X509Name.OU)) {
                orgUnit = value;
                continue;
            }
            if (oid.equals((Object)X509Name.O)) {
                organization = value;
                continue;
            }
            if (oid.equals((Object)X509Name.L)) {
                city = value;
                continue;
            }
            if (oid.equals((Object)X509Name.ST)) {
                state = value;
                continue;
            }
            if (!oid.equals((Object)X509Name.C)) continue;
            country = value;
        }
        return new DistinguishedName(name, email, orgUnit, organization, city, state, country);
    }

    private DistinguishedName(String name, String email, String orgUnit, String organization, String city, String state, String country) {
        this.name = name;
        this.email = email;
        this.orgUnit = orgUnit;
        this.organization = organization;
        this.city = city;
        this.state = state;
        this.country = country;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getOrgUnit() {
        return this.orgUnit;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getCountry() {
        return this.country;
    }
}

