/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.chatrooms;

import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import net.kano.joscar.OscarTools;
import net.kano.joscar.rv.RvSession;
import net.kano.joscar.snaccmd.FullRoomInfo;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatInvitation;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomManager;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomSession;
import net.kano.joustsim.oscar.oscar.service.chatrooms.InvalidInvitationReason;

class ChatInvitationImpl
implements ChatInvitation {
    private final ChatRoomManager chatRoomManager;
    private final RvSession session;
    private final Screenname screenname;
    private final FullRoomInfo roomInfo;
    private final String message;
    private final boolean secure;
    private SecretKey roomKey = null;
    private X509Certificate buddySignature = null;
    private InvalidInvitationReason invalidReason = null;
    private boolean rejected = false;

    public ChatInvitationImpl(ChatRoomManager chatRoomManager, RvSession session, Screenname screenname, FullRoomInfo roomInfo, String message) {
        this(chatRoomManager, session, screenname, roomInfo, message, false);
    }

    private ChatInvitationImpl(ChatRoomManager chatRoomManager, RvSession session, Screenname screenname, FullRoomInfo roomInfo, String message, boolean secure) {
        this.chatRoomManager = chatRoomManager;
        this.screenname = screenname;
        this.roomInfo = roomInfo;
        this.message = message;
        this.secure = secure;
        this.session = session;
    }

    public ChatInvitationImpl(ChatRoomManager chatRoomManager, RvSession session, Screenname screenname, FullRoomInfo roomInfo, X509Certificate buddySignature, SecretKey roomKey, String message) {
        this(chatRoomManager, session, screenname, roomInfo, message, true);
        this.roomKey = roomKey;
        this.buddySignature = buddySignature;
    }

    public ChatInvitationImpl(ChatRoomManager chatRoomManager, RvSession session, Screenname screenname, FullRoomInfo roomInfo, InvalidInvitationReason reason, String message) {
        this(chatRoomManager, session, screenname, roomInfo, message, true);
        this.invalidReason = reason;
    }

    public RvSession getSession() {
        return this.session;
    }

    public Screenname getScreenname() {
        return this.screenname;
    }

    public FullRoomInfo getRoomInfo() {
        return this.roomInfo;
    }

    public int getRoomExchange() {
        return this.getRoomInfo().getExchange();
    }

    public String getRoomName() {
        return OscarTools.getRoomNameFromCookie((String)this.getRoomInfo().getCookie());
    }

    public X509Certificate getBuddySignature() {
        return this.buddySignature;
    }

    public SecretKey getRoomKey() {
        return this.roomKey;
    }

    public String getMessage() {
        return this.message;
    }

    public InvalidInvitationReason getInvalidReason() {
        return this.invalidReason;
    }

    public ChatRoomManager getChatRoomManager() {
        return this.chatRoomManager;
    }

    public boolean isValid() {
        return !this.isForSecureChatRoom() || this.roomKey != null;
    }

    public boolean isForSecureChatRoom() {
        return this.secure;
    }

    public ChatRoomSession accept() {
        return this.chatRoomManager.acceptInvitation(this);
    }

    public void reject() {
        this.chatRoomManager.rejectInvitation(this);
    }

    public String toString() {
        return "ChatInvitationImpl{screenname=" + this.screenname + ", roomInfo=" + this.roomInfo + ", message='" + this.message + "'" + ", secure=" + this.secure + ", invalidReason=" + (Object)((Object)this.invalidReason) + "}";
    }

    public synchronized boolean setRejected() {
        if (this.rejected) {
            return false;
        }
        this.rejected = true;
        return true;
    }

    public synchronized boolean isRejected() {
        return this.rejected;
    }

    public boolean isAcceptable() {
        return this.isValid() && !this.isRejected();
    }
}

