/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.CapabilityHandler;
import net.kano.joustsim.oscar.CapabilityManagerListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapabilityManager {
    private final AimConnection conn;
    private Map<CapabilityBlock, CapabilityHandler> handlers = new HashMap<CapabilityBlock, CapabilityHandler>();
    private CopyOnWriteArrayList<CapabilityManagerListener> listeners = new CopyOnWriteArrayList();

    public CapabilityManager(AimConnection conn) {
        DefensiveTools.checkNull((Object)conn, (String)"conn");
        this.conn = conn;
    }

    public AimConnection getAimConnection() {
        return this.conn;
    }

    public void addCapabilityListener(CapabilityManagerListener l) {
        this.listeners.addIfAbsent((Object)l);
    }

    public void removeCapabilityListener(CapabilityManagerListener l) {
        this.listeners.remove((Object)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCapabilityHandler(CapabilityBlock block, CapabilityHandler handler) {
        boolean isnew;
        CapabilityHandler old;
        DefensiveTools.checkNull((Object)block, (String)"block");
        DefensiveTools.checkNull((Object)handler, (String)"handler");
        CapabilityManager capabilityManager = this;
        synchronized (capabilityManager) {
            old = this.handlers.put(block, handler);
            if (old == handler) {
                return false;
            }
            isnew = old == null;
        }
        if (isnew) {
            this.fireCapabilityHandlerAdded(block, handler);
        } else {
            this.fireCapabilityHandlerChanged(block, old, handler);
        }
        return true;
    }

    public synchronized CapabilityHandler getCapabilityHandler(CapabilityBlock block) {
        return this.handlers.get(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCapabilityHandler(CapabilityBlock block, CapabilityHandler handler) {
        DefensiveTools.checkNull((Object)block, (String)"block");
        DefensiveTools.checkNull((Object)handler, (String)"handler");
        CapabilityManager capabilityManager = this;
        synchronized (capabilityManager) {
            if (handler != this.handlers.get(block)) {
                return false;
            }
            this.handlers.remove(block);
        }
        this.fireCapabilityHandlerRemoved(block, handler);
        return true;
    }

    public synchronized List<CapabilityBlock> getEnabledCapabilities() {
        ArrayList<CapabilityBlock> actual = new ArrayList<CapabilityBlock>(this.handlers.size());
        for (Map.Entry<CapabilityBlock, CapabilityHandler> pair : this.handlers.entrySet()) {
            CapabilityHandler handler = pair.getValue();
            if (!handler.isEnabled()) continue;
            CapabilityBlock block = pair.getKey();
            actual.add(block);
        }
        return DefensiveTools.getUnmodifiable(actual);
    }

    private void fireCapabilityHandlerAdded(CapabilityBlock block, CapabilityHandler handler) {
        assert (!Thread.holdsLock(this));
        DefensiveTools.checkNull((Object)block, (String)"block");
        DefensiveTools.checkNull((Object)handler, (String)"handler");
        handler.handleAdded(this);
        for (CapabilityManagerListener listener : this.listeners) {
            listener.capabilityHandlerAdded(this, block, handler);
        }
    }

    private void fireCapabilityHandlerChanged(CapabilityBlock block, CapabilityHandler old, CapabilityHandler handler) {
        assert (!Thread.holdsLock(this));
        DefensiveTools.checkNull((Object)block, (String)"block");
        DefensiveTools.checkNull((Object)handler, (String)"handler");
        if (old != null) {
            this.fireCapabilityHandlerRemoved(block, old);
        }
        this.fireCapabilityHandlerAdded(block, handler);
    }

    private void fireCapabilityHandlerRemoved(CapabilityBlock block, CapabilityHandler handler) {
        assert (!Thread.holdsLock(this));
        DefensiveTools.checkNull((Object)block, (String)"block");
        DefensiveTools.checkNull((Object)handler, (String)"handler");
        handler.handleRemoved(this);
        for (CapabilityManagerListener listener : this.listeners) {
            listener.capabilityHandlerRemoved(this, block, handler);
        }
    }
}

