/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;

public class RateAck
extends ConnCommand {
    private final int[] classes;

    protected RateAck(SnacPacket packet) {
        super(8);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        this.classes = new int[snacData.getLength() / 2];
        for (int i = 0; i < this.classes.length; ++i) {
            this.classes[i] = BinaryTools.getUShort((ByteBlock)snacData, (int)(i * 2));
        }
    }

    public RateAck(int[] classes) {
        super(8);
        this.classes = classes == null ? null : (int[])classes.clone();
    }

    public final int[] getClasses() {
        return this.classes == null ? null : (int[])this.classes.clone();
    }

    public void writeData(OutputStream out) throws IOException {
        if (this.classes != null) {
            for (int aClass : this.classes) {
                BinaryTools.writeUShort((OutputStream)out, (int)aClass);
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("RateAck for classes: ");
        if (this.classes != null) {
            for (int aClass : this.classes) {
                buffer.append(aClass).append(", ");
            }
        }
        return buffer.toString();
    }
}

