/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.auth;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.auth.AuthRequest;
import net.kano.joscar.snaccmd.auth.KeyRequest;
import net.kano.joscar.snaccmd.auth.SecuridResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerAuthCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList((Object[])new CmdType[]{new CmdType(23, 6), new CmdType(23, 2), new CmdType(23, 11)});

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket packet) {
        if (packet.getFamily() != 23) {
            return null;
        }
        int command = packet.getCommand();
        if (command == 6) {
            return new KeyRequest(packet);
        }
        if (command == 2) {
            return new AuthRequest(packet);
        }
        if (command == 11) {
            return new SecuridResponse(packet);
        }
        return null;
    }
}

