/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.Writable;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class RvConnectionInfo
implements LiveWritable {
    private static final int TYPE_PROXYIP = 2;
    private static final int TYPE_INTERNALIP = 3;
    private static final int TYPE_EXTERNALIP = 4;
    private static final int TYPE_PORT = 5;
    private static final int TYPE_PROXIED = 16;
    private static final int TYPE_ENCRYPTED = 17;
    private final boolean encrypted;
    private final boolean proxied;
    private final InetAddress proxyIP;
    private final InetAddress internalIP;
    private final InetAddress externalIP;
    private final int port;

    public static RvConnectionInfo readConnectionInfo(TlvChain chain) {
        DefensiveTools.checkNull((Object)chain, (String)"chain");
        Tlv internalIpTlv = chain.getLastTlv(3);
        Inet4Address internalIP = null;
        if (internalIpTlv != null) {
            internalIP = BinaryTools.getIPFromBytes((ByteBlock)internalIpTlv.getData(), (int)0);
        }
        Tlv externalIpTlv = chain.getLastTlv(4);
        Inet4Address externalIP = null;
        if (externalIpTlv != null) {
            externalIP = BinaryTools.getIPFromBytes((ByteBlock)externalIpTlv.getData(), (int)0);
        }
        Tlv proxyIpTlv = chain.getLastTlv(2);
        Inet4Address proxyIP = null;
        if (proxyIpTlv != null) {
            proxyIP = BinaryTools.getIPFromBytes((ByteBlock)proxyIpTlv.getData(), (int)0);
        }
        int port = chain.getUShort(5);
        boolean proxied = chain.hasTlv(16);
        boolean encrypted = chain.hasTlv(17);
        return new RvConnectionInfo(internalIP, externalIP, proxyIP, port, proxied, encrypted);
    }

    public static RvConnectionInfo createForOutgoingRequest(InetAddress internalIP, int port) {
        DefensiveTools.checkNull((Object)internalIP, (String)"internalIP");
        return new RvConnectionInfo(internalIP, null, null, port, false, false);
    }

    public static RvConnectionInfo createForOutgoingSecureRequest(InetAddress internalIP, int port) {
        DefensiveTools.checkNull((Object)internalIP, (String)"internalIP");
        return new RvConnectionInfo(internalIP, null, null, port, false, true);
    }

    public static RvConnectionInfo createForOutgoingProxiedRequest(InetAddress proxyIP, int port) {
        DefensiveTools.checkNull((Object)proxyIP, (String)"proxyIP");
        return new RvConnectionInfo(null, null, proxyIP, port, true, false);
    }

    public RvConnectionInfo(InetAddress internalIP, InetAddress externalIP, InetAddress proxyIP, int port, boolean proxied, boolean encrypted) {
        DefensiveTools.checkRange((int)port, (String)"port", (int)-1);
        this.internalIP = internalIP;
        this.externalIP = externalIP;
        this.proxyIP = proxyIP;
        this.port = port;
        this.proxied = proxied;
        this.encrypted = encrypted;
    }

    public final InetAddress getInternalIP() {
        return this.internalIP;
    }

    public final InetAddress getExternalIP() {
        return this.externalIP;
    }

    public final boolean isProxied() {
        return this.proxied;
    }

    public final InetAddress getProxyIP() {
        return this.proxyIP;
    }

    public final int getPort() {
        return this.port;
    }

    public final boolean isEncrypted() {
        return this.encrypted;
    }

    private static void writeIP(OutputStream out, int type, InetAddress addr) throws IOException {
        ByteBlock addrBlock = ByteBlock.wrap((byte[])addr.getAddress());
        new Tlv(type, (Writable)addrBlock).write(out);
    }

    public void write(OutputStream out) throws IOException {
        if (this.internalIP != null) {
            RvConnectionInfo.writeIP(out, 3, this.internalIP);
        }
        if (this.externalIP != null) {
            RvConnectionInfo.writeIP(out, 4, this.externalIP);
        }
        if (this.proxyIP != null) {
            RvConnectionInfo.writeIP(out, 2, this.proxyIP);
        }
        if (this.port != -1) {
            Tlv.getUShortInstance(5, this.port).write(out);
        }
        if (this.proxied) {
            new Tlv(16).write(out);
        }
        if (this.encrypted) {
            new Tlv(17).write(out);
        }
    }

    public String toString() {
        return "ConnectionInfo: " + (this.proxied ? "(proxied) " : "") + (this.encrypted ? "(encrypted) " : "") + "internalIP=" + this.internalIP + ", externalIP=" + this.externalIP + ", proxyIP=" + this.proxyIP + ", port=" + this.port;
    }
}

