/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio.support;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionRecycler;
import org.apache.mina.common.support.AbstractIoFilterChain;
import org.apache.mina.common.support.BaseIoConnector;
import org.apache.mina.common.support.DefaultConnectFuture;
import org.apache.mina.transport.socket.nio.DatagramConnectorConfig;
import org.apache.mina.transport.socket.nio.DatagramServiceConfig;
import org.apache.mina.transport.socket.nio.DatagramSessionConfig;
import org.apache.mina.transport.socket.nio.support.DatagramService;
import org.apache.mina.transport.socket.nio.support.DatagramSessionImpl;
import org.apache.mina.util.NamePreservingRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatagramConnectorDelegate
extends BaseIoConnector
implements DatagramService {
    private static final AtomicInteger nextId = new AtomicInteger();
    private final Object lock = new Object();
    private final IoConnector wrapper;
    private final Executor executor;
    private final int id = nextId.getAndIncrement();
    private Selector selector;
    private DatagramConnectorConfig defaultConfig = new DatagramConnectorConfig();
    private final Queue<RegistrationRequest> registerQueue = new ConcurrentLinkedQueue<RegistrationRequest>();
    private final Queue<DatagramSessionImpl> cancelQueue = new ConcurrentLinkedQueue<DatagramSessionImpl>();
    private final Queue<DatagramSessionImpl> flushingSessions = new ConcurrentLinkedQueue<DatagramSessionImpl>();
    private final Queue<DatagramSessionImpl> trafficControllingSessions = new ConcurrentLinkedQueue<DatagramSessionImpl>();
    private Worker worker;

    public DatagramConnectorDelegate(IoConnector wrapper, Executor executor) {
        this.wrapper = wrapper;
        this.executor = executor;
    }

    @Override
    public ConnectFuture connect(SocketAddress address, IoHandler handler, IoServiceConfig config) {
        return this.connect(address, null, handler, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectFuture connect(SocketAddress address, SocketAddress localAddress, IoHandler handler, IoServiceConfig config) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        if (localAddress != null && !(localAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected local address type: " + localAddress.getClass());
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        DatagramChannel ch = null;
        boolean initialized = false;
        try {
            ch = DatagramChannel.open();
            DatagramSessionConfig cfg = config.getSessionConfig() instanceof DatagramSessionConfig ? (DatagramSessionConfig)config.getSessionConfig() : (DatagramSessionConfig)this.getDefaultConfig().getSessionConfig();
            ch.socket().setReuseAddress(cfg.isReuseAddress());
            ch.socket().setBroadcast(cfg.isBroadcast());
            ch.socket().setReceiveBufferSize(cfg.getReceiveBufferSize());
            ch.socket().setSendBufferSize(cfg.getSendBufferSize());
            if (ch.socket().getTrafficClass() != cfg.getTrafficClass()) {
                ch.socket().setTrafficClass(cfg.getTrafficClass());
            }
            if (localAddress != null) {
                ch.socket().bind(localAddress);
            }
            ch.connect(address);
            ch.configureBlocking(false);
            initialized = true;
        }
        catch (IOException e) {
            ConnectFuture connectFuture = DefaultConnectFuture.newFailedFuture(e);
            return connectFuture;
        }
        finally {
            if (!initialized && ch != null) {
                try {
                    ch.disconnect();
                    ch.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        RegistrationRequest request = new RegistrationRequest(ch, handler, config);
        try {
            this.startupWorker();
        }
        catch (IOException e) {
            try {
                ch.disconnect();
                ch.close();
            }
            catch (IOException e2) {
                ExceptionMonitor.getInstance().exceptionCaught(e2);
            }
            return DefaultConnectFuture.newFailedFuture(e);
        }
        this.registerQueue.add(request);
        this.selector.wakeup();
        return request;
    }

    @Override
    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(DatagramConnectorConfig defaultConfig) {
        if (defaultConfig == null) {
            throw new NullPointerException("defaultConfig");
        }
        this.defaultConfig = defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupWorker() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.worker == null) {
                this.selector = Selector.open();
                this.worker = new Worker();
                this.executor.execute(new NamePreservingRunnable(this.worker));
            }
        }
    }

    @Override
    public void closeSession(DatagramSessionImpl session) {
        try {
            this.startupWorker();
        }
        catch (IOException e) {
            return;
        }
        this.cancelQueue.add(session);
        this.selector.wakeup();
    }

    @Override
    public void flushSession(DatagramSessionImpl session) {
        this.scheduleFlush(session);
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
    }

    private void scheduleFlush(DatagramSessionImpl session) {
        this.flushingSessions.add(session);
    }

    @Override
    public void updateTrafficMask(DatagramSessionImpl session) {
        this.scheduleTrafficControl(session);
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
    }

    private void scheduleTrafficControl(DatagramSessionImpl session) {
        this.trafficControllingSessions.add(session);
    }

    private void doUpdateTrafficMask() {
        DatagramSessionImpl session;
        if (this.trafficControllingSessions.isEmpty()) {
            return;
        }
        while ((session = this.trafficControllingSessions.poll()) != null) {
            SelectionKey key = session.getSelectionKey();
            if (key == null) {
                this.scheduleTrafficControl(session);
                break;
            }
            if (!key.isValid()) continue;
            int ops = 1;
            if (!session.getWriteRequestQueue().isEmpty()) {
                ops |= 4;
            }
            int mask = session.getTrafficMask().getInterestOps();
            key.interestOps(ops & mask);
        }
    }

    private void processReadySessions(Set<SelectionKey> keys) {
        Iterator<SelectionKey> it = keys.iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            it.remove();
            DatagramSessionImpl session = (DatagramSessionImpl)key.attachment();
            this.getSessionRecycler(session).recycle(session.getLocalAddress(), session.getRemoteAddress());
            if (key.isReadable() && session.getTrafficMask().isReadable()) {
                this.readSession(session);
            }
            if (!key.isWritable() || !session.getTrafficMask().isWritable()) continue;
            this.scheduleFlush(session);
        }
    }

    private IoSessionRecycler getSessionRecycler(IoSession session) {
        IoServiceConfig config = session.getServiceConfig();
        IoSessionRecycler sessionRecycler = config instanceof DatagramServiceConfig ? ((DatagramServiceConfig)config).getSessionRecycler() : this.defaultConfig.getSessionRecycler();
        return sessionRecycler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSession(DatagramSessionImpl session) {
        ByteBuffer readBuf = ByteBuffer.allocate(session.getReadBufferSize());
        try {
            int readBytes = session.getChannel().read(readBuf.buf());
            if (readBytes > 0) {
                readBuf.flip();
                ByteBuffer newBuf = ByteBuffer.allocate(readBuf.limit());
                newBuf.put(readBuf);
                newBuf.flip();
                session.increaseReadBytes(readBytes);
                session.getFilterChain().fireMessageReceived(session, newBuf);
            }
        }
        catch (IOException e) {
            session.getFilterChain().fireExceptionCaught(session, e);
        }
        finally {
            readBuf.release();
        }
    }

    private void flushSessions() {
        DatagramSessionImpl session;
        if (this.flushingSessions.size() == 0) {
            return;
        }
        while ((session = this.flushingSessions.poll()) != null) {
            try {
                this.flush(session);
            }
            catch (IOException e) {
                session.getFilterChain().fireExceptionCaught(session, e);
            }
        }
    }

    private void flush(DatagramSessionImpl session) throws IOException {
        IoFilter.WriteRequest req;
        DatagramChannel ch = session.getChannel();
        Queue<IoFilter.WriteRequest> writeRequestQueue = session.getWriteRequestQueue();
        while ((req = writeRequestQueue.peek()) != null) {
            ByteBuffer buf = (ByteBuffer)req.getMessage();
            if (buf.remaining() == 0) {
                writeRequestQueue.poll();
                session.increaseWrittenMessages();
                buf.reset();
                session.getFilterChain().fireMessageSent(session, req);
                continue;
            }
            SelectionKey key = session.getSelectionKey();
            if (key == null) {
                this.scheduleFlush(session);
                break;
            }
            if (!key.isValid()) continue;
            int writtenBytes = ch.write(buf.buf());
            if (writtenBytes == 0) {
                key.interestOps(key.interestOps() | 4);
                continue;
            }
            if (writtenBytes <= 0) continue;
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
            writeRequestQueue.poll();
            session.increaseWrittenBytes(writtenBytes);
            session.increaseWrittenMessages();
            buf.reset();
            session.getFilterChain().fireMessageSent(session, req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNew() {
        RegistrationRequest req;
        if (this.registerQueue.isEmpty()) {
            return;
        }
        while ((req = this.registerQueue.poll()) != null) {
            DatagramSessionImpl session = new DatagramSessionImpl(this.wrapper, this, req.config, req.channel, req.handler, req.channel.socket().getRemoteSocketAddress());
            session.setAttribute(AbstractIoFilterChain.CONNECT_FUTURE, req);
            boolean success = false;
            try {
                SelectionKey key = req.channel.register(this.selector, 1, session);
                session.setSelectionKey(key);
                this.buildFilterChain(req, session);
                this.getSessionRecycler(session).put(session);
                this.getListeners().fireSessionCreated(session);
                success = true;
            }
            catch (Throwable t) {
                session.getFilterChain().fireExceptionCaught(session, t);
            }
            finally {
                if (success) continue;
                try {
                    req.channel.disconnect();
                    req.channel.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
    }

    private void buildFilterChain(RegistrationRequest req, IoSession session) throws Exception {
        this.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
        req.config.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
        req.config.getThreadModel().buildFilterChain(session.getFilterChain());
    }

    private void cancelKeys() {
        DatagramSessionImpl session;
        if (this.cancelQueue.isEmpty()) {
            return;
        }
        while ((session = this.cancelQueue.poll()) != null) {
            SelectionKey key = session.getSelectionKey();
            DatagramChannel ch = (DatagramChannel)key.channel();
            try {
                ch.disconnect();
                ch.close();
            }
            catch (IOException e) {
                ExceptionMonitor.getInstance().exceptionCaught(e);
            }
            this.getListeners().fireSessionDestroyed(session);
            session.getCloseFuture().setClosed();
            key.cancel();
            this.selector.wakeup();
        }
    }

    private static class RegistrationRequest
    extends DefaultConnectFuture {
        private final DatagramChannel channel;
        private final IoHandler handler;
        private final IoServiceConfig config;

        private RegistrationRequest(DatagramChannel channel, IoHandler handler, IoServiceConfig config) {
            this.channel = channel;
            this.handler = handler;
            this.config = config;
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread.currentThread().setName("DatagramConnector-" + DatagramConnectorDelegate.this.id);
            while (true) {
                try {
                    do {
                        int nKeys = DatagramConnectorDelegate.this.selector.select();
                        DatagramConnectorDelegate.this.registerNew();
                        DatagramConnectorDelegate.this.doUpdateTrafficMask();
                        if (nKeys > 0) {
                            DatagramConnectorDelegate.this.processReadySessions(DatagramConnectorDelegate.this.selector.selectedKeys());
                        }
                        DatagramConnectorDelegate.this.flushSessions();
                        DatagramConnectorDelegate.this.cancelKeys();
                    } while (!DatagramConnectorDelegate.this.selector.keys().isEmpty());
                    Object object = DatagramConnectorDelegate.this.lock;
                    synchronized (object) {
                        if (DatagramConnectorDelegate.this.selector.keys().isEmpty() && DatagramConnectorDelegate.this.registerQueue.isEmpty() && DatagramConnectorDelegate.this.cancelQueue.isEmpty()) {
                            DatagramConnectorDelegate.this.worker = null;
                            try {
                                DatagramConnectorDelegate.this.selector.close();
                            }
                            catch (IOException e) {
                                ExceptionMonitor.getInstance().exceptionCaught(e);
                            }
                            finally {
                                DatagramConnectorDelegate.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ExceptionMonitor.getInstance().exceptionCaught(e1);
                    }
                    continue;
                }
                break;
            }
        }
    }
}

