/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import uk.ltd.getahead.dwr.util.Logger;

public final class LocalUtil {
    public static final int INBOUND_INDEX_TYPE = 0;
    public static final int INBOUND_INDEX_VALUE = 1;
    private static final Logger log = Logger.getLogger(LocalUtil.class);
    private static boolean warn13 = false;
    private static boolean testedDecoder = false;
    private static Method decode14 = null;

    private LocalUtil() {
    }

    public static String replace(String text, String repl, String with) {
        int foundAt;
        if (text == null || repl == null || with == null || repl.length() == 0) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int searchFrom = 0;
        while ((foundAt = text.indexOf(repl, searchFrom)) != -1) {
            buf.append(text.substring(searchFrom, foundAt)).append(with);
            searchFrom = foundAt + repl.length();
        }
        buf.append(text.substring(searchFrom));
        return buf.toString();
    }

    public static boolean isEquivalent(Class c1, Class c2) {
        if (c1 == Boolean.class || c1 == Boolean.TYPE) {
            return c2 == Boolean.class || c2 == Boolean.TYPE;
        }
        if (c1 == Byte.class || c1 == Byte.TYPE) {
            return c2 == Byte.class || c2 == Byte.TYPE;
        }
        if (c1 == Character.class || c1 == Character.TYPE) {
            return c2 == Character.class || c2 == Character.TYPE;
        }
        if (c1 == Short.class || c1 == Short.TYPE) {
            return c2 == Short.class || c2 == Short.TYPE;
        }
        if (c1 == Integer.class || c1 == Integer.TYPE) {
            return c2 == Integer.class || c2 == Integer.TYPE;
        }
        if (c1 == Long.class || c1 == Long.TYPE) {
            return c2 == Long.class || c2 == Long.TYPE;
        }
        if (c1 == Float.class || c1 == Float.TYPE) {
            return c2 == Float.class || c2 == Float.TYPE;
        }
        if (c1 == Double.class || c1 == Double.TYPE) {
            return c2 == Double.class || c2 == Double.TYPE;
        }
        if (c1 == Void.class || c1 == Void.TYPE) {
            return c2 == Void.class || c2 == Void.TYPE;
        }
        return false;
    }

    public static Class getNonPrimitiveType(Class type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Void.TYPE) {
            return Void.class;
        }
        return null;
    }

    public static void addNoCacheHeaders(HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        resp.addHeader("Cache-Control", "post-check=0, pre-check=0");
        resp.setHeader("Pragma", "no-cache");
        resp.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
    }

    public static boolean isServletClass(Class paramType) {
        return paramType == HttpServletRequest.class || paramType == HttpServletResponse.class || paramType == ServletConfig.class || paramType == ServletContext.class || paramType == HttpSession.class;
    }

    public static String decode(String value) {
        if (!testedDecoder) {
            block6: {
                try {
                    decode14 = URLDecoder.class.getMethod("decode", String.class, String.class);
                }
                catch (Exception ex) {
                    if (warn13) break block6;
                    log.warn("URLDecoder.decode(String, String) is not available. Falling back to 1.3 variant.");
                    warn13 = true;
                }
            }
            testedDecoder = true;
        }
        if (decode14 != null) {
            try {
                return (String)decode14.invoke(null, value, "UTF-8");
            }
            catch (Exception ex) {
                log.warn("Failed to use JDK 1.4 decoder", ex);
            }
        }
        return URLDecoder.decode(value);
    }

    public static void setProperty(Object object, String key, Object value) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> real = object.getClass();
        String setterName = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
        Method method = real.getMethod(setterName, value.getClass());
        if (method == null) {
            throw new NoSuchMethodException("Missing property: " + key);
        }
        method.invoke(object, value);
    }

    public static String[] splitInbound(String data) {
        String[] reply = new String[2];
        int colon = data.indexOf(":");
        if (colon == -1) {
            log.error("Missing : in conversion data (" + data + ')');
            reply[0] = "string";
            reply[1] = data;
        } else {
            reply[0] = data.substring(0, colon);
            reply[1] = data.substring(colon + 1);
        }
        return reply;
    }

    public static String getShortClassName(Class clazz) {
        String className = clazz.getName();
        char[] chars = className.toCharArray();
        int lastDot = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '.') {
                lastDot = i + 1;
                continue;
            }
            if (chars[i] != '$') continue;
            chars[i] = 46;
        }
        return new String(chars, lastDot, chars.length - lastDot);
    }
}

