/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.ExecutionException;

public final class ExceptionUtil {
    private static final String EXCEPTION_SEPARATOR = "------ End remote and begin local stack-trace ------";
    private static final String EXCEPTION_MESSAGE_SEPARATOR = "------ %MSG% ------";

    private ExceptionUtil() {
    }

    public static String toString(Throwable cause) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        cause.printStackTrace(pw);
        return sw.toString();
    }

    public static RuntimeException rethrow(Throwable t) {
        if (t instanceof Error) {
            if (t instanceof OutOfMemoryError) {
                OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)t);
            }
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof ExecutionException) {
            Throwable cause = t.getCause();
            if (cause != null) {
                throw ExceptionUtil.rethrow(cause);
            }
            throw new HazelcastException(t);
        }
        throw new HazelcastException(t);
    }

    public static <T extends Throwable> RuntimeException rethrow(Throwable t, Class<T> allowedType) throws T {
        if (t instanceof Error) {
            if (t instanceof OutOfMemoryError) {
                OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)t);
            }
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof ExecutionException) {
            Throwable cause = t.getCause();
            if (cause != null) {
                throw ExceptionUtil.rethrow(cause, allowedType);
            }
            throw new HazelcastException(t);
        }
        if (allowedType.isAssignableFrom(t.getClass())) {
            throw t;
        }
        throw new HazelcastException(t);
    }

    public static <T extends Throwable> RuntimeException rethrowAllowedTypeFirst(Throwable t, Class<T> allowedType) throws T {
        if (t instanceof Error) {
            if (t instanceof OutOfMemoryError) {
                OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)t);
            }
            throw (Error)t;
        }
        if (allowedType.isAssignableFrom(t.getClass())) {
            throw t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof ExecutionException) {
            Throwable cause = t.getCause();
            if (cause != null) {
                throw ExceptionUtil.rethrowAllowedTypeFirst(cause, allowedType);
            }
            throw new HazelcastException(t);
        }
        throw new HazelcastException(t);
    }

    public static RuntimeException rethrowAllowInterrupted(Throwable t) throws InterruptedException {
        return ExceptionUtil.rethrow(t, InterruptedException.class);
    }

    public static <T> T sneakyThrow(Throwable t) {
        ExceptionUtil.sneakyThrowInternal(t);
        return (T)t;
    }

    private static <T extends Throwable> void sneakyThrowInternal(Throwable t) throws T {
        throw t;
    }

    public static void fixRemoteStackTrace(Throwable remoteCause, StackTraceElement[] localSideStackTrace) {
        Throwable throwable = remoteCause;
        if (remoteCause instanceof ExecutionException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        StackTraceElement[] remoteStackTrace = throwable.getStackTrace();
        StackTraceElement[] newStackTrace = new StackTraceElement[localSideStackTrace.length + remoteStackTrace.length];
        System.arraycopy(remoteStackTrace, 0, newStackTrace, 0, remoteStackTrace.length);
        newStackTrace[remoteStackTrace.length] = new StackTraceElement(EXCEPTION_SEPARATOR, "", null, -1);
        System.arraycopy(localSideStackTrace, 1, newStackTrace, remoteStackTrace.length + 1, localSideStackTrace.length - 1);
        throwable.setStackTrace(newStackTrace);
    }

    public static void fixRemoteStackTrace(Throwable remoteCause, StackTraceElement[] localSideStackTrace, String localExceptionMessage) {
        Throwable throwable = remoteCause;
        if (remoteCause instanceof ExecutionException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        String msg = EXCEPTION_MESSAGE_SEPARATOR.replace("%MSG%", localExceptionMessage);
        StackTraceElement[] remoteStackTrace = throwable.getStackTrace();
        StackTraceElement[] newStackTrace = new StackTraceElement[localSideStackTrace.length + remoteStackTrace.length + 1];
        System.arraycopy(remoteStackTrace, 0, newStackTrace, 0, remoteStackTrace.length);
        newStackTrace[remoteStackTrace.length] = new StackTraceElement(EXCEPTION_SEPARATOR, "", null, -1);
        StackTraceElement nextElement = localSideStackTrace[1];
        newStackTrace[remoteStackTrace.length + 1] = new StackTraceElement(msg, nextElement.getMethodName(), nextElement.getFileName(), nextElement.getLineNumber());
        System.arraycopy(localSideStackTrace, 1, newStackTrace, remoteStackTrace.length + 2, localSideStackTrace.length - 1);
        throwable.setStackTrace(newStackTrace);
    }
}

