/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.ltd.getahead.dwr.AccessControl;
import uk.ltd.getahead.dwr.Creator;
import uk.ltd.getahead.dwr.CreatorManager;
import uk.ltd.getahead.dwr.Processor;
import uk.ltd.getahead.dwr.util.JavascriptUtil;
import uk.ltd.getahead.dwr.util.LocalUtil;

public class DefaultInterfaceProcessor
implements Processor {
    private String overridePath = null;
    protected CreatorManager creatorManager = null;
    protected AccessControl accessControl = null;
    private boolean allowImpossibleTests = false;
    private JavascriptUtil jsutil = new JavascriptUtil();

    public void handle(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathinfo = req.getPathInfo();
        String servletpath = req.getServletPath();
        if (pathinfo == null) {
            pathinfo = req.getServletPath();
            servletpath = "/";
        }
        String scriptname = pathinfo;
        scriptname = LocalUtil.replace(scriptname, "/interface/", "");
        scriptname = LocalUtil.replace(scriptname, ".js", "");
        Creator creator = this.creatorManager.getCreator(scriptname);
        PrintWriter out = resp.getWriter();
        out.println();
        out.println("function " + scriptname + "() { }");
        String path = this.overridePath;
        if (path == null) {
            path = String.valueOf(req.getContextPath()) + servletpath;
        }
        out.println(String.valueOf(scriptname) + "._path = '" + path + "';");
        Method[] methods = creator.getType().getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            String methodName = method.getName();
            String reason = this.accessControl.getReasonToNotDisplay(req, creator, scriptname, method);
            if ((reason == null || this.allowImpossibleTests) && !this.jsutil.isReservedWord(methodName)) {
                out.print('\n');
                out.print(String.valueOf(scriptname) + '.' + methodName + " = function(");
                Class<?>[] paramTypes = method.getParameterTypes();
                int j = 0;
                while (j < paramTypes.length) {
                    if (!LocalUtil.isServletClass(paramTypes[j])) {
                        out.print("p" + j + ", ");
                    }
                    ++j;
                }
                out.println("callback) {");
                out.print("    DWREngine._execute(" + scriptname + "._path, '" + scriptname + "', '" + methodName + "', ");
                j = 0;
                while (j < paramTypes.length) {
                    if (LocalUtil.isServletClass(paramTypes[j])) {
                        out.print("false, ");
                    } else {
                        out.print("p" + j + ", ");
                    }
                    ++j;
                }
                out.println("callback);");
                out.println('}');
            }
            ++i;
        }
        out.flush();
    }

    public void setCreatorManager(CreatorManager creatorManager) {
        this.creatorManager = creatorManager;
    }

    public void setAccessControl(AccessControl accessControl) {
        this.accessControl = accessControl;
    }

    public void setAllowImpossibleTests(boolean allowImpossibleTests) {
        this.allowImpossibleTests = allowImpossibleTests;
    }

    public void setOverridePath(String overridePath) {
        this.overridePath = overridePath;
    }
}

