/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.WriteTimeoutException;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.SocketSessionImpl;
import org.apache.mina.util.NamePreservingRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SocketIoProcessor {
    private final Object lock = new Object();
    private final String threadName;
    private final Executor executor;
    private volatile Selector selector;
    private final Queue<SocketSessionImpl> newSessions = new ConcurrentLinkedQueue<SocketSessionImpl>();
    private final Queue<SocketSessionImpl> removingSessions = new ConcurrentLinkedQueue<SocketSessionImpl>();
    private final Queue<SocketSessionImpl> flushingSessions = new ConcurrentLinkedQueue<SocketSessionImpl>();
    private final Queue<SocketSessionImpl> trafficControllingSessions = new ConcurrentLinkedQueue<SocketSessionImpl>();
    private Worker worker;
    private long lastIdleCheckTime = System.currentTimeMillis();

    SocketIoProcessor(String threadName, Executor executor) {
        this.threadName = threadName;
        this.executor = executor;
    }

    void addNew(SocketSessionImpl session) throws IOException {
        this.newSessions.add(session);
        this.startupWorker();
    }

    void remove(SocketSessionImpl session) throws IOException {
        this.scheduleRemove(session);
        this.startupWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupWorker() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.worker == null) {
                this.selector = Selector.open();
                this.worker = new Worker();
                this.executor.execute(new NamePreservingRunnable(this.worker));
            }
            this.selector.wakeup();
        }
    }

    void flush(SocketSessionImpl session) {
        this.scheduleFlush(session);
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
    }

    void updateTrafficMask(SocketSessionImpl session) {
        this.scheduleTrafficControl(session);
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
    }

    private void scheduleRemove(SocketSessionImpl session) {
        this.removingSessions.add(session);
    }

    private void scheduleFlush(SocketSessionImpl session) {
        this.flushingSessions.add(session);
    }

    private void scheduleTrafficControl(SocketSessionImpl session) {
        this.trafficControllingSessions.add(session);
    }

    private void doAddNew() {
        SocketSessionImpl session;
        Selector selector = this.selector;
        while ((session = this.newSessions.poll()) != null) {
            SocketChannel ch = session.getChannel();
            try {
                ch.configureBlocking(false);
                session.setSelectionKey(ch.register(selector, 1, session));
                session.getServiceListeners().fireSessionCreated(session);
            }
            catch (IOException e) {
                session.getFilterChain().fireExceptionCaught(session, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemove() {
        SocketSessionImpl session;
        while ((session = this.removingSessions.poll()) != null) {
            SocketChannel ch = session.getChannel();
            SelectionKey key = session.getSelectionKey();
            if (key == null) {
                this.scheduleRemove(session);
                break;
            }
            if (!key.isValid()) continue;
            try {
                key.cancel();
                ch.close();
            }
            catch (IOException e) {
                session.getFilterChain().fireExceptionCaught(session, e);
            }
            finally {
                this.releaseWriteBuffers(session);
                session.getServiceListeners().fireSessionDestroyed(session);
            }
        }
    }

    private void process(Set<SelectionKey> selectedKeys) {
        for (SelectionKey key : selectedKeys) {
            SocketSessionImpl session = (SocketSessionImpl)key.attachment();
            if (key.isReadable() && session.getTrafficMask().isReadable()) {
                this.read(session);
            }
            if (!key.isWritable() || !session.getTrafficMask().isWritable()) continue;
            this.scheduleFlush(session);
        }
        selectedKeys.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(SocketSessionImpl session) {
        ByteBuffer buf = ByteBuffer.allocate(session.getReadBufferSize());
        SocketChannel ch = session.getChannel();
        try {
            int ret;
            int readBytes = 0;
            try {
                while ((ret = ch.read(buf.buf())) > 0) {
                    readBytes += ret;
                }
            }
            finally {
                buf.flip();
            }
            session.increaseReadBytes(readBytes);
            if (readBytes > 0) {
                int newReadBufferSize;
                session.getFilterChain().fireMessageReceived(session, buf);
                buf = null;
                if (readBytes * 2 < session.getReadBufferSize()) {
                    if (session.getReadBufferSize() > 64) {
                        session.setReadBufferSize(session.getReadBufferSize() >>> 1);
                    }
                } else if (readBytes == session.getReadBufferSize() && (newReadBufferSize = session.getReadBufferSize() << 1) <= ((SocketSessionConfig)session.getConfig()).getReceiveBufferSize() << 1) {
                    session.setReadBufferSize(newReadBufferSize);
                }
            }
            if (ret < 0) {
                this.scheduleRemove(session);
            }
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                this.scheduleRemove(session);
            }
            session.getFilterChain().fireExceptionCaught(session, e);
        }
        finally {
            if (buf != null) {
                buf.release();
            }
        }
    }

    private void notifyIdleness() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastIdleCheckTime >= 1000L) {
            this.lastIdleCheckTime = currentTime;
            Set<SelectionKey> keys = this.selector.keys();
            if (keys != null) {
                for (SelectionKey key : keys) {
                    SocketSessionImpl session = (SocketSessionImpl)key.attachment();
                    this.notifyIdleness(session, currentTime);
                }
            }
        }
    }

    private void notifyIdleness(SocketSessionImpl session, long currentTime) {
        this.notifyIdleness0(session, currentTime, session.getIdleTimeInMillis(IdleStatus.BOTH_IDLE), IdleStatus.BOTH_IDLE, Math.max(session.getLastIoTime(), session.getLastIdleTime(IdleStatus.BOTH_IDLE)));
        this.notifyIdleness0(session, currentTime, session.getIdleTimeInMillis(IdleStatus.READER_IDLE), IdleStatus.READER_IDLE, Math.max(session.getLastReadTime(), session.getLastIdleTime(IdleStatus.READER_IDLE)));
        this.notifyIdleness0(session, currentTime, session.getIdleTimeInMillis(IdleStatus.WRITER_IDLE), IdleStatus.WRITER_IDLE, Math.max(session.getLastWriteTime(), session.getLastIdleTime(IdleStatus.WRITER_IDLE)));
        this.notifyWriteTimeout(session, currentTime, session.getWriteTimeoutInMillis(), session.getLastWriteTime());
    }

    private void notifyIdleness0(SocketSessionImpl session, long currentTime, long idleTime, IdleStatus status, long lastIoTime) {
        if (idleTime > 0L && lastIoTime != 0L && currentTime - lastIoTime >= idleTime) {
            session.increaseIdleCount(status);
            session.getFilterChain().fireSessionIdle(session, status);
        }
    }

    private void notifyWriteTimeout(SocketSessionImpl session, long currentTime, long writeTimeout, long lastIoTime) {
        SelectionKey key = session.getSelectionKey();
        if (writeTimeout > 0L && currentTime - lastIoTime >= writeTimeout && key != null && key.isValid() && (key.interestOps() & 4) != 0) {
            session.getFilterChain().fireExceptionCaught(session, new WriteTimeoutException());
        }
    }

    private void doFlush() {
        SocketSessionImpl session;
        while ((session = this.flushingSessions.poll()) != null) {
            if (!session.isConnected()) {
                this.releaseWriteBuffers(session);
                continue;
            }
            SelectionKey key = session.getSelectionKey();
            if (key == null) {
                this.scheduleFlush(session);
                break;
            }
            if (!key.isValid()) continue;
            try {
                this.doFlush(session);
            }
            catch (IOException e) {
                this.scheduleRemove(session);
                session.getFilterChain().fireExceptionCaught(session, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWriteBuffers(SocketSessionImpl session) {
        Queue<IoFilter.WriteRequest> writeRequestQueue = session.getWriteRequestQueue();
        IoFilter.WriteRequest req = writeRequestQueue.poll();
        if (req != null) {
            ByteBuffer buf = (ByteBuffer)req.getMessage();
            try {
                buf.release();
            }
            catch (IllegalStateException e) {
                session.getFilterChain().fireExceptionCaught(session, e);
            }
            finally {
                if (buf.hasRemaining()) {
                    req.getFuture().setWritten(false);
                } else {
                    session.getFilterChain().fireMessageSent(session, req);
                }
            }
            while ((req = writeRequestQueue.poll()) != null) {
                try {
                    ((ByteBuffer)req.getMessage()).release();
                }
                catch (IllegalStateException e) {
                    session.getFilterChain().fireExceptionCaught(session, e);
                }
                finally {
                    req.getFuture().setWritten(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlush(SocketSessionImpl session) throws IOException {
        block7: {
            SelectionKey key = session.getSelectionKey();
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
            SocketChannel ch = session.getChannel();
            Queue<IoFilter.WriteRequest> writeRequestQueue = session.getWriteRequestQueue();
            int writtenBytes = 0;
            int maxWrittenBytes = ((SocketSessionConfig)session.getConfig()).getSendBufferSize() << 1;
            try {
                while (true) {
                    IoFilter.WriteRequest req;
                    if ((req = writeRequestQueue.peek()) == null) {
                        break block7;
                    }
                    ByteBuffer buf = (ByteBuffer)req.getMessage();
                    if (buf.remaining() == 0) {
                        writeRequestQueue.poll();
                        session.increaseWrittenMessages();
                        buf.reset();
                        session.getFilterChain().fireMessageSent(session, req);
                        continue;
                    }
                    if (key.isWritable()) {
                        writtenBytes += ch.write(buf.buf());
                    }
                    if (buf.hasRemaining() || writtenBytes >= maxWrittenBytes) break;
                }
                key.interestOps(key.interestOps() | 4);
            }
            finally {
                session.increaseWrittenBytes(writtenBytes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateTrafficMask() {
        SocketSessionImpl session;
        if (this.trafficControllingSessions.isEmpty()) {
            return;
        }
        while ((session = this.trafficControllingSessions.poll()) != null) {
            Queue<IoFilter.WriteRequest> writeRequestQueue;
            SelectionKey key = session.getSelectionKey();
            if (key == null) {
                this.scheduleTrafficControl(session);
                break;
            }
            if (!key.isValid()) continue;
            int ops = 1;
            Queue<IoFilter.WriteRequest> queue = writeRequestQueue = session.getWriteRequestQueue();
            synchronized (queue) {
                if (!writeRequestQueue.isEmpty()) {
                    ops |= 4;
                }
            }
            int mask = session.getTrafficMask().getInterestOps();
            key.interestOps(ops & mask);
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread.currentThread().setName(SocketIoProcessor.this.threadName);
            Selector selector = SocketIoProcessor.this.selector;
            while (true) {
                try {
                    do {
                        int nKeys = selector.select(1000L);
                        SocketIoProcessor.this.doAddNew();
                        SocketIoProcessor.this.doUpdateTrafficMask();
                        if (nKeys > 0) {
                            SocketIoProcessor.this.process(selector.selectedKeys());
                        }
                        SocketIoProcessor.this.doFlush();
                        SocketIoProcessor.this.doRemove();
                        SocketIoProcessor.this.notifyIdleness();
                    } while (!selector.keys().isEmpty());
                    Object object = SocketIoProcessor.this.lock;
                    synchronized (object) {
                        if (selector.keys().isEmpty() && SocketIoProcessor.this.newSessions.isEmpty()) {
                            SocketIoProcessor.this.worker = null;
                            try {
                                selector.close();
                            }
                            catch (IOException e) {
                                ExceptionMonitor.getInstance().exceptionCaught(e);
                            }
                            finally {
                                selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (Throwable t) {
                    ExceptionMonitor.getInstance().exceptionCaught(t);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ExceptionMonitor.getInstance().exceptionCaught(e1);
                    }
                    continue;
                }
                break;
            }
        }
    }
}

