/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.cmd;

import java.io.IOException;
import org.jrobin.cmd.ColonSplitter;
import org.jrobin.cmd.RrdToolCmd;
import org.jrobin.core.Datasource;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;

class RrdTuneCmd
extends RrdToolCmd {
    RrdTuneCmd() {
    }

    String getCmdType() {
        return "tune";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object execute() throws RrdException, IOException {
        String[] stringArray = this.getMultipleOptionValues("h", "heartbeat");
        String[] stringArray2 = this.getMultipleOptionValues("i", "minimum");
        String[] stringArray3 = this.getMultipleOptionValues("a", "maximum");
        String[] stringArray4 = this.getMultipleOptionValues("d", "data-source-type");
        String[] stringArray5 = this.getMultipleOptionValues("r", "data-source-rename");
        String[] stringArray6 = this.getRemainingWords();
        if (stringArray6.length < 2) {
            throw new RrdException("File name not specified");
        }
        if (stringArray6.length > 2) {
            throw new RrdException("Unexpected token encountered: " + stringArray6[2]);
        }
        String string = stringArray6[1];
        RrdDb rrdDb = RrdTuneCmd.getRrdDbReference(string);
        try {
            for (String string2 : stringArray) {
                this.tuneHeartbeat(rrdDb, string2);
            }
            for (String string2 : stringArray2) {
                this.tuneMinimum(rrdDb, string2);
            }
            for (String string2 : stringArray3) {
                this.tuneMaximum(rrdDb, string2);
            }
            for (String string2 : stringArray5) {
                this.tuneName(rrdDb, string2);
            }
            for (String string2 : stringArray4) {
                this.tuneType(rrdDb, string2);
            }
            if (stringArray.length == 0 && stringArray2.length == 0 && stringArray3.length == 0 && stringArray4.length == 0 && stringArray5.length == 0) {
                this.dump(rrdDb);
            }
        }
        finally {
            RrdTuneCmd.releaseRrdDbReference(rrdDb);
        }
        return string;
    }

    private void tuneHeartbeat(RrdDb rrdDb, String string) throws RrdException, IOException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2) {
            throw new RrdException("Invalid suntax in: " + string);
        }
        String string2 = stringArray[0];
        long l = Long.parseLong(stringArray[1]);
        Datasource datasource = rrdDb.getDatasource(string2);
        datasource.setHeartbeat(l);
    }

    private void tuneMinimum(RrdDb rrdDb, String string) throws RrdException, IOException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2) {
            throw new RrdException("Invalid suntax in: " + string);
        }
        String string2 = stringArray[0];
        double d = Util.parseDouble(stringArray[1]);
        Datasource datasource = rrdDb.getDatasource(string2);
        datasource.setMinValue(d, false);
    }

    private void tuneMaximum(RrdDb rrdDb, String string) throws RrdException, IOException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2) {
            throw new RrdException("Invalid suntax in: " + string);
        }
        String string2 = stringArray[0];
        double d = Util.parseDouble(stringArray[1]);
        Datasource datasource = rrdDb.getDatasource(string2);
        datasource.setMaxValue(d, false);
    }

    private void tuneName(RrdDb rrdDb, String string) throws RrdException, IOException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2) {
            throw new RrdException("Invalid suntax in: " + string);
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Datasource datasource = rrdDb.getDatasource(string2);
        datasource.setDsName(string3);
    }

    private void tuneType(RrdDb rrdDb, String string) throws RrdException, IOException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2) {
            throw new RrdException("Invalid suntax in: " + string);
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Datasource datasource = rrdDb.getDatasource(string2);
        datasource.setDsType(string3);
    }

    private void dump(RrdDb rrdDb) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = rrdDb.getDsCount();
        for (int i = 0; i < n; ++i) {
            Datasource datasource = rrdDb.getDatasource(i);
            stringBuffer.append("DS[");
            stringBuffer.append(datasource.getDsName());
            stringBuffer.append("] typ: ");
            stringBuffer.append(datasource.getDsType());
            while (stringBuffer.length() < 24) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("hbt: ");
            stringBuffer.append(datasource.getHeartbeat());
            while (stringBuffer.length() < 40) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("min: ");
            stringBuffer.append(String.format("%-11f", datasource.getMinValue()));
            stringBuffer.append("max: ");
            stringBuffer.append(String.format("%-11f", datasource.getMaxValue()));
            RrdTuneCmd.println(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
    }
}

