/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.util.FileUtils;

public class JavaEnvUtils {
    private static final boolean isDos = Os.isFamily("dos");
    private static final boolean isNetware = Os.isName("netware");
    private static final boolean isAix = Os.isName("aix");
    private static final String javaHome = System.getProperty("java.home");
    private static final FileUtils fileUtils = FileUtils.newFileUtils();
    private static String javaVersion;
    private static int javaVersionNumber;
    public static final String JAVA_1_0 = "1.0";
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    public static final String JAVA_1_4 = "1.4";
    public static final String JAVA_1_5 = "1.5";
    private static Vector jrePackages;

    public static String getJavaVersion() {
        return javaVersion;
    }

    public static boolean isJavaVersion(String string) {
        boolean bl = false;
        if (javaVersion == string) {
            bl = true;
        }
        return bl;
    }

    public static String getJreExecutable(String string) {
        if (isNetware) {
            return string;
        }
        File file = null;
        if (isAix) {
            file = JavaEnvUtils.findInDir(javaHome + "/sh", string);
        }
        if (file == null) {
            file = JavaEnvUtils.findInDir(javaHome + "/bin", string);
        }
        if (file != null) {
            return file.getAbsolutePath();
        }
        return JavaEnvUtils.addExtension(string);
    }

    public static String getJdkExecutable(String string) {
        if (isNetware) {
            return string;
        }
        File file = null;
        if (isAix) {
            file = JavaEnvUtils.findInDir(javaHome + "/../sh", string);
        }
        if (file == null) {
            file = JavaEnvUtils.findInDir(javaHome + "/../bin", string);
        }
        if (file != null) {
            return file.getAbsolutePath();
        }
        return JavaEnvUtils.getJreExecutable(string);
    }

    private static final String addExtension(String string) {
        return string + (isDos ? ".exe" : "");
    }

    private static final File findInDir(String string, String string2) {
        File file = fileUtils.normalize(string);
        File file2 = null;
        if (file.exists() && !(file2 = new File(file, JavaEnvUtils.addExtension(string2))).exists()) {
            file2 = null;
        }
        return file2;
    }

    private static final void buildJrePackages() {
        jrePackages = new Vector();
        switch (javaVersionNumber) {
            case 14: 
            case 15: {
                jrePackages.addElement("org.apache.crimson");
                jrePackages.addElement("org.apache.xalan");
                jrePackages.addElement("org.apache.xml");
                jrePackages.addElement("org.apache.xpath");
                jrePackages.addElement("org.ietf.jgss");
                jrePackages.addElement("org.w3c.dom");
                jrePackages.addElement("org.xml.sax");
            }
            case 13: {
                jrePackages.addElement("org.omg");
                jrePackages.addElement("com.sun.corba");
                jrePackages.addElement("com.sun.jndi");
                jrePackages.addElement("com.sun.media");
                jrePackages.addElement("com.sun.naming");
                jrePackages.addElement("com.sun.org.omg");
                jrePackages.addElement("com.sun.rmi");
                jrePackages.addElement("sunw.io");
                jrePackages.addElement("sunw.util");
            }
            case 12: {
                jrePackages.addElement("com.sun.java");
                jrePackages.addElement("com.sun.image");
            }
        }
        jrePackages.addElement("sun");
        jrePackages.addElement("java");
        jrePackages.addElement("javax");
    }

    public static Vector getJrePackageTestCases() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("java.lang.Object");
        switch (javaVersionNumber) {
            case 14: 
            case 15: {
                vector.addElement("sun.audio.AudioPlayer");
                vector.addElement("org.apache.crimson.parser.ContentModel");
                vector.addElement("org.apache.xalan.processor.ProcessorImport");
                vector.addElement("org.apache.xml.utils.URI");
                vector.addElement("org.apache.xpath.XPathFactory");
                vector.addElement("org.ietf.jgss.Oid");
                vector.addElement("org.w3c.dom.Attr");
                vector.addElement("org.xml.sax.XMLReader");
            }
            case 13: {
                vector.addElement("org.omg.CORBA.Any");
                vector.addElement("com.sun.corba.se.internal.corba.AnyImpl");
                vector.addElement("com.sun.jndi.ldap.LdapURL");
                vector.addElement("com.sun.media.sound.Printer");
                vector.addElement("com.sun.naming.internal.VersionHelper");
                vector.addElement("com.sun.org.omg.CORBA.Initializer");
                vector.addElement("sunw.io.Serializable");
                vector.addElement("sunw.util.EventListener");
            }
            case 12: {
                vector.addElement("javax.accessibility.Accessible");
                vector.addElement("sun.misc.BASE64Encoder");
                vector.addElement("com.sun.image.codec.jpeg.JPEGCodec");
            }
        }
        vector.addElement("sun.reflect.SerializationConstructorAccessorImpl");
        vector.addElement("sun.net.www.http.HttpClient");
        vector.addElement("sun.audio.AudioPlayer");
        return vector;
    }

    public static Vector getJrePackages() {
        if (jrePackages == null) {
            JavaEnvUtils.buildJrePackages();
        }
        return jrePackages;
    }

    static {
        try {
            javaVersion = JAVA_1_0;
            javaVersionNumber = 10;
            Class.forName("java.lang.Void");
            javaVersion = JAVA_1_1;
            ++javaVersionNumber;
            Class.forName("java.lang.ThreadLocal");
            javaVersion = JAVA_1_2;
            ++javaVersionNumber;
            Class.forName("java.lang.StrictMath");
            javaVersion = JAVA_1_3;
            ++javaVersionNumber;
            Class.forName("java.lang.CharSequence");
            javaVersion = JAVA_1_4;
            ++javaVersionNumber;
            Class.forName("java.lang.Readable");
            javaVersion = JAVA_1_5;
            ++javaVersionNumber;
        }
        catch (Throwable throwable) {}
    }
}

