/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hsqldb.jdbc.Util;

public class jdbcBlob
implements Blob {
    volatile byte[] data;

    public jdbcBlob(byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw Util.sqlException(62, "null");
        }
        this.data = byArray;
    }

    public long length() throws SQLException {
        byte[] byArray = this.data;
        return byArray.length;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        byte[] byArray = this.data;
        int n2 = byArray.length;
        if (--l < 0L || l > (long)n2) {
            throw Util.sqlException(62, "pos: " + (l + 1L));
        }
        if (n < 0 || (long)n > (long)n2 - l) {
            throw Util.sqlException(62, "length: " + n);
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, (int)l, byArray2, 0, n);
        return byArray2;
    }

    public InputStream getBinaryStream() throws SQLException {
        byte[] byArray = this.data;
        return new ByteArrayInputStream(byArray);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        byte[] byArray2 = this.data;
        int n = byArray2.length;
        if (l > (long)n || byArray == null) {
            return -1L;
        }
        l = l < 1L ? 0L : --l;
        int n2 = byArray.length;
        if (n2 == 0 || l > (long)(n - n2)) {
            return -1L;
        }
        int n3 = n - n2;
        byte by = byArray[0];
        block0: for (int i = (int)l; i <= n3; ++i) {
            if (byArray2[i] != by) continue;
            int n4 = n2;
            int n5 = i;
            int n6 = 0;
            boolean bl = true;
            while (n4-- > 0) {
                if (byArray2[n5++] == byArray[n6++]) continue;
                continue block0;
            }
            return i + 1;
        }
        return -1L;
    }

    public long position(Blob blob, long l) throws SQLException {
        byte[] byArray = this.data;
        int n = byArray.length;
        if (l > (long)n || blob == null) {
            return -1L;
        }
        l = l < 1L ? 0L : --l;
        long l2 = blob.length();
        if (l2 == 0L || l > (long)n - l2) {
            return -1L;
        }
        int n2 = (int)l2;
        byte[] byArray2 = blob instanceof jdbcBlob ? ((jdbcBlob)blob).data : blob.getBytes(1L, n2);
        int n3 = n - n2;
        byte by = byArray2[0];
        block0: for (int i = (int)l; i <= n3; ++i) {
            if (byArray[i] != by) continue;
            int n4 = n2;
            int n5 = i;
            int n6 = 0;
            while (n4-- > 0) {
                if (byArray[n5++] == byArray2[n6++]) continue;
                continue block0;
            }
            return i + 1;
        }
        return -1L;
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        throw Util.notSupported;
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        throw Util.notSupported;
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        throw Util.notSupported;
    }

    public void truncate(long l) throws SQLException {
        byte[] byArray = this.data;
        if (l < 0L || l > (long)byArray.length) {
            throw Util.sqlException(62, Long.toString(l));
        }
        if (l == (long)byArray.length) {
            return;
        }
        byte[] byArray2 = new byte[(int)l];
        System.arraycopy(byArray, 0, byArray2, 0, (int)l);
        this.data = byArray2;
    }
}

