/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message;

import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import net.sf.cindy.util.CharsetUtils;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnProtocol;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.message.MsnMimeMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.outgoing.OutgoingMSG;
import net.sf.jml.util.Charset;
import net.sf.jml.util.GUID;
import net.sf.jml.util.StringHolder;
import net.sf.jml.util.StringUtils;

public class MsnInstantMessage
extends MsnMimeMessage {
    private static final String KEY_FORMAT = "X-MMS-IM-Format";
    private static final String KEY_DISPLAY_NAME = "P4-Context";
    private static final String KEY_MESSAGE_ID = "Message-ID";
    private static final String KEY_CHUNKS = "Chunks";
    private static final String KEY_CHUNK = "Chunk";
    private static final int DEF_SPLIT_SIZE = 1400;
    private String content;
    private String fontName;
    private int fontRGBColor;
    private boolean bold;
    private boolean italic;
    private boolean underline;
    private boolean strikethrough;
    private boolean rightAlign;

    public MsnInstantMessage() {
        this.setContentType("text/plain; charset=UTF-8");
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bl) {
        this.bold = bl;
    }

    public int getFontRGBColor() {
        return this.fontRGBColor;
    }

    public void setFontRGBColor(int n) {
        this.fontRGBColor = n;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean bl) {
        this.italic = bl;
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public void setStrikethrough(boolean bl) {
        this.strikethrough = bl;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean bl) {
        this.underline = bl;
    }

    public boolean isRightAlign() {
        return this.rightAlign;
    }

    public void setRightAlign(boolean bl) {
        this.rightAlign = bl;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void setDisplayName(String string) {
        this.headers.setProperty(KEY_DISPLAY_NAME, string);
    }

    public String getDisplayName() {
        return this.headers.getProperty(KEY_DISPLAY_NAME);
    }

    private String getEffects() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bold) {
            stringBuffer.append("B");
        }
        if (this.italic) {
            stringBuffer.append("I");
        }
        if (this.strikethrough) {
            stringBuffer.append("S");
        }
        if (this.underline) {
            stringBuffer.append("U");
        }
        return stringBuffer.toString();
    }

    private void setEffects(String string) {
        this.setBold(string.indexOf(66) >= 0);
        this.setItalic(string.indexOf(73) >= 0);
        this.setUnderline(string.indexOf(85) >= 0);
        this.setStrikethrough(string.indexOf(83) >= 0);
    }

    private String getFontColor() {
        int n = this.fontRGBColor >> 16 & 0xFF;
        int n2 = this.fontRGBColor >> 8 & 0xFF;
        int n3 = this.fontRGBColor & 0xFF;
        int n4 = n3 << 16 | n2 << 8 | n;
        return Integer.toHexString(n4);
    }

    private void setFontColor(String string) {
        int n = Integer.parseInt(string, 16);
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        this.setFontRGBColor(n4 << 16 | n3 << 8 | n2);
    }

    private void setFormat() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FN=").append(StringUtils.urlEncode(this.fontName == null ? "" : this.fontName)).append(";");
        stringBuffer.append("EF=").append(this.getEffects()).append(";");
        stringBuffer.append("CO=").append(this.getFontColor()).append(";");
        stringBuffer.append("RL=").append(this.rightAlign ? 1 : 0);
        this.headers.setProperty(KEY_FORMAT, stringBuffer.toString());
    }

    private void getFormat() {
        String string = this.headers.getProperty(KEY_FORMAT);
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.startsWith("FN=")) {
                this.setFontName(StringUtils.urlDecode(string2.substring(3)));
                continue;
            }
            if (string2.startsWith("EF=")) {
                this.setEffects(string2.substring(3));
                continue;
            }
            if (string2.startsWith("CO=")) {
                this.setFontColor(string2.substring(3));
                continue;
            }
            if (!string2.startsWith("RL=")) continue;
            this.setRightAlign(string2.substring(3).equals("1"));
        }
    }

    protected void parseBuffer(ByteBuffer byteBuffer) {
        super.parseBuffer(byteBuffer);
        this.content = CharsetUtils.decode((String)this.getCharset(), (ByteBuffer)byteBuffer).toString();
    }

    protected void parseMessage(byte[] byArray) {
        super.parseMessage(byArray);
        this.getFormat();
    }

    public OutgoingMSG[] toOutgoingMsg(MsnProtocol msnProtocol) {
        this.setFormat();
        this.setContentType("text/plain; charset=UTF-8");
        ByteBuffer[] byteBufferArray = Charset.encode(this.content, 1400);
        OutgoingMSG[] outgoingMSGArray = new OutgoingMSG[byteBufferArray.length];
        String string = "{" + GUID.createRandomGuid() + "}";
        for (int i = 0; i < outgoingMSGArray.length; ++i) {
            outgoingMSGArray[i] = new OutgoingMSG(msnProtocol);
            outgoingMSGArray[i].setMsgType(OutgoingMSG.TYPE_ACKNOWLEDGE_WHEN_ERROR);
            StringHolder stringHolder = null;
            if (byteBufferArray.length == 1) {
                stringHolder = this.headers;
            } else {
                stringHolder = (StringHolder)this.headers.clone();
                stringHolder.setProperty(KEY_MESSAGE_ID, string);
                if (i == 0) {
                    stringHolder.setProperty(KEY_CHUNKS, byteBufferArray.length);
                } else {
                    stringHolder.setProperty(KEY_CHUNK, i);
                }
            }
            ByteBuffer byteBuffer = Charset.encode(stringHolder.toString() + "\r\n");
            byte[] byArray = new byte[byteBufferArray[i].remaining() + byteBuffer.remaining()];
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
            byteBuffer2.put(byteBuffer);
            byteBuffer2.put(byteBufferArray[i]);
            outgoingMSGArray[i].setMsg(byArray);
        }
        return outgoingMSGArray;
    }

    protected void messageReceived(MsnSession msnSession, MsnContact msnContact) {
        super.messageReceived(msnSession, msnContact);
        ((AbstractMessenger)msnSession.getMessenger()).fireInstantMessageReceived(msnSession.getSwitchboard(), this, msnContact);
    }
}

