/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.kano.joscar.EncodedStringInfo;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MinimalEncoder {
    public static final String ENCODING_ASCII = "us-ascii";
    public static final String ENCODING_ISO = "iso-8859-1";
    public static final String ENCODING_UTF16 = "utf-16be";
    public static final String ENCODING_UTF8 = "utf-8";
    private static final Charset ASCII7;
    private static final Charset ISO88591;
    private static final Charset UTF16;
    private static final List<String> validCharsets;
    private String charset = validCharsets.get(0);
    private String lastCharset = null;
    private CharsetEncoder lastEncoder = null;

    public static EncodedStringInfo encodeMinimally(String str) {
        return new MinimalEncoder().encode(str);
    }

    @Nullable
    private static String getCharset(String str, Charset charset, String name) {
        if (charset != null && charset.newEncoder().canEncode(str)) {
            return name;
        }
        return null;
    }

    private static String getMinimalCharset(String str) {
        String encoder = MinimalEncoder.getCharset(str, ASCII7, ENCODING_ASCII);
        if (encoder != null) {
            return encoder;
        }
        encoder = MinimalEncoder.getCharset(str, ISO88591, ENCODING_ISO);
        if (encoder != null) {
            return encoder;
        }
        encoder = ENCODING_UTF16;
        return encoder;
    }

    public final synchronized void update(String str) {
        String encoderType = MinimalEncoder.getMinimalCharset(str);
        if (validCharsets.indexOf(encoderType) > validCharsets.indexOf(this.charset)) {
            this.charset = encoderType;
        }
    }

    public final synchronized void updateAll(Collection<String> strings) {
        for (String string : strings) {
            this.update(string);
        }
    }

    public final synchronized String getCharset() {
        return this.charset;
    }

    public final synchronized EncodedStringInfo encode(String str) {
        CharsetEncoder encoder;
        this.update(str);
        if (this.lastCharset == this.charset && this.lastEncoder != null) {
            encoder = this.lastEncoder;
        } else {
            encoder = this.charset == ENCODING_ASCII ? ASCII7.newEncoder() : (this.charset == ENCODING_ISO ? ISO88591.newEncoder() : UTF16.newEncoder());
            this.lastCharset = this.charset;
            this.lastEncoder = encoder;
        }
        try {
            return new EncodedStringInfo(this.charset, encoder.encode(CharBuffer.wrap(str)).array());
        }
        catch (CharacterCodingException uhoh) {
            try {
                return new EncodedStringInfo(ENCODING_UTF8, str.getBytes(ENCODING_UTF8));
            }
            catch (UnsupportedEncodingException impossibler) {
                return null;
            }
        }
    }

    public String toString() {
        return "MinimalEncoder: mincharset=" + this.charset;
    }

    static {
        validCharsets = Collections.unmodifiableList(Arrays.asList(ENCODING_ASCII, ENCODING_ISO, ENCODING_UTF16, ENCODING_UTF8));
        Charset ascii = null;
        try {
            ascii = Charset.forName("US-ASCII");
        }
        catch (UnsupportedCharsetException ohwell) {
            // empty catch block
        }
        ASCII7 = ascii;
        Charset iso = null;
        try {
            iso = Charset.forName("ISO-8859-1");
        }
        catch (UnsupportedCharsetException ohwell) {
            // empty catch block
        }
        ISO88591 = iso;
        Charset utf = null;
        try {
            utf = Charset.forName("UTF-16BE");
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        UTF16 = utf;
    }
}

