/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hsqldb.util.Traceable;
import org.hsqldb.util.TransferDb;
import org.hsqldb.util.TransferHelper;
import org.hsqldb.util.TransferTable;

class OracleTransferHelper
extends TransferHelper {
    private final int ORACLE = 0;
    private final int HSQLDB = 1;
    String[][] Funcs = new String[][]{{"now()", "'now'"}};

    OracleTransferHelper() {
        System.out.println("simple init of OracleTransferHelper");
    }

    OracleTransferHelper(TransferDb transferDb, Traceable traceable, String string) {
        super(transferDb, traceable, string);
    }

    void set(TransferDb transferDb, Traceable traceable, String string) {
        super.set(transferDb, traceable, string);
        String string2 = "ALTER SESSION SET NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'";
        System.out.println("dateFormatStmnt: " + string2);
        try {
            this.tracer.trace("Executing " + string2);
            transferDb.execute(string2);
        }
        catch (Exception exception) {
            this.tracer.trace("Ignoring error " + exception.getMessage());
            System.out.println("Ignoring error " + exception.getMessage());
        }
    }

    String fixupColumnDefRead(TransferTable transferTable, ResultSetMetaData resultSetMetaData, String string, ResultSet resultSet, int n) throws SQLException {
        return this.fixupColumnDefRead(transferTable.Stmts.sDestTable, resultSetMetaData, string, resultSet, n);
    }

    String fixupColumnDefWrite(TransferTable transferTable, ResultSetMetaData resultSetMetaData, String string, ResultSet resultSet, int n) throws SQLException {
        if (string.equals("SERIAL")) {
            String string2 = new String("_" + resultSet.getString(4) + "_seq");
            int n2 = 31 - string2.length();
            string2 = transferTable.Stmts.sDestTable.length() > n2 ? transferTable.Stmts.sDestTable.substring(0, n2) + string2 : transferTable.Stmts.sDestTable + string2;
            String string3 = "DROP SEQUENCE " + string2 + ";";
            transferTable.Stmts.sDestDrop = transferTable.Stmts.sDestDrop + string3;
        }
        for (int i = 0; i < this.Funcs.length; ++i) {
            String string4 = this.Funcs[i][1];
            int n3 = string.indexOf(string4);
            if (n3 < 0) continue;
            String string5 = string.substring(0, n3);
            string5 = string5 + this.Funcs[i][0];
            string = string5 = string5 + string.substring(n3 + string4.length());
        }
        return string;
    }

    void beginDataTransfer() {
        try {
            this.db.setAutoCommit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void endDataTransfer() {
        try {
            this.db.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String fixupColumnDefRead(String string, ResultSetMetaData resultSetMetaData, String string2, ResultSet resultSet, int n) throws SQLException {
        String string3 = new String("_" + resultSet.getString(4) + "_seq");
        int n2 = 31 - string3.length();
        string3 = string.length() > n2 ? string.substring(0, n2) + string3 : string + string3;
        String string4 = "nextval('\"" + string3 + "\"'";
        if (string2.indexOf(string4) >= 0) {
            string2 = "SERIAL";
        }
        for (int i = 0; i < this.Funcs.length; ++i) {
            String string5 = this.Funcs[i][0];
            int n3 = string2.indexOf(string5);
            if (n3 < 0) continue;
            String string6 = string2.substring(0, n3);
            string6 = string6 + this.Funcs[i][1];
            string2 = string6 = string6 + string2.substring(n3 + string5.length());
        }
        return string2;
    }
}

