/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.bzip2;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.bzip2.BZip2Constants;
import org.apache.tools.bzip2.CRC;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CBZip2InputStream
extends InputStream
implements BZip2Constants {
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private int last;
    private int origPtr;
    private int blockSize100k;
    private boolean blockRandomised;
    private int bsBuff;
    private int bsLive;
    private CRC mCrc;
    private boolean[] inUse;
    private int nInUse;
    private char[] seqToUnseq;
    private char[] unseqToSeq;
    private char[] selector;
    private char[] selectorMtf;
    private int[] tt;
    private char[] ll8;
    private int[] unzftab;
    private int[][] limit;
    private int[][] base;
    private int[][] perm;
    private int[] minLens;
    private InputStream bsStream;
    private boolean streamEnd;
    private int currentChar;
    private int currentState;
    private int storedBlockCRC;
    private int storedCombinedCRC;
    private int computedBlockCRC;
    private int computedCombinedCRC;
    int i2;
    int count;
    int chPrev;
    int ch2;
    int i;
    int tPos;
    int rNToGo;
    int rTPos;
    int j2;
    char z;

    private static final void cadvise() {
        System.out.println("CRC Error");
    }

    private static final void badBGLengths() {
        CBZip2InputStream.cadvise();
    }

    private static final void bitStreamEOF() {
        CBZip2InputStream.cadvise();
    }

    private static final void compressedStreamEOF() {
        CBZip2InputStream.cadvise();
    }

    private final void makeMaps() {
        this.nInUse = 0;
        int n = 0;
        while (n < 256) {
            if (this.inUse[n]) {
                this.seqToUnseq[this.nInUse] = (char)n;
                this.unseqToSeq[n] = (char)this.nInUse;
                ++this.nInUse;
            }
            ++n;
        }
    }

    public int read() {
        if (this.streamEnd) {
            return -1;
        }
        int n = this.currentChar;
        switch (this.currentState) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setupRandPartB();
                break;
            }
            case 4: {
                this.setupRandPartC();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.setupNoRandPartB();
                break;
            }
            case 7: {
                this.setupNoRandPartC();
                break;
            }
        }
        return n;
    }

    private final void initialize() {
        char c = this.bsGetUChar();
        char c2 = this.bsGetUChar();
        if (c != 'h' || c2 < '1' || c2 > '9') {
            this.bsFinishedWithStream();
            this.streamEnd = true;
            return;
        }
        this.setDecompressStructureSizes(c2 - 48);
        this.computedCombinedCRC = 0;
    }

    private final void initBlock() {
        char c = this.bsGetUChar();
        char c2 = this.bsGetUChar();
        char c3 = this.bsGetUChar();
        char c4 = this.bsGetUChar();
        char c5 = this.bsGetUChar();
        char c6 = this.bsGetUChar();
        if (c == '\u0017' && c2 == 'r' && c3 == 'E' && c4 == '8' && c5 == 'P' && c6 == '\u0090') {
            this.complete();
            return;
        }
        if (c != '1' || c2 != 'A' || c3 != 'Y' || c4 != '&' || c5 != 'S' || c6 != 'Y') {
            CBZip2InputStream.badBlockHeader();
            this.streamEnd = true;
            return;
        }
        this.storedBlockCRC = this.bsGetInt32();
        this.blockRandomised = this.bsR(1) == 1;
        this.getAndMoveToFrontDecode();
        this.mCrc.initialiseCRC();
        this.currentState = 1;
    }

    private final void endBlock() {
        this.computedBlockCRC = this.mCrc.getFinalCRC();
        if (this.storedBlockCRC != this.computedBlockCRC) {
            CBZip2InputStream.crcError();
        }
        this.computedCombinedCRC = this.computedCombinedCRC << 1 | this.computedCombinedCRC >>> 31;
        this.computedCombinedCRC ^= this.computedBlockCRC;
    }

    private final void complete() {
        this.storedCombinedCRC = this.bsGetInt32();
        if (this.storedCombinedCRC != this.computedCombinedCRC) {
            CBZip2InputStream.crcError();
        }
        this.bsFinishedWithStream();
        this.streamEnd = true;
    }

    private static final void blockOverrun() {
        CBZip2InputStream.cadvise();
    }

    private static final void badBlockHeader() {
        CBZip2InputStream.cadvise();
    }

    private static final void crcError() {
        CBZip2InputStream.cadvise();
    }

    private final void bsFinishedWithStream() {
        try {
            if (this.bsStream != null && this.bsStream != System.in) {
                this.bsStream.close();
                this.bsStream = null;
            }
        }
        catch (IOException iOException) {}
    }

    private final void bsSetStream(InputStream inputStream) {
        this.bsStream = inputStream;
        this.bsLive = 0;
        this.bsBuff = 0;
    }

    private final int bsR(int n) {
        while (this.bsLive < n) {
            char c = '\u0000';
            try {
                c = (char)this.bsStream.read();
            }
            catch (IOException iOException) {
                CBZip2InputStream.compressedStreamEOF();
            }
            if (c == '\uffffffff') {
                CBZip2InputStream.compressedStreamEOF();
            }
            char c2 = c;
            this.bsBuff = this.bsBuff << 8 | c2 & 0xFF;
            this.bsLive += 8;
        }
        int n2 = this.bsBuff >> this.bsLive - n & (1 << n) - 1;
        this.bsLive -= n;
        return n2;
    }

    private final char bsGetUChar() {
        return (char)this.bsR(8);
    }

    private final int bsGetint() {
        int n = 0;
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        return n;
    }

    private final int bsGetIntVS(int n) {
        return this.bsR(n);
    }

    private final int bsGetInt32() {
        return this.bsGetint();
    }

    private final void hbCreateDecodeTables(int[] nArray, int[] nArray2, int[] nArray3, char[] cArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n;
        while (n5 <= n2) {
            int n6 = 0;
            while (n6 < n3) {
                if (cArray[n6] == n5) {
                    nArray3[n4] = n6;
                    ++n4;
                }
                ++n6;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < 23) {
            nArray2[n5] = 0;
            ++n5;
        }
        n5 = 0;
        while (n5 < n3) {
            int n7 = cArray[n5] + '\u0001';
            nArray2[n7] = nArray2[n7] + 1;
            ++n5;
        }
        n5 = 1;
        while (n5 < 23) {
            int n8 = n5;
            nArray2[n8] = nArray2[n8] + nArray2[n5 - 1];
            ++n5;
        }
        n5 = 0;
        while (n5 < 23) {
            nArray[n5] = 0;
            ++n5;
        }
        int n9 = 0;
        n5 = n;
        while (n5 <= n2) {
            nArray[n5] = (n9 += nArray2[n5 + 1] - nArray2[n5]) - 1;
            n9 <<= 1;
            ++n5;
        }
        n5 = n + 1;
        while (n5 <= n2) {
            nArray2[n5] = (nArray[n5 - 1] + 1 << 1) - nArray2[n5];
            ++n5;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void recvDecodingTables() {
        var1_1 = new char[6][258];
        var10_2 = new boolean[16];
        var2_3 = 0;
        while (var2_3 < 16) {
            var10_2[var2_3] = this.bsR(1) == 1;
            ++var2_3;
        }
        var2_3 = 0;
        while (var2_3 < 256) {
            this.inUse[var2_3] = false;
            ++var2_3;
        }
        var2_3 = 0;
        while (var2_3 < 16) {
            if (var10_2[var2_3]) {
                var3_4 = 0;
                while (var3_4 < 16) {
                    if (this.bsR(1) == 1) {
                        this.inUse[var2_3 * 16 + var3_4] = true;
                    }
                    ++var3_4;
                }
            }
            ++var2_3;
        }
        this.makeMaps();
        var7_5 = this.nInUse + 2;
        var5_6 = this.bsR(3);
        var6_7 = this.bsR(15);
        var2_3 = 0;
        while (var2_3 < var6_7) {
            var3_4 = 0;
            while (this.bsR(1) == 1) {
                ++var3_4;
            }
            this.selectorMtf[var2_3] = (char)var3_4;
            ++var2_3;
        }
        var11_8 = new char[6];
        var13_10 = 0;
        while (var13_10 < var5_6) {
            var11_8[var13_10] = var13_10;
            var13_10 = (char)(var13_10 + 1);
        }
        var2_3 = 0;
        while (var2_3 < var6_7) {
            var13_10 = this.selectorMtf[var2_3];
            var12_11 = var11_8[var13_10];
            while (var13_10 > 0) {
                var11_8[var13_10] = var11_8[var13_10 - 1];
                var13_10 = (char)(var13_10 - 1);
            }
            var11_8[0] = var12_11;
            this.selector[var2_3] = var12_11;
            ++var2_3;
        }
        var4_12 = 0;
        while (var4_12 < var5_6) {
            var11_9 = this.bsR(5);
            var2_3 = 0;
            ** GOTO lbl65
            {
                var11_9 = this.bsR(1) == 0 ? ++var11_9 : --var11_9;
                do {
                    if (this.bsR(1) == 1) continue block10;
                    var1_1[var4_12][var2_3] = (char)var11_9;
                    ++var2_3;
lbl65:
                    // 2 sources

                } while (var2_3 < var7_5);
            }
            ++var4_12;
        }
        var4_12 = 0;
        while (var4_12 < var5_6) {
            var8_13 = 32;
            var9_14 = '\u0000';
            var2_3 = 0;
            while (var2_3 < var7_5) {
                if (var1_1[var4_12][var2_3] > var9_14) {
                    var9_14 = var1_1[var4_12][var2_3];
                }
                if (var1_1[var4_12][var2_3] < var8_13) {
                    var8_13 = var1_1[var4_12][var2_3];
                }
                ++var2_3;
            }
            this.hbCreateDecodeTables(this.limit[var4_12], this.base[var4_12], this.perm[var4_12], var1_1[var4_12], var8_13, var9_14, var7_5);
            this.minLens[var4_12] = var8_13;
            ++var4_12;
        }
    }

    private final void getAndMoveToFrontDecode() {
        int n;
        int n2;
        int n3;
        char[] cArray = new char[256];
        int n4 = 100000 * this.blockSize100k;
        this.origPtr = this.bsGetIntVS(24);
        this.recvDecodingTables();
        int n5 = this.nInUse + 1;
        int n6 = -1;
        int n7 = 0;
        int n8 = 0;
        while (n8 <= 255) {
            this.unzftab[n8] = 0;
            ++n8;
        }
        n8 = 0;
        while (n8 <= 255) {
            cArray[n8] = (char)n8;
            ++n8;
        }
        this.last = -1;
        if (n7 == 0) {
            ++n6;
            n7 = 50;
        }
        --n7;
        char c = this.selector[n6];
        int n9 = this.minLens[c];
        int n10 = this.bsR(n9);
        while (n10 > this.limit[c][n9]) {
            ++n9;
            while (this.bsLive < 1) {
                n3 = 0;
                try {
                    n3 = this.bsStream.read();
                }
                catch (IOException iOException) {
                    CBZip2InputStream.compressedStreamEOF();
                }
                if (n3 == -1) {
                    CBZip2InputStream.compressedStreamEOF();
                }
                n2 = n3;
                this.bsBuff = this.bsBuff << 8 | n2 & 0xFF;
                this.bsLive += 8;
            }
            n = this.bsBuff >> this.bsLive - 1 & 1;
            --this.bsLive;
            n10 = n10 << 1 | n;
        }
        int n11 = this.perm[c][n10 - this.base[c][n9]];
        while (n11 != n5) {
            if (n11 == 0 || n11 == 1) {
                n9 = -1;
                n10 = 1;
                do {
                    if (n11 == 0) {
                        n9 += n10;
                    } else if (n11 == 1) {
                        n9 += 2 * n10;
                    }
                    n10 *= 2;
                    if (n7 == 0) {
                        ++n6;
                        n7 = 50;
                    }
                    --n7;
                    n = this.selector[n6];
                    n2 = this.minLens[n];
                    n3 = this.bsR(n2);
                    while (n3 > this.limit[n][n2]) {
                        ++n2;
                        while (this.bsLive < 1) {
                            char c2 = '\u0000';
                            try {
                                c2 = (char)this.bsStream.read();
                            }
                            catch (IOException iOException) {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            if (c2 == '\uffffffff') {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            char c3 = c2;
                            this.bsBuff = this.bsBuff << 8 | c3 & 0xFF;
                            this.bsLive += 8;
                        }
                        int n12 = this.bsBuff >> this.bsLive - 1 & 1;
                        --this.bsLive;
                        n3 = n3 << 1 | n12;
                    }
                } while ((n11 = this.perm[n][n3 - this.base[n][n2]]) == 0 || n11 == 1);
                char c4 = c = this.seqToUnseq[cArray[0]];
                this.unzftab[c4] = this.unzftab[c4] + ++n9;
                while (n9 > 0) {
                    ++this.last;
                    this.ll8[this.last] = c;
                    --n9;
                }
                if (this.last < n4) continue;
                CBZip2InputStream.blockOverrun();
                continue;
            }
            ++this.last;
            if (this.last >= n4) {
                CBZip2InputStream.blockOverrun();
            }
            c = cArray[n11 - 1];
            char c5 = this.seqToUnseq[c];
            this.unzftab[c5] = this.unzftab[c5] + 1;
            this.ll8[this.last] = this.seqToUnseq[c];
            int n13 = n11 - 1;
            while (n13 > 3) {
                cArray[n13] = cArray[n13 - 1];
                cArray[n13 - 1] = cArray[n13 - 2];
                cArray[n13 - 2] = cArray[n13 - 3];
                cArray[n13 - 3] = cArray[n13 - 4];
                n13 -= 4;
            }
            while (n13 > 0) {
                cArray[n13] = cArray[n13 - 1];
                --n13;
            }
            cArray[0] = c;
            if (n7 == 0) {
                ++n6;
                n7 = 50;
            }
            --n7;
            n9 = this.selector[n6];
            n10 = this.minLens[n9];
            n = this.bsR(n10);
            while (n > this.limit[n9][n10]) {
                ++n10;
                while (this.bsLive < 1) {
                    char c6 = '\u0000';
                    try {
                        c6 = (char)this.bsStream.read();
                    }
                    catch (IOException iOException) {
                        CBZip2InputStream.compressedStreamEOF();
                    }
                    n3 = c6;
                    this.bsBuff = this.bsBuff << 8 | n3 & 0xFF;
                    this.bsLive += 8;
                }
                n2 = this.bsBuff >> this.bsLive - 1 & 1;
                --this.bsLive;
                n = n << 1 | n2;
            }
            n11 = this.perm[n9][n - this.base[n9][n10]];
        }
    }

    private final void setupBlock() {
        int[] nArray = new int[257];
        nArray[0] = 0;
        this.i = 1;
        while (this.i <= 256) {
            nArray[this.i] = this.unzftab[this.i - 1];
            ++this.i;
        }
        this.i = 1;
        while (this.i <= 256) {
            int n = this.i;
            nArray[n] = nArray[n] + nArray[this.i - 1];
            ++this.i;
        }
        this.i = 0;
        while (this.i <= this.last) {
            char c = this.ll8[this.i];
            this.tt[nArray[c]] = this.i++;
            char c2 = c;
            nArray[c2] = nArray[c2] + 1;
        }
        nArray = null;
        this.tPos = this.tt[this.origPtr];
        this.count = 0;
        this.i2 = 0;
        this.ch2 = 256;
        if (this.blockRandomised) {
            this.rNToGo = 0;
            this.rTPos = 0;
            this.setupRandPartA();
        } else {
            this.setupNoRandPartA();
        }
    }

    private final void setupRandPartA() {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.ll8[this.tPos];
            this.tPos = this.tt[this.tPos];
            if (this.rNToGo == 0) {
                this.rNToGo = rNums[this.rTPos];
                ++this.rTPos;
                if (this.rTPos == 512) {
                    this.rTPos = 0;
                }
            }
            --this.rNToGo;
            int n = 0;
            if (this.rNToGo == 1) {
                n = 1;
            }
            this.ch2 ^= n;
            ++this.i2;
            this.currentChar = this.ch2;
            this.currentState = 3;
            this.mCrc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private final void setupNoRandPartA() {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.ll8[this.tPos];
            this.tPos = this.tt[this.tPos];
            ++this.i2;
            this.currentChar = this.ch2;
            this.currentState = 6;
            this.mCrc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private final void setupRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.currentState = 2;
            this.count = 1;
            this.setupRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.ll8[this.tPos];
                this.tPos = this.tt[this.tPos];
                if (this.rNToGo == 0) {
                    this.rNToGo = rNums[this.rTPos];
                    ++this.rTPos;
                    if (this.rTPos == 512) {
                        this.rTPos = 0;
                    }
                }
                --this.rNToGo;
                char c = '\u0000';
                if (this.rNToGo == 1) {
                    c = '\u0001';
                }
                this.z = (char)(this.z ^ c);
                this.j2 = 0;
                this.currentState = 4;
                this.setupRandPartC();
            } else {
                this.currentState = 2;
                this.setupRandPartA();
            }
        }
    }

    private final void setupRandPartC() {
        if (this.j2 < this.z) {
            this.currentChar = this.ch2;
            this.mCrc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.currentState = 2;
            ++this.i2;
            this.count = 0;
            this.setupRandPartA();
        }
    }

    private final void setupNoRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.currentState = 5;
            this.count = 1;
            this.setupNoRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.ll8[this.tPos];
                this.tPos = this.tt[this.tPos];
                this.currentState = 7;
                this.j2 = 0;
                this.setupNoRandPartC();
            } else {
                this.currentState = 5;
                this.setupNoRandPartA();
            }
        }
    }

    private final void setupNoRandPartC() {
        if (this.j2 < this.z) {
            this.currentChar = this.ch2;
            this.mCrc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.currentState = 5;
            ++this.i2;
            this.count = 0;
            this.setupNoRandPartA();
        }
    }

    private final void setDecompressStructureSizes(int n) {
        if (n >= 0 && n <= 9 && this.blockSize100k >= 0) {
        }
        this.blockSize100k = n;
        if (n == 0) {
            return;
        }
        int n2 = 100000 * n;
        this.ll8 = new char[n2];
        this.tt = new int[n2];
    }

    private final /* synthetic */ void this() {
        this.mCrc = new CRC();
        this.inUse = new boolean[256];
        this.seqToUnseq = new char[256];
        this.unseqToSeq = new char[256];
        this.selector = new char[18002];
        this.selectorMtf = new char[18002];
        this.unzftab = new int[256];
        this.limit = new int[6][258];
        this.base = new int[6][258];
        this.perm = new int[6][258];
        this.minLens = new int[6];
        this.streamEnd = false;
        this.currentChar = -1;
        this.currentState = 1;
        this.rNToGo = 0;
        this.rTPos = 0;
    }

    public CBZip2InputStream(InputStream inputStream) {
        this.this();
        this.ll8 = null;
        this.tt = null;
        this.bsSetStream(inputStream);
        this.initialize();
        this.initBlock();
        this.setupBlock();
    }
}

