/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.sf.jqql.KeepAliveTrigger;
import net.sf.jqql.PacketEventTrigger;
import net.sf.jqql.ProcessorRouter;
import net.sf.jqql.QQPort;
import net.sf.jqql.ResendTrigger;
import net.sf.jqql.SingleExecutor;
import net.sf.jqql.Util;
import net.sf.jqql._03FamilyProcessor;
import net.sf.jqql._05FamilyProcessor;
import net.sf.jqql._08BasicFamilyProcessor;
import net.sf.jqql.beans.Card;
import net.sf.jqql.beans.ContactInfo;
import net.sf.jqql.beans.FriendRemark;
import net.sf.jqql.beans.Member;
import net.sf.jqql.beans.QQOrganization;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.beans.Signature;
import net.sf.jqql.events.IQQListener;
import net.sf.jqql.events.PacketEvent;
import net.sf.jqql.events.QQEvent;
import net.sf.jqql.net.ConnectionPolicyFactory;
import net.sf.jqql.net.IConnection;
import net.sf.jqql.net.IConnectionPolicy;
import net.sf.jqql.net.IConnectionPolicyFactory;
import net.sf.jqql.net.IConnectionPool;
import net.sf.jqql.net.IConnectionPoolFactory;
import net.sf.jqql.packets.ErrorPacket;
import net.sf.jqql.packets._08InPacket;
import net.sf.jqql.packets._08OutPacket;
import net.sf.jqql.packets._08Packet;
import net.sf.jqql.packets.in.ReceiveIMPacket;
import net.sf.jqql.packets.out.AddFriendAuthResponsePacket;
import net.sf.jqql.packets.out.AddFriendExPacket;
import net.sf.jqql.packets.out.AdvancedSearchUserPacket;
import net.sf.jqql.packets.out.ChangeStatusPacket;
import net.sf.jqql.packets.out.ClusterActivatePacket;
import net.sf.jqql.packets.out.ClusterActivateTempPacket;
import net.sf.jqql.packets.out.ClusterAuthPacket;
import net.sf.jqql.packets.out.ClusterCommitMemberOrganizationPacket;
import net.sf.jqql.packets.out.ClusterCommitOrganizationPacket;
import net.sf.jqql.packets.out.ClusterCreatePacket;
import net.sf.jqql.packets.out.ClusterCreateTempPacket;
import net.sf.jqql.packets.out.ClusterDismissPacket;
import net.sf.jqql.packets.out.ClusterExitPacket;
import net.sf.jqql.packets.out.ClusterExitTempPacket;
import net.sf.jqql.packets.out.ClusterGetCardBatchPacket;
import net.sf.jqql.packets.out.ClusterGetCardPacket;
import net.sf.jqql.packets.out.ClusterGetInfoPacket;
import net.sf.jqql.packets.out.ClusterGetMemberInfoPacket;
import net.sf.jqql.packets.out.ClusterGetOnlineMemberPacket;
import net.sf.jqql.packets.out.ClusterGetTempInfoPacket;
import net.sf.jqql.packets.out.ClusterJoinPacket;
import net.sf.jqql.packets.out.ClusterModifyCardPacket;
import net.sf.jqql.packets.out.ClusterModifyInfoPacket;
import net.sf.jqql.packets.out.ClusterModifyMemberPacket;
import net.sf.jqql.packets.out.ClusterModifyTempInfoPacket;
import net.sf.jqql.packets.out.ClusterModifyTempMemberPacket;
import net.sf.jqql.packets.out.ClusterSearchPacket;
import net.sf.jqql.packets.out.ClusterSendIMExPacket;
import net.sf.jqql.packets.out.ClusterSendTempIMPacket;
import net.sf.jqql.packets.out.ClusterSetRolePacket;
import net.sf.jqql.packets.out.ClusterSubClusterOpPacket;
import net.sf.jqql.packets.out.ClusterTransferRolePacket;
import net.sf.jqql.packets.out.ClusterUpdateOrganizationPacket;
import net.sf.jqql.packets.out.DeleteFriendPacket;
import net.sf.jqql.packets.out.DownloadGroupFriendPacket;
import net.sf.jqql.packets.out.FriendDataOpPacket;
import net.sf.jqql.packets.out.FriendLevelOpPacket;
import net.sf.jqql.packets.out.GetFriendListPacket;
import net.sf.jqql.packets.out.GetKeyPacket;
import net.sf.jqql.packets.out.GetUserInfoPacket;
import net.sf.jqql.packets.out.GroupDataOpPacket;
import net.sf.jqql.packets.out.LogoutPacket;
import net.sf.jqql.packets.out.PrivacyDataOpPacket;
import net.sf.jqql.packets.out.ReceiveIMReplyPacket;
import net.sf.jqql.packets.out.RemoveSelfPacket;
import net.sf.jqql.packets.out.SearchUserPacket;
import net.sf.jqql.packets.out.SendIMPacket;
import net.sf.jqql.packets.out.SendSMSPacket;
import net.sf.jqql.packets.out.TempSessionOpPacket;
import net.sf.jqql.packets.out.UploadGroupFriendPacket;
import net.sf.jqql.packets.out.UserPropertyOpPacket;
import net.sf.jqql.packets.out.WeatherOpPacket;
import net.sf.jqql.packets.out._03.GetCustomHeadDataPacket;
import net.sf.jqql.packets.out._03.GetCustomHeadInfoPacket;
import net.sf.jqql.packets.out._05.RequestAgentPacket;
import net.sf.jqql.packets.out._05.RequestBeginPacket;
import net.sf.jqql.packets.out._05.RequestFacePacket;
import net.sf.jqql.packets.out._05.TransferPacket;
import net.sf.jqql.packets.out._08._08AuthInfoOpPacket;
import net.sf.jqql.packets.out._08._08AuthorizePacket;
import net.sf.jqql.packets.out._08._08GetOnlineOpPacket;
import net.sf.jqql.packets.out._08._08KeepAlivePacket;
import net.sf.jqql.packets.out._08._08LoginKeyPacket;
import net.sf.jqql.packets.out._08._08LoginPacket;
import net.sf.jqql.packets.out._08._08LoginToken1Packet;
import net.sf.jqql.packets.out._08._08LoginToken2Packet;
import net.sf.jqql.packets.out._08._08ModifyInfoPacket;
import net.sf.jqql.packets.out._08._08SignatureOpPacket;
import net.sf.jqql.packets.out._08._08TouchLoginPacket;
import net.sf.jqql.robot.IRobot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QQClient
implements IQQListener {
    protected static final SingleExecutor executor = new SingleExecutor();
    protected static final int PROCESSOR_COUNT = 4;
    private String loginServer;
    private int tcpLoginPort;
    private ProcessorRouter router;
    private LinkedList<IQQListener> qqListeners = new LinkedList();
    private LinkedList<IQQListener> qqListenersBackup = new LinkedList();
    private QQUser user;
    private boolean logging = false;
    private boolean loginRedirect = false;
    private IConnectionPool pool;
    private IConnectionPoolFactory poolFactory;
    private IConnectionPolicyFactory policyFactory;
    private int proxyType;
    private InetSocketAddress proxyAddress;
    private String proxyUsername;
    private String proxyPassword;
    private boolean robotMode = false;
    private IRobot robot;
    private boolean listenerChanged = false;
    protected Callable<Object> packetEventTrigger;
    protected ResendTrigger<Object> resendTrigger;
    protected Runnable keepAliveTrigger;
    protected ScheduledFuture<Object> keepAliveFuture;
    protected Queue<_08InPacket> receiveQueue = new LinkedList<_08InPacket>();
    protected Map<_08InPacket, String> inConn;
    private boolean isUserInfoChanged = false;
    private boolean isAddUser = false;
    private boolean isAddAdvancedUser = false;
    private boolean isJoinCluster = false;
    private int qqNum = 0;
    private int clusterId = 0;
    private String authMsg = "";
    private boolean isModifySig;
    private boolean isDelFriend;
    private boolean tempSession;
    private String tempSessionMsg;

    public String getTempSessionMsg() {
        return this.tempSessionMsg;
    }

    public void setTempSessionMsg(String string) {
        this.tempSessionMsg = string;
    }

    public boolean isTempSession() {
        return this.tempSession;
    }

    public void setTempSession(boolean bl) {
        this.tempSession = bl;
    }

    public QQClient() {
        this.qqListeners.add(this);
        this.qqListenersBackup.add(this);
        this.packetEventTrigger = new PacketEventTrigger<Object>(this);
        this.keepAliveTrigger = new KeepAliveTrigger(this);
        this.resendTrigger = new ResendTrigger(this);
        this.inConn = new HashMap<_08InPacket, String>();
        this.policyFactory = new ConnectionPolicyFactory();
        this.router = new ProcessorRouter(this, 4);
        this.router.installProcessor(new _08BasicFamilyProcessor(this));
        this.router.installProcessor(new _05FamilyProcessor(this));
        this.router.installProcessor(new _03FamilyProcessor(this));
        executor.increaseClient();
    }

    public synchronized void addIncomingPacket(_08InPacket _08InPacket2, String string) {
        if (_08InPacket2 == null) {
            return;
        }
        this.receiveQueue.offer(_08InPacket2);
        this.inConn.put(_08InPacket2, string);
        executor.submit(this.packetEventTrigger);
    }

    public synchronized void addQQListener(IQQListener iQQListener) {
        if (!this.qqListeners.contains(iQQListener)) {
            this.qqListeners.add(iQQListener);
            this.setListenerChanged(true);
        }
    }

    public void addResendPacket(_08OutPacket _08OutPacket2, String string) {
        this.resendTrigger.add(_08OutPacket2, string);
    }

    private synchronized void checkListenerChange() {
        if (this.isListenerChanged()) {
            this.qqListenersBackup.clear();
            this.qqListenersBackup.addAll(this.qqListeners);
            this.setListenerChanged(false);
        }
    }

    public void cluster_AactivateTemp(byte by, int n, int n2) {
        if (this.user.isLoggedIn()) {
            ClusterActivateTempPacket clusterActivateTempPacket = new ClusterActivateTempPacket(this.user);
            clusterActivateTempPacket.setClusterId(n);
            clusterActivateTempPacket.setType(by);
            clusterActivateTempPacket.setParentClusterId(n2);
            this.pool.send(QQPort.MAIN.name, clusterActivateTempPacket, true);
        }
    }

    public void cluster_Activate(int n) {
        if (this.user.isLoggedIn()) {
            ClusterActivatePacket clusterActivatePacket = new ClusterActivatePacket(this.user);
            clusterActivatePacket.setClusterId(n);
            this.pool.send(QQPort.MAIN.name, clusterActivatePacket, true);
        }
    }

    public void cluster_ApproveJoin(int n, int n2) {
        if (this.user.isLoggedIn()) {
            ClusterAuthPacket clusterAuthPacket = new ClusterAuthPacket(this.user);
            clusterAuthPacket.setType(2);
            clusterAuthPacket.setClusterId(n);
            clusterAuthPacket.setReceiver(n2);
            this.pool.send(QQPort.MAIN.name, clusterAuthPacket, true);
        }
    }

    public char cluster_CommitMemberOrganization(int n, List<Member> list) {
        if (this.user.isLoggedIn()) {
            ClusterCommitMemberOrganizationPacket clusterCommitMemberOrganizationPacket = new ClusterCommitMemberOrganizationPacket(this.user);
            clusterCommitMemberOrganizationPacket.setClusterId(n);
            clusterCommitMemberOrganizationPacket.setMembers(list);
            this.pool.send(QQPort.MAIN.name, clusterCommitMemberOrganizationPacket, true);
            return clusterCommitMemberOrganizationPacket.getSequence();
        }
        return '\u0000';
    }

    public char cluster_CommitOrganization(int n, List<QQOrganization> list) {
        if (this.user.isLoggedIn()) {
            ClusterCommitOrganizationPacket clusterCommitOrganizationPacket = new ClusterCommitOrganizationPacket(this.user);
            clusterCommitOrganizationPacket.setClusterId(n);
            clusterCommitOrganizationPacket.setOrganizations(list);
            this.pool.send(QQPort.MAIN.name, clusterCommitOrganizationPacket, true);
            return clusterCommitOrganizationPacket.getSequence();
        }
        return '\u0000';
    }

    public void cluster_CreatePermanent(String string, String string2, String string3, List<Integer> list, int n, byte by) {
        if (this.user.isLoggedIn()) {
            ClusterCreatePacket clusterCreatePacket = new ClusterCreatePacket(this.user);
            clusterCreatePacket.setType((byte)1);
            clusterCreatePacket.setAuthType(by);
            clusterCreatePacket.setCategory(n);
            clusterCreatePacket.setName(string);
            clusterCreatePacket.setNotice(string2);
            clusterCreatePacket.setDescription(string3);
            clusterCreatePacket.setMembers(list);
            this.pool.send(QQPort.MAIN.name, clusterCreatePacket, true);
        }
    }

    public char cluster_CreateTemporary(String string, byte by, int n, List<Integer> list) {
        if (this.user.isLoggedIn()) {
            ClusterCreateTempPacket clusterCreateTempPacket = new ClusterCreateTempPacket(this.user);
            clusterCreateTempPacket.setType(by);
            clusterCreateTempPacket.setName(string);
            clusterCreateTempPacket.setMembers(list);
            clusterCreateTempPacket.setParentClusterId(n);
            this.pool.send(QQPort.MAIN.name, clusterCreateTempPacket, true);
            return clusterCreateTempPacket.getSequence();
        }
        return '\u0000';
    }

    public void cluster_Dismiss(int n) {
        if (this.user.isLoggedIn()) {
            ClusterDismissPacket clusterDismissPacket = new ClusterDismissPacket(this.user);
            clusterDismissPacket.setClusterId(n);
            this.pool.send(QQPort.MAIN.name, clusterDismissPacket, false);
        }
    }

    public void cluster_Exit(int n) {
        if (this.user.isLoggedIn()) {
            ClusterExitPacket clusterExitPacket = new ClusterExitPacket(this.user);
            clusterExitPacket.setClusterId(n);
            this.pool.send(QQPort.MAIN.name, clusterExitPacket, true);
        }
    }

    public void cluster_GetCard(int n, int n2) {
        if (this.user.isLoggedIn()) {
            ClusterGetCardPacket clusterGetCardPacket = new ClusterGetCardPacket(this.user);
            clusterGetCardPacket.setClusterId(n);
            clusterGetCardPacket.setQQ(n2);
            this.pool.send(QQPort.MAIN.name, clusterGetCardPacket, true);
        }
    }

    public void cluster_GetCardBatch(int n, int n2) {
        if (this.user.isLoggedIn()) {
            ClusterGetCardBatchPacket clusterGetCardBatchPacket = new ClusterGetCardBatchPacket(this.user);
            clusterGetCardBatchPacket.setClusterId(n);
            clusterGetCardBatchPacket.setStart(n2);
            this.pool.send(QQPort.MAIN.name, clusterGetCardBatchPacket, true);
        }
    }

    public void cluster_getDialogList() {
        if (this.user.isLoggedIn()) {
            ClusterSubClusterOpPacket clusterSubClusterOpPacket = new ClusterSubClusterOpPacket(this.user);
            clusterSubClusterOpPacket.setOpByte((byte)1);
            this.pool.send(QQPort.MAIN.name, clusterSubClusterOpPacket, false);
        }
    }

    public void cluster_GetInfo(int n) {
        if (this.user.isLoggedIn()) {
            ClusterGetInfoPacket clusterGetInfoPacket = new ClusterGetInfoPacket(this.user);
            clusterGetInfoPacket.setClusterId(n);
            this.pool.send(QQPort.MAIN.name, clusterGetInfoPacket, true);
        }
    }

    public void cluster_GetMemberInfo(int n, List<?> list) {
        if (this.user.isLoggedIn()) {
            int n2 = list.size();
            int n3 = (n2 + 29) / 30;
            for (int i = 0; i < n3; ++i) {
                ClusterGetMemberInfoPacket clusterGetMemberInfoPacket = new ClusterGetMemberInfoPacket(this.user);
                clusterGetMemberInfoPacket.setClusterId(n);
                for (int j = 30 * i; j < 30 * i + 30 && j < n2; ++j) {
                    Object obj = list.get(j);
                    if (obj instanceof Integer) {
                        clusterGetMemberInfoPacket.addMember((Integer)obj);
                        continue;
                    }
                    if (!(obj instanceof Member)) continue;
                    clusterGetMemberInfoPacket.addMember(((Member)obj).qq);
                }
                this.pool.send(QQPort.MAIN.name, clusterGetMemberInfoPacket, true);
            }
        }
    }

    public void cluster_GetOnlineMember(int n) {
        if (this.user.isLoggedIn()) {
            ClusterGetOnlineMemberPacket clusterGetOnlineMemberPacket = new ClusterGetOnlineMemberPacket(this.user);
            clusterGetOnlineMemberPacket.setClusterId(n);
            this.pool.send(QQPort.MAIN.name, clusterGetOnlineMemberPacket, true);
        }
    }

    public void cluster_getSubjectList(int n) {
        if (this.user.isLoggedIn()) {
            ClusterSubClusterOpPacket clusterSubClusterOpPacket = new ClusterSubClusterOpPacket(this.user);
            clusterSubClusterOpPacket.setOpByte((byte)2);
            clusterSubClusterOpPacket.setClusterId(n);
            this.pool.send(QQPort.MAIN.name, clusterSubClusterOpPacket, false);
        }
    }

    public void cluster_GetTempInfo(byte by, int n, int n2) {
        if (this.user.isLoggedIn()) {
            ClusterGetTempInfoPacket clusterGetTempInfoPacket = new ClusterGetTempInfoPacket(this.user);
            clusterGetTempInfoPacket.setType(by);
            clusterGetTempInfoPacket.setClusterId(n);
            clusterGetTempInfoPacket.setParentClusterId(n2);
            this.pool.send(QQPort.MAIN.name, clusterGetTempInfoPacket, true);
        }
    }

    public char cluster_Join(int n) {
        if (this.user.isLoggedIn()) {
            ClusterJoinPacket clusterJoinPacket = new ClusterJoinPacket(this.user);
            clusterJoinPacket.setClusterId(n);
            this.pool.send(QQPort.MAIN.name, clusterJoinPacket, true);
            return clusterJoinPacket.getSequence();
        }
        return '\u0000';
    }

    public void cluster_ModifyCard(int n, Card card) {
        if (this.user.isLoggedIn()) {
            ClusterModifyCardPacket clusterModifyCardPacket = new ClusterModifyCardPacket(this.user);
            clusterModifyCardPacket.setClusterId(n);
            clusterModifyCardPacket.setCard(card);
            this.pool.send(QQPort.MAIN.name, clusterModifyCardPacket, true);
        }
    }

    public char cluster_ModifyInfo(int n, String string, String string2, String string3, int n2, int n3, byte by) {
        if (this.user.isLoggedIn()) {
            ClusterModifyInfoPacket clusterModifyInfoPacket = new ClusterModifyInfoPacket(this.user);
            clusterModifyInfoPacket.setClusterId(n);
            clusterModifyInfoPacket.setName(string);
            clusterModifyInfoPacket.setNotice(string2);
            clusterModifyInfoPacket.setDescription(string3);
            clusterModifyInfoPacket.setOldCategory(n2);
            clusterModifyInfoPacket.setCategory(n3);
            clusterModifyInfoPacket.setAuthType(by);
            this.pool.send(QQPort.MAIN.name, clusterModifyInfoPacket, true);
            return clusterModifyInfoPacket.getSequence();
        }
        return '\u0000';
    }

    public char cluster_ModifyMember(int n, byte by, List<Integer> list) {
        if (this.user.isLoggedIn()) {
            ClusterModifyMemberPacket clusterModifyMemberPacket = new ClusterModifyMemberPacket(this.user);
            clusterModifyMemberPacket.setClusterId(n);
            clusterModifyMemberPacket.setOperation(by);
            clusterModifyMemberPacket.setMembers(list);
            this.pool.send(QQPort.MAIN.name, clusterModifyMemberPacket, true);
            return clusterModifyMemberPacket.getSequence();
        }
        return '\u0000';
    }

    public char cluster_ModifyTempInfo(byte by, int n, int n2, String string) {
        if (this.user.isLoggedIn()) {
            ClusterModifyTempInfoPacket clusterModifyTempInfoPacket = new ClusterModifyTempInfoPacket(this.user);
            clusterModifyTempInfoPacket.setType(by);
            clusterModifyTempInfoPacket.setClusterId(n);
            clusterModifyTempInfoPacket.setParentClusterId(n2);
            clusterModifyTempInfoPacket.setName(string);
            this.pool.send(QQPort.MAIN.name, clusterModifyTempInfoPacket, true);
            return clusterModifyTempInfoPacket.getSequence();
        }
        return '\u0000';
    }

    public char cluster_ModifyTempMember(byte by, int n, int n2, byte by2, List<Integer> list) {
        if (this.user.isLoggedIn()) {
            ClusterModifyTempMemberPacket clusterModifyTempMemberPacket = new ClusterModifyTempMemberPacket(this.user);
            clusterModifyTempMemberPacket.setType(by);
            clusterModifyTempMemberPacket.setClusterId(n);
            clusterModifyTempMemberPacket.setParentClusterId(n2);
            clusterModifyTempMemberPacket.setMembers(list);
            clusterModifyTempMemberPacket.setOperation(by2);
            this.pool.send(QQPort.MAIN.name, clusterModifyTempMemberPacket, true);
            return clusterModifyTempMemberPacket.getSequence();
        }
        return '\u0000';
    }

    public void cluster_RejectJoin(int n, int n2, String string) {
        if (this.user.isLoggedIn()) {
            ClusterAuthPacket clusterAuthPacket = new ClusterAuthPacket(this.user);
            clusterAuthPacket.setType(3);
            clusterAuthPacket.setClusterId(n);
            clusterAuthPacket.setReceiver(n2);
            clusterAuthPacket.setMessage(string);
            this.pool.send(QQPort.MAIN.name, clusterAuthPacket, true);
        }
    }

    public char cluster_AuthInfo(int n) {
        if (this.user.isLoggedIn()) {
            _08AuthInfoOpPacket _08AuthInfoOpPacket2 = new _08AuthInfoOpPacket(this.user);
            _08AuthInfoOpPacket2.setSubCommand((byte)1);
            _08AuthInfoOpPacket2.setSubSubCommand('\u0002');
            _08AuthInfoOpPacket2.setFriendQQ(n);
            this.pool.send(QQPort.MAIN.name, _08AuthInfoOpPacket2, true);
            return _08AuthInfoOpPacket2.getSequence();
        }
        return '\u0000';
    }

    public char cluster_RequestJoin(int n, String string) {
        if (this.user.isLoggedIn()) {
            ClusterAuthPacket clusterAuthPacket = new ClusterAuthPacket(this.user);
            clusterAuthPacket.setType(1);
            clusterAuthPacket.setClusterId(n);
            clusterAuthPacket.setMessage(string);
            this.pool.send(QQPort.MAIN.name, clusterAuthPacket, true);
            return clusterAuthPacket.getSequence();
        }
        return '\u0000';
    }

    public char cluster_SearchById(int n) {
        if (this.user.isLoggedIn()) {
            ClusterSearchPacket clusterSearchPacket = new ClusterSearchPacket(this.user);
            clusterSearchPacket.setExternalId(n);
            clusterSearchPacket.setSearchType((byte)1);
            this.pool.send(QQPort.MAIN.name, clusterSearchPacket, true);
            return clusterSearchPacket.getSequence();
        }
        return '\u0000';
    }

    public char cluster_SearchDemo() {
        if (this.user.isLoggedIn()) {
            ClusterSearchPacket clusterSearchPacket = new ClusterSearchPacket(this.user);
            clusterSearchPacket.setSearchType((byte)2);
            this.pool.send(QQPort.MAIN.name, clusterSearchPacket, true);
            return clusterSearchPacket.getSequence();
        }
        return '\u0000';
    }

    public void cluster_SearchTemp(byte by, int n, int n2) {
        if (this.user.isLoggedIn()) {
            ClusterExitTempPacket clusterExitTempPacket = new ClusterExitTempPacket(this.user);
            clusterExitTempPacket.setType(by);
            clusterExitTempPacket.setParentClusterId(n2);
            clusterExitTempPacket.setClusterId(n);
            this.pool.send(QQPort.MAIN.name, clusterExitTempPacket, true);
        }
    }

    public void cluster_SetMemberRole(int n, int n2, byte by) {
        if (this.user.isLoggedIn()) {
            ClusterSetRolePacket clusterSetRolePacket = new ClusterSetRolePacket(this.user);
            clusterSetRolePacket.setClusterId(n);
            clusterSetRolePacket.setQq(n2);
            clusterSetRolePacket.setOpCode(by);
            this.pool.send(QQPort.MAIN.name, clusterSetRolePacket, false);
        }
    }

    public void cluster_TransferRole(int n, int n2) {
        if (this.user.isLoggedIn()) {
            ClusterTransferRolePacket clusterTransferRolePacket = new ClusterTransferRolePacket(this.user);
            clusterTransferRolePacket.setClusterId(n);
            clusterTransferRolePacket.setQq(n2);
            this.pool.send(QQPort.MAIN.name, clusterTransferRolePacket, false);
        }
    }

    public void cluster_UpdateOrganization(int n) {
        if (this.user.isLoggedIn()) {
            ClusterUpdateOrganizationPacket clusterUpdateOrganizationPacket = new ClusterUpdateOrganizationPacket(this.user);
            clusterUpdateOrganizationPacket.setClusterId(n);
            this.pool.send(QQPort.MAIN.name, clusterUpdateOrganizationPacket, true);
        }
    }

    public void common_RequestKey(byte by) {
        if (this.pool != null && this.user.isLoggedIn() && this.pool.hasConnection(QQPort.MAIN.name)) {
            GetKeyPacket getKeyPacket = new GetKeyPacket(this.user);
            getKeyPacket.setRequest(by);
            this.pool.send(QQPort.MAIN.name, getKeyPacket, true);
        }
    }

    public void customHead_GetData(int n, int n2, int n3, int n4, String string) {
        if (this.user.isLoggedIn()) {
            GetCustomHeadDataPacket getCustomHeadDataPacket = new GetCustomHeadDataPacket(this.user);
            getCustomHeadDataPacket.setQQ(n);
            getCustomHeadDataPacket.setTimestamp(n2);
            getCustomHeadDataPacket.setOffset(n3);
            getCustomHeadDataPacket.setLength(n4);
            this.pool.send(string, getCustomHeadDataPacket, false);
        }
    }

    public void customHead_GetData(int n, int n2, String string) {
        if (this.user.isLoggedIn()) {
            GetCustomHeadDataPacket getCustomHeadDataPacket = new GetCustomHeadDataPacket(this.user);
            getCustomHeadDataPacket.setQQ(n);
            getCustomHeadDataPacket.setTimestamp(n2);
            this.pool.send(string, getCustomHeadDataPacket, false);
        }
    }

    public void customHead_GetInfo(List<Integer> list, String string) {
        if (this.user.isLoggedIn()) {
            GetCustomHeadInfoPacket getCustomHeadInfoPacket = new GetCustomHeadInfoPacket(this.user);
            getCustomHeadInfoPacket.setQqList(list);
            this.pool.send(string, getCustomHeadInfoPacket, false);
        }
    }

    private void doRobot(ReceiveIMPacket receiveIMPacket) {
        String string;
        if (this.isRobotMode() && this.robot != null && (string = this.robot.getReply(receiveIMPacket)) != null) {
            this.im_Send(receiveIMPacket.header.sender, Util.getBytes(string));
        }
    }

    public char face_ReplyData(int n, String string) {
        if (this.user.isLoggedIn()) {
            TransferPacket transferPacket = new TransferPacket(this.user);
            transferPacket.setSessionId(n);
            transferPacket.setDataReply(true);
            this.pool.send(string, transferPacket, false);
            return transferPacket.getSequence();
        }
        return '\u0000';
    }

    public char face_Request(int n, int n2, byte[] byArray, String string) {
        if (this.user.isLoggedIn()) {
            RequestFacePacket requestFacePacket = new RequestFacePacket(this.user);
            requestFacePacket.setClusterId(n);
            requestFacePacket.setEncryptKey(byArray);
            requestFacePacket.setFileAgentToken(this.user.getFileAgentToken());
            requestFacePacket.setSessionId(n2);
            this.pool.send(string, requestFacePacket, false);
            return requestFacePacket.getSequence();
        }
        return '\u0000';
    }

    public char face_RequestAgent(int n, int n2, byte[] byArray, String string, String string2) {
        if (this.user.isLoggedIn()) {
            RequestAgentPacket requestAgentPacket = new RequestAgentPacket(this.user);
            requestAgentPacket.setClusterId(n);
            requestAgentPacket.setImageLength(n2);
            requestAgentPacket.setMd5(byArray);
            requestAgentPacket.setFileName(string);
            this.pool.send(string2, requestAgentPacket, false);
            return requestAgentPacket.getSequence();
        }
        return '\u0000';
    }

    public char face_RequestData(int n, String string) {
        if (this.user.isLoggedIn()) {
            TransferPacket transferPacket = new TransferPacket(this.user);
            transferPacket.setSessionId(n);
            this.pool.send(string, transferPacket, false);
            return transferPacket.getSequence();
        }
        return '\u0000';
    }

    public char face_RequestReceiveBegin(int n, byte[] byArray, String string) {
        if (this.user.isLoggedIn()) {
            RequestBeginPacket requestBeginPacket = new RequestBeginPacket(this.user);
            requestBeginPacket.setSessionId(n);
            requestBeginPacket.setRequestSend(false);
            requestBeginPacket.setEncryptKey(byArray);
            this.pool.send(string, requestBeginPacket, false);
            return requestBeginPacket.getSequence();
        }
        return '\u0000';
    }

    public void face_RequestSendBegin(int n, byte[] byArray, String string) {
        if (this.user.isLoggedIn()) {
            RequestBeginPacket requestBeginPacket = new RequestBeginPacket(this.user);
            requestBeginPacket.setSessionId(n);
            requestBeginPacket.setMd5(byArray);
            this.pool.send(string, requestBeginPacket, false);
        }
    }

    public char face_TransferData(int n, byte[] byArray, boolean bl, String string) {
        if (this.user.isLoggedIn()) {
            TransferPacket transferPacket = new TransferPacket(this.user, true, bl);
            transferPacket.setSessionId(n);
            transferPacket.setFragment(byArray);
            this.pool.send(string, transferPacket, false);
            return transferPacket.getSequence();
        }
        return '\u0000';
    }

    public char face_TransferInfo(int n, int n2, String string, byte[] byArray, String string2) {
        if (this.user.isLoggedIn()) {
            TransferPacket transferPacket = new TransferPacket(this.user, false, false);
            transferPacket.setSessionId(n);
            transferPacket.setImageLength(n2);
            transferPacket.setFileName(string);
            transferPacket.setMd5(byArray);
            this.pool.send(string2, transferPacket, false);
            return transferPacket.getSequence();
        }
        return '\u0000';
    }

    public void firePacketArrivedEvent(PacketEvent packetEvent) {
        this.router.packetArrived(packetEvent);
    }

    public void fireQQEvent(QQEvent qQEvent) {
        this.checkListenerChange();
        int n = this.qqListenersBackup.size();
        for (int i = 0; i < n; ++i) {
            this.qqListenersBackup.get(i).qqEvent(qQEvent);
        }
    }

    public String generateCrashReport(Throwable throwable, _08Packet _08Packet2) {
        StringBuilder stringBuilder = new StringBuilder();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        stringBuilder.append(stringWriter.getBuffer());
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("_08Packet Dump:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(Util.convertByteToHexString(_08Packet2.dump()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("User QQ: ");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(String.valueOf(this.user.getQQ()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("Init Key:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(Util.convertByteToHexString(this.user.getInitKey()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("Session Key:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(Util.convertByteToHexString(this.user.getSessionKey()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("Auth Token:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(Util.convertByteToHexString(this.user.getAuthToken()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("Login Token:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(Util.convertByteToHexString(this.user.getLoginToken()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("Client Key:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(Util.convertByteToHexString(this.user.getClientKey()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("File Session Key:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(Util.convertByteToHexString(this.user.getFileSessionKey()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("File Agent Key:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(Util.convertByteToHexString(this.user.getFileAgentKey()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("File Agent Token:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(Util.convertByteToHexString(this.user.getFileAgentToken()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("Unknown 03 Key:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(Util.convertByteToHexString(this.user.getUnknown03Key()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("Unkonwn 03 Token:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(Util.convertByteToHexString(this.user.getUnknown03Token()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("Unknown 06 Key:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(Util.convertByteToHexString(this.user.getUnknown06Key()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("Unkonwn 06 Token:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(Util.convertByteToHexString(this.user.getUnknown06Token()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("Unknown 07 Key:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(Util.convertByteToHexString(this.user.getUnknown07Key()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("Unkonwn 07 Token:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(Util.convertByteToHexString(this.user.getUnknown07Token()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("Unknown 08 Key:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(Util.convertByteToHexString(this.user.getUnknown08Key()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("Unkonwn 08 Token:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(Util.convertByteToHexString(this.user.getUnknown08Token()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(System.getProperty("line.separator"));
        return stringBuilder.toString();
    }

    public synchronized IConnection getConnection(InetSocketAddress inetSocketAddress) {
        return this.pool.getConnection(inetSocketAddress);
    }

    public synchronized IConnection getConnection(String string) {
        return this.pool.getConnection(string);
    }

    public synchronized IConnectionPolicy getConnectionPolicy(_08InPacket _08InPacket2) {
        String string = this.inConn.remove(_08InPacket2);
        IConnection iConnection = this.getConnection(string);
        if (iConnection == null) {
            return null;
        }
        return iConnection.getPolicy();
    }

    public IConnectionPolicyFactory getConnectionPolicyFactory() {
        return this.policyFactory;
    }

    public IConnectionPool getConnectionPool() {
        return this.pool;
    }

    public IConnectionPoolFactory getConnectionPoolFactory() {
        return this.poolFactory;
    }

    public String getLoginServer() {
        return this.loginServer;
    }

    public IConnectionPool getPortGate() {
        return this.pool;
    }

    public int getProxyType() {
        return this.proxyType;
    }

    public IRobot getRobot() {
        return this.robot;
    }

    public QQUser getUser() {
        return this.user;
    }

    public void im_Send(int n, byte[] byArray) {
        this.im_Send(n, byArray, (byte)1);
    }

    public void im_Send(int n, byte[] byArray, byte by) {
        this.im_Send(n, byArray, "\u5b8b\u4f53", false, false, false, 9, 0, 0, 0, by);
    }

    public void im_Send(int n, byte[] byArray, char c, int n2, int n3, String string, boolean bl, boolean bl2, boolean bl3, int n4, int n5, int n6, int n7, byte by) {
        if (this.user.isLoggedIn()) {
            SendIMPacket sendIMPacket = new SendIMPacket(this.user);
            sendIMPacket.setReceiver(n);
            sendIMPacket.setMessage(byArray);
            sendIMPacket.setTotalFragments(n2);
            sendIMPacket.setFragmentSequence(n3);
            sendIMPacket.setMessageId(c);
            sendIMPacket.setFontName(string);
            sendIMPacket.setFontSize((byte)(n4 & 0xFF));
            sendIMPacket.setRed((byte)(n5 & 0xFF));
            sendIMPacket.setGreen((byte)(n6 & 0xFF));
            sendIMPacket.setBlue((byte)(n7 & 0xFF));
            sendIMPacket.setBold(bl);
            sendIMPacket.setItalic(bl2);
            sendIMPacket.setUnderline(bl3);
            sendIMPacket.setReplyType(by);
            this.pool.send(QQPort.MAIN.name, sendIMPacket, true);
        }
    }

    public void im_Send(int n, byte[] byArray, String string, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4, int n5, byte by) {
        this.im_Send(n, byArray, '\u0000', 1, 0, string, bl, bl2, bl3, n2, n3, n4, n5, by);
    }

    public void im_SendCluster(int n, String string) {
        if (this.user.isLoggedIn()) {
            ClusterSendIMExPacket clusterSendIMExPacket = new ClusterSendIMExPacket(this.user);
            clusterSendIMExPacket.setClusterId(n);
            clusterSendIMExPacket.setMessage(string);
            clusterSendIMExPacket.setMessageId(clusterSendIMExPacket.getSequence());
            this.pool.send(QQPort.MAIN.name, clusterSendIMExPacket, true);
        }
    }

    public void im_SendCluster(int n, String string, char c, int n2, int n3) {
        if (this.user.isLoggedIn()) {
            ClusterSendIMExPacket clusterSendIMExPacket = new ClusterSendIMExPacket(this.user);
            clusterSendIMExPacket.setClusterId(n);
            clusterSendIMExPacket.setMessage(string);
            clusterSendIMExPacket.setMessageId(c);
            clusterSendIMExPacket.setTotalFragments(n2);
            clusterSendIMExPacket.setFragmentSequence(n3);
            this.pool.send(QQPort.MAIN.name, clusterSendIMExPacket, true);
        }
    }

    public void im_SendCluster(int n, String string, char c, int n2, int n3, String string2, boolean bl, boolean bl2, boolean bl3, int n4, int n5, int n6, int n7) {
        if (this.user.isLoggedIn()) {
            ClusterSendIMExPacket clusterSendIMExPacket = new ClusterSendIMExPacket(this.user);
            clusterSendIMExPacket.setClusterId(n);
            clusterSendIMExPacket.setMessage(string);
            clusterSendIMExPacket.setMessageId(c);
            clusterSendIMExPacket.setTotalFragments(n2);
            clusterSendIMExPacket.setFragmentSequence(n3);
            clusterSendIMExPacket.setFontName(string2);
            clusterSendIMExPacket.setFontSize((byte)n4);
            clusterSendIMExPacket.setBold(bl);
            clusterSendIMExPacket.setItalic(bl2);
            clusterSendIMExPacket.setUnderline(bl3);
            clusterSendIMExPacket.setRed((byte)n5);
            clusterSendIMExPacket.setGreen((byte)n6);
            clusterSendIMExPacket.setBlue((byte)n7);
            this.pool.send(QQPort.MAIN.name, clusterSendIMExPacket, true);
        }
    }

    public void im_SendTempCluster(byte by, int n, int n2, String string) {
        if (this.user.isLoggedIn()) {
            ClusterSendTempIMPacket clusterSendTempIMPacket = new ClusterSendTempIMPacket(this.user);
            clusterSendTempIMPacket.setClusterId(n);
            clusterSendTempIMPacket.setType(by);
            clusterSendTempIMPacket.setParentClusterId(n2);
            clusterSendTempIMPacket.setMessage(string);
            clusterSendTempIMPacket.setMessageId(clusterSendTempIMPacket.getSequence());
            this.pool.send(QQPort.MAIN.name, clusterSendTempIMPacket, true);
        }
    }

    public void im_SendTempCluster(byte by, int n, int n2, String string, int n3, int n4) {
        if (this.user.isLoggedIn()) {
            ClusterSendTempIMPacket clusterSendTempIMPacket = new ClusterSendTempIMPacket(this.user);
            clusterSendTempIMPacket.setClusterId(n);
            clusterSendTempIMPacket.setType(by);
            clusterSendTempIMPacket.setParentClusterId(n2);
            clusterSendTempIMPacket.setMessage(string);
            clusterSendTempIMPacket.setMessageId(clusterSendTempIMPacket.getSequence());
            clusterSendTempIMPacket.setTotalFragments(n3);
            clusterSendTempIMPacket.setFragmentSequence(n4);
            this.pool.send(QQPort.MAIN.name, clusterSendTempIMPacket, true);
        }
    }

    public void im_SendTempCluster(byte by, int n, int n2, String string, char c, int n3, int n4, String string2, boolean bl, boolean bl2, boolean bl3, int n5, int n6, int n7, int n8) {
        if (this.user.isLoggedIn()) {
            ClusterSendTempIMPacket clusterSendTempIMPacket = new ClusterSendTempIMPacket(this.user);
            clusterSendTempIMPacket.setClusterId(n);
            clusterSendTempIMPacket.setType(by);
            clusterSendTempIMPacket.setParentClusterId(n2);
            clusterSendTempIMPacket.setMessage(string);
            clusterSendTempIMPacket.setMessageId(c);
            clusterSendTempIMPacket.setTotalFragments(n3);
            clusterSendTempIMPacket.setFragmentSequence(n4);
            clusterSendTempIMPacket.setFontName(string2);
            clusterSendTempIMPacket.setFontSize((byte)n5);
            clusterSendTempIMPacket.setBold(bl);
            clusterSendTempIMPacket.setItalic(bl2);
            clusterSendTempIMPacket.setUnderline(bl3);
            clusterSendTempIMPacket.setRed((byte)n6);
            clusterSendTempIMPacket.setGreen((byte)n7);
            clusterSendTempIMPacket.setBlue((byte)n8);
            this.pool.send(QQPort.MAIN.name, clusterSendTempIMPacket, true);
        }
    }

    public void im_SendTempSession(int n, String string, String string2) {
        this.im_SendTempSession(n, string, string2, "\u5b8b\u4f53", false, false, false, 9, 0, 0, 0);
    }

    public void im_SendTempSession(int n, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4, int n5) {
        if (this.user.isLoggedIn()) {
            TempSessionOpPacket tempSessionOpPacket = new TempSessionOpPacket(this.user);
            tempSessionOpPacket.setSubCommand((byte)1);
            tempSessionOpPacket.setNick(string2);
            tempSessionOpPacket.setReceiver(n);
            tempSessionOpPacket.setMessage(string);
            tempSessionOpPacket.setFontName(string3);
            tempSessionOpPacket.setFontSize((byte)(n2 & 0xFF));
            tempSessionOpPacket.setRed((byte)(n3 & 0xFF));
            tempSessionOpPacket.setGreen((byte)(n4 & 0xFF));
            tempSessionOpPacket.setBlue((byte)(n5 & 0xFF));
            tempSessionOpPacket.setBold(bl);
            tempSessionOpPacket.setItalic(bl2);
            tempSessionOpPacket.setUnderline(bl3);
            this.pool.send(QQPort.MAIN.name, tempSessionOpPacket, true);
        }
    }

    public synchronized boolean isEmpty() {
        return this.receiveQueue.isEmpty();
    }

    private synchronized boolean isListenerChanged() {
        return this.listenerChanged;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public boolean isRobotMode() {
        return this.robotMode;
    }

    public void keepAlive() {
        if (this.user.isLoggedIn()) {
            _08KeepAlivePacket _08KeepAlivePacket2 = new _08KeepAlivePacket(this.user);
            this.pool.send(QQPort.MAIN.name, _08KeepAlivePacket2, false);
        }
    }

    public void sendTouch() {
        if (this.user != null && !this.logging && this.loginServer != null) {
            if (this.user.isUdp()) {
                this.sendTouch(this.loginServer, 8000);
            } else {
                this.sendTouch(this.loginServer, this.tcpLoginPort);
            }
        }
    }

    public void sendTouch(String string, int n) {
        if (string == null || string.equalsIgnoreCase("") || string.equalsIgnoreCase("0.0.0.0")) {
            this.sendTouch();
        }
        if (this.user != null && this.poolFactory != null) {
            this.logout();
            this.logging = true;
            try {
                if (n == 0) {
                    n = this.user.isUdp() ? 8000 : this.tcpLoginPort;
                }
                IConnection iConnection = QQPort.MAIN.create(this, new InetSocketAddress(string, n), this.proxyAddress, this.proxyUsername, this.proxyPassword, false);
                _08TouchLoginPacket _08TouchLoginPacket2 = new _08TouchLoginPacket(this.user);
                this.pool.start();
                iConnection.start();
                this.pool.send(QQPort.MAIN.name, _08TouchLoginPacket2, false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void sendToken1() {
        _08LoginToken1Packet _08LoginToken1Packet2 = new _08LoginToken1Packet(this.user);
        this.sendPakcetAnywayNoPort(_08LoginToken1Packet2);
    }

    public void sendToken2(byte[] byArray, String string, int n) {
        _08LoginToken2Packet _08LoginToken2Packet2 = new _08LoginToken2Packet(this.user);
        if (n != 0) {
            _08LoginToken2Packet2.setSubCommand((byte)3);
        } else {
            _08LoginToken2Packet2.setSubCommand((byte)4);
        }
        _08LoginToken2Packet2.setVerifyCode(string);
        _08LoginToken2Packet2.setFragmentIndex((byte)n);
        _08LoginToken2Packet2.setPuzzleToken(byArray);
        this.sendPakcetAnywayNoPort(_08LoginToken2Packet2);
    }

    private void sendToken2() {
        _08LoginToken2Packet _08LoginToken2Packet2 = new _08LoginToken2Packet(this.user);
        this.sendPakcetAnywayNoPort(_08LoginToken2Packet2);
    }

    public void sendLoginKey() {
        _08LoginKeyPacket _08LoginKeyPacket2 = new _08LoginKeyPacket(this.user);
        this.sendPakcetAnywayNoPort(_08LoginKeyPacket2);
    }

    public void logout() {
        boolean bl = this.user.isLoggedIn();
        if (!this.loginRedirect) {
            this.user.setLoginToken(null);
        }
        this.user.setLoggedIn(false);
        this.logging = false;
        this.loginRedirect = false;
        if (this.pool != null) {
            IConnection iConnection = this.pool.getConnection(QQPort.MAIN.name);
            if (iConnection != null) {
                iConnection.clearSendQueue();
                if (bl) {
                    LogoutPacket logoutPacket = new LogoutPacket(this.user);
                    this.pool.send(QQPort.MAIN.name, logoutPacket, false);
                }
            }
            this.pool.dispose();
        }
        this.pool = this.poolFactory.newPool();
        if (this.keepAliveFuture != null) {
            this.keepAliveFuture.cancel(false);
            this.keepAliveFuture = null;
        }
        this.resendTrigger.clear();
    }

    private void processKeepAliveFail() {
        this.user.setLoggedIn(false);
        this.logout();
    }

    private void processKeepAliveSuccess() {
        _08GetOnlineOpPacket _08GetOnlineOpPacket2 = new _08GetOnlineOpPacket(this.user);
        this.sendPacket(_08GetOnlineOpPacket2);
    }

    private void processLoginSuccess() {
        if (!this.user.isLoggedIn()) {
            this.user.setLoggedIn(true);
            this.logging = false;
            this.common_RequestKey((byte)3);
            this.common_RequestKey((byte)4);
            this.common_RequestKey((byte)6);
            this.common_RequestKey((byte)7);
            this.common_RequestKey((byte)8);
            GetUserInfoPacket getUserInfoPacket = new GetUserInfoPacket(this.user);
            this.sendPacket(getUserInfoPacket);
            ChangeStatusPacket changeStatusPacket = new ChangeStatusPacket(this.user);
            changeStatusPacket.setShowFakeCam(this.user.isShowFakeCam());
            this.sendPacket(changeStatusPacket);
            this.keepAliveFuture = executor.scheduleWithFixedDelay(this.keepAliveTrigger, 100000L, 100000L, TimeUnit.MILLISECONDS);
        }
    }

    private void processLoginTimeout() {
        this.logging = false;
        this.logout();
    }

    private void processNormalIM(QQEvent qQEvent) {
        this.processReceiveIM(qQEvent);
        ReceiveIMPacket receiveIMPacket = (ReceiveIMPacket)qQEvent.getSource();
        this.doRobot(receiveIMPacket);
    }

    private ReceiveIMPacket processReceiveIM(QQEvent qQEvent) {
        ReceiveIMPacket receiveIMPacket = (ReceiveIMPacket)qQEvent.getSource();
        ReceiveIMReplyPacket receiveIMReplyPacket = new ReceiveIMReplyPacket(receiveIMPacket.reply, this.user);
        receiveIMReplyPacket.setSequence(receiveIMPacket.getSequence());
        this.pool.send(QQPort.MAIN.name, receiveIMReplyPacket, false);
        return receiveIMPacket;
    }

    private void sendLogin() {
        _08LoginPacket _08LoginPacket2 = new _08LoginPacket(this.user);
        this.sendPakcetAnywayNoPort(_08LoginPacket2);
    }

    @Override
    public void qqEvent(QQEvent qQEvent) {
        switch (qQEvent.type) {
            case 20487: {
                this.sendToken1();
                break;
            }
            case 20488: {
                this.sendToken2();
                break;
            }
            case 20489: {
                this.sendLoginKey();
                break;
            }
            case 20490: {
                this.sendLogin();
                break;
            }
            case 20491: {
                this.sendLogin();
                break;
            }
            case 20484: {
                this.processLoginSuccess();
                break;
            }
            case 32779: {
                this.processKeepAliveSuccess();
                break;
            }
            case 65535: {
                break;
            }
            case 16388: {
                this.processNormalIM(qQEvent);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 36: 
            case 51: 
            case 52: 
            case 8192: 
            case 8193: 
            case 8196: 
            case 8197: 
            case 8203: 
            case 8204: 
            case 12297: 
            case 12308: 
            case 12312: 
            case 16384: 
            case 16387: 
            case 16390: 
            case 16393: 
            case 16396: 
            case 16397: 
            case 24576: 
            case 28677: 
            case 32780: {
                this.processReceiveIM(qQEvent);
                break;
            }
            case 4096: 
            case 4097: 
            case 4098: {
                this.processError(qQEvent);
                break;
            }
            case 28681: {
                switch (qQEvent.operation) {
                    case 34: 
                    case 186: {
                        this.processLoginTimeout();
                    }
                }
                break;
            }
            case 32778: {
                this.processKeepAliveFail();
                break;
            }
            case 12318: {
                this.user_SendAuth(this.getQqNum(), this.getAuthMsg());
                break;
            }
            case 12327: {
                this.cluster_RequestJoin(this.getClusterId(), this.getAuthMsg());
            }
        }
    }

    private void processError(QQEvent qQEvent) {
        if (qQEvent.getSource() instanceof ErrorPacket) {
            ErrorPacket errorPacket = (ErrorPacket)qQEvent.getSource();
            this.releaseConnection(errorPacket.connectionId);
        }
    }

    public void release() {
        executor.decreaseClient();
    }

    public synchronized void releaseConnection(String string) {
        if (this.pool != null) {
            this.pool.release(string);
        }
    }

    public synchronized _08InPacket removeIncomingPacket() {
        return this.receiveQueue.poll();
    }

    public void removeQQListener(IQQListener iQQListener) {
        if (this.qqListeners.contains(iQQListener)) {
            this.qqListeners.remove(iQQListener);
            this.setListenerChanged(true);
        }
    }

    public void removeResendPacket(_08InPacket _08InPacket2) {
        this.resendTrigger.remove(_08InPacket2);
    }

    public void sendPacket(_08OutPacket _08OutPacket2) {
        if (this.user.isLoggedIn()) {
            this.pool.send(QQPort.MAIN.name, _08OutPacket2, true);
        }
    }

    public void sendPacket(_08OutPacket _08OutPacket2, String string) {
        this.sendPacket(_08OutPacket2, string, true);
    }

    public void sendPacket(_08OutPacket _08OutPacket2, String string, boolean bl) {
        if (this.user.isLoggedIn()) {
            this.pool.send(string, _08OutPacket2, bl);
        }
    }

    public void sendPacketAnyway(_08OutPacket _08OutPacket2, String string) {
        this.pool.send(string, _08OutPacket2, true);
    }

    public void sendPakcetAnywayNoPort(_08OutPacket _08OutPacket2) {
        this.pool.send(QQPort.MAIN.name, _08OutPacket2, true);
    }

    public void setConnectionPolicyFactory(IConnectionPolicyFactory iConnectionPolicyFactory) {
        this.policyFactory = iConnectionPolicyFactory;
    }

    public void setConnectionPoolFactory(IConnectionPoolFactory iConnectionPoolFactory) {
        this.poolFactory = iConnectionPoolFactory;
    }

    private synchronized void setListenerChanged(boolean bl) {
        this.listenerChanged = bl;
    }

    public void setLogging(boolean bl) {
        this.logging = bl;
    }

    public void setLoginRedirect(boolean bl) {
        this.loginRedirect = bl;
    }

    public void setLoginServer(String string) {
        this.loginServer = string;
    }

    public void setProxy(InetSocketAddress inetSocketAddress) {
        this.proxyAddress = inetSocketAddress;
    }

    public void setProxyPassword(String string) {
        this.proxyPassword = string == null || string.equals("") ? null : string;
    }

    public void setProxyType(String string) {
        this.proxyType = string.equalsIgnoreCase("Socks5") ? 2 : (string.equalsIgnoreCase("Http") ? 1 : 0);
    }

    public void setProxyUsername(String string) {
        this.proxyUsername = string == null || string.equals("") ? null : string;
    }

    public void setRobot(IRobot iRobot) {
        this.robot = iRobot;
    }

    public void setRobotMode(boolean bl) {
        this.robotMode = bl;
    }

    public void setTcpLoginPort(int n) {
        this.tcpLoginPort = n;
    }

    public void setUser(QQUser qQUser) {
        this.user = qQUser;
    }

    public char sms_Send(List<String> list, List<Integer> list2, String string, byte[] byArray, char c) {
        if (this.user.isLoggedIn()) {
            SendSMSPacket sendSMSPacket = new SendSMSPacket(this.user);
            sendSMSPacket.setMessageSequence(c);
            sendSMSPacket.setMessage(byArray);
            sendSMSPacket.setSenderName(string);
            sendSMSPacket.setReceiverMobile(list);
            sendSMSPacket.setReceiverQQ(list2);
            this.pool.send(QQPort.MAIN.name, sendSMSPacket, true);
            return sendSMSPacket.getSequence();
        }
        return '\u0000';
    }

    public void status_Away() {
        if (this.user.isLoggedIn() && this.pool.hasConnection(QQPort.MAIN.name)) {
            this.user.setStatus((byte)30);
            ChangeStatusPacket changeStatusPacket = new ChangeStatusPacket(this.user);
            changeStatusPacket.setShowFakeCam(this.user.isShowFakeCam());
            this.pool.send(QQPort.MAIN.name, changeStatusPacket, false);
        }
    }

    public void status_Hidden() {
        if (this.user.isLoggedIn() && this.pool.hasConnection(QQPort.MAIN.name)) {
            this.user.setStatus((byte)40);
            ChangeStatusPacket changeStatusPacket = new ChangeStatusPacket(this.user);
            changeStatusPacket.setShowFakeCam(this.user.isShowFakeCam());
            this.pool.send(QQPort.MAIN.name, changeStatusPacket, false);
        }
    }

    public void status_Busy() {
        if (this.user.isLoggedIn() && this.pool.hasConnection(QQPort.MAIN.name)) {
            this.user.setStatus((byte)50);
            ChangeStatusPacket changeStatusPacket = new ChangeStatusPacket(this.user);
            changeStatusPacket.setShowFakeCam(this.user.isShowFakeCam());
            this.pool.send(QQPort.MAIN.name, changeStatusPacket, false);
        }
    }

    public void status_Qme() {
        if (this.user.isLoggedIn() && this.pool.hasConnection(QQPort.MAIN.name)) {
            this.user.setStatus((byte)60);
            ChangeStatusPacket changeStatusPacket = new ChangeStatusPacket(this.user);
            changeStatusPacket.setShowFakeCam(this.user.isShowFakeCam());
            this.pool.send(QQPort.MAIN.name, changeStatusPacket, false);
        }
    }

    public void status_Mute() {
        if (this.user.isLoggedIn() && this.pool.hasConnection(QQPort.MAIN.name)) {
            this.user.setStatus((byte)70);
            ChangeStatusPacket changeStatusPacket = new ChangeStatusPacket(this.user);
            changeStatusPacket.setShowFakeCam(this.user.isShowFakeCam());
            this.pool.send(QQPort.MAIN.name, changeStatusPacket, false);
        }
    }

    public void status_Online() {
        if (this.user.isLoggedIn() && this.pool.hasConnection(QQPort.MAIN.name)) {
            this.user.setStatus((byte)10);
            ChangeStatusPacket changeStatusPacket = new ChangeStatusPacket(this.user);
            changeStatusPacket.setShowFakeCam(this.user.isShowFakeCam());
            this.pool.send(QQPort.MAIN.name, changeStatusPacket, false);
        }
    }

    public char user_Add(int n) {
        if (this.user.isLoggedIn()) {
            AddFriendExPacket addFriendExPacket = new AddFriendExPacket(this.user);
            addFriendExPacket.setTo(n);
            this.pool.send(QQPort.MAIN.name, addFriendExPacket, false);
            return addFriendExPacket.getSequence();
        }
        return '\u0000';
    }

    public void user_AddToList(int n, int n2) {
        if (this.user.isLoggedIn()) {
            UploadGroupFriendPacket uploadGroupFriendPacket = new UploadGroupFriendPacket(this.user);
            uploadGroupFriendPacket.addFriend(n, n2);
            this.pool.send(QQPort.MAIN.name, uploadGroupFriendPacket, false);
        }
    }

    public char user_AdvancedSearch(int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5) {
        if (this.user.isLoggedIn()) {
            AdvancedSearchUserPacket advancedSearchUserPacket = new AdvancedSearchUserPacket(this.user);
            advancedSearchUserPacket.setPage((char)n);
            advancedSearchUserPacket.setSearchOnline(bl);
            advancedSearchUserPacket.setHasCam(bl2);
            advancedSearchUserPacket.setProvinceIndex((char)n2);
            advancedSearchUserPacket.setCityIndex((char)n3);
            advancedSearchUserPacket.setAgeIndex((byte)n4);
            advancedSearchUserPacket.setGenderIndex((byte)n5);
            this.pool.send(QQPort.MAIN.name, advancedSearchUserPacket, false);
            return advancedSearchUserPacket.getSequence();
        }
        return '\u0000';
    }

    public void user_ApproveAdd(int n) {
        if (this.user.isLoggedIn()) {
            AddFriendAuthResponsePacket addFriendAuthResponsePacket = new AddFriendAuthResponsePacket(this.user);
            addFriendAuthResponsePacket.setTo(n);
            addFriendAuthResponsePacket.setAction((byte)48);
            this.pool.send(QQPort.MAIN.name, addFriendAuthResponsePacket, true);
        }
    }

    public char user_DeleteAuthInfo(int n) {
        if (this.user.isLoggedIn()) {
            _08AuthInfoOpPacket _08AuthInfoOpPacket2 = new _08AuthInfoOpPacket(this.user);
            _08AuthInfoOpPacket2.setSubCommand((byte)1);
            _08AuthInfoOpPacket2.setSubSubCommand('\u0006');
            _08AuthInfoOpPacket2.setFriendQQ(n);
            this.pool.send(QQPort.MAIN.name, _08AuthInfoOpPacket2, true);
            return _08AuthInfoOpPacket2.getSequence();
        }
        return '\u0000';
    }

    public char user_Delete(int n) {
        if (this.user.isLoggedIn()) {
            DeleteFriendPacket deleteFriendPacket = new DeleteFriendPacket(this.user);
            deleteFriendPacket.setTo(n);
            this.pool.send(QQPort.MAIN.name, deleteFriendPacket, true);
            return deleteFriendPacket.getSequence();
        }
        return '\u0000';
    }

    public char user_DeleteSignature() {
        if (this.user.isLoggedIn()) {
            _08SignatureOpPacket _08SignatureOpPacket2 = new _08SignatureOpPacket(this.user);
            _08SignatureOpPacket2.setSubCommand((byte)2);
            this.pool.send(QQPort.MAIN.name, _08SignatureOpPacket2, false);
            return _08SignatureOpPacket2.getSequence();
        }
        return '\u0000';
    }

    public void user_DownloadGroups(int n) {
        if (this.user.isLoggedIn()) {
            DownloadGroupFriendPacket downloadGroupFriendPacket = new DownloadGroupFriendPacket(this.user);
            downloadGroupFriendPacket.setBeginFrom(n);
            this.pool.send(QQPort.MAIN.name, downloadGroupFriendPacket, true);
        }
    }

    public void user_GetGroupNames() {
        if (this.user.isLoggedIn()) {
            GroupDataOpPacket groupDataOpPacket = new GroupDataOpPacket(this.user);
            groupDataOpPacket.setType((byte)1);
            this.pool.send(QQPort.MAIN.name, groupDataOpPacket, true);
        }
    }

    public void user_GetInfo(int n) {
        if (this.user.isLoggedIn()) {
            GetUserInfoPacket getUserInfoPacket = new GetUserInfoPacket(this.user);
            getUserInfoPacket.setQQ(n);
            this.pool.send(QQPort.MAIN.name, getUserInfoPacket, false);
        }
    }

    public void user_GetLevel(List<Integer> list) {
        if (this.user.isLoggedIn()) {
            FriendLevelOpPacket friendLevelOpPacket = new FriendLevelOpPacket(this.user);
            friendLevelOpPacket.setFriends(list);
            friendLevelOpPacket.setSubCommand((byte)2);
            this.pool.send(QQPort.MAIN.name, friendLevelOpPacket, false);
        }
    }

    public void user_GetList() {
        if (this.pool.hasConnection(QQPort.MAIN.name)) {
            GetFriendListPacket getFriendListPacket = new GetFriendListPacket(this.user);
            this.pool.send(QQPort.MAIN.name, getFriendListPacket, false);
        }
    }

    public void user_GetList(char c) {
        if (this.pool.hasConnection(QQPort.MAIN.name)) {
            GetFriendListPacket getFriendListPacket = new GetFriendListPacket(this.user);
            getFriendListPacket.setStartPosition(c);
            this.pool.send(QQPort.MAIN.name, getFriendListPacket, false);
        }
    }

    public void user_GetOnline() {
        if (this.pool.hasConnection(QQPort.MAIN.name)) {
            _08GetOnlineOpPacket _08GetOnlineOpPacket2 = new _08GetOnlineOpPacket(this.user);
            this.pool.send(QQPort.MAIN.name, _08GetOnlineOpPacket2, false);
        }
    }

    public void user_GetOnline(int n) {
        if (this.pool.hasConnection(QQPort.MAIN.name)) {
            _08GetOnlineOpPacket _08GetOnlineOpPacket2 = new _08GetOnlineOpPacket(this.user);
            _08GetOnlineOpPacket2.setStartPosition(n);
            this.pool.send(QQPort.MAIN.name, _08GetOnlineOpPacket2, false);
        }
    }

    public void user_GetProperty(char c) {
        if (this.pool.hasConnection(QQPort.MAIN.name)) {
            UserPropertyOpPacket userPropertyOpPacket = new UserPropertyOpPacket(this.user);
            userPropertyOpPacket.setStartPosition(c);
            userPropertyOpPacket.setSubCommand((byte)1);
            this.pool.send(QQPort.MAIN.name, userPropertyOpPacket, false);
        }
    }

    public void user_GetRemark(int n) {
        if (this.user.isLoggedIn()) {
            FriendDataOpPacket friendDataOpPacket = new FriendDataOpPacket(this.user);
            friendDataOpPacket.setSubCommand((byte)3);
            friendDataOpPacket.setQQ(n);
            this.pool.send(QQPort.MAIN.name, friendDataOpPacket, false);
        }
    }

    public void user_GetRemarks(int n) {
        if (this.user.isLoggedIn()) {
            FriendDataOpPacket friendDataOpPacket = new FriendDataOpPacket(this.user);
            friendDataOpPacket.setSubCommand((byte)0);
            friendDataOpPacket.setPage(n);
            this.pool.send(QQPort.MAIN.name, friendDataOpPacket, false);
        }
    }

    public void user_GetSignature(List<Signature> list) {
        if (this.user.isLoggedIn()) {
            _08SignatureOpPacket _08SignatureOpPacket2 = new _08SignatureOpPacket(this.user);
            _08SignatureOpPacket2.setSubCommand((byte)3);
            _08SignatureOpPacket2.setSignatures(list);
            this.pool.send(QQPort.MAIN.name, _08SignatureOpPacket2, false);
        }
    }

    public void user_ModifyInfo(String string, String string2, ContactInfo contactInfo) {
        if (this.user.isLoggedIn()) {
            _08ModifyInfoPacket _08ModifyInfoPacket2 = new _08ModifyInfoPacket(this.user);
            _08ModifyInfoPacket2.setOldPassword(string);
            _08ModifyInfoPacket2.setNewPassword(string2);
            String[] stringArray = contactInfo.getInfoArray();
            for (int i = 1; i < 35; ++i) {
                if (!stringArray[i].equals("-")) continue;
                stringArray[i] = "";
            }
            _08ModifyInfoPacket2.setContactInfo(contactInfo);
            this.pool.send(QQPort.MAIN.name, _08ModifyInfoPacket2, true);
        }
    }

    public char user_ModifySignature(String string) {
        if (this.user.isLoggedIn()) {
            _08SignatureOpPacket _08SignatureOpPacket2 = new _08SignatureOpPacket(this.user);
            if (string != null && !string.equalsIgnoreCase("")) {
                _08SignatureOpPacket2.setSubCommand((byte)1);
                _08SignatureOpPacket2.setSignature(string);
                this.pool.send(QQPort.MAIN.name, _08SignatureOpPacket2, false);
            } else if (string != null && string.equalsIgnoreCase("")) {
                this.user_DeleteSignature();
            }
            return _08SignatureOpPacket2.getSequence();
        }
        return '\u0000';
    }

    public void user_RejectAdd(int n, String string) {
        if (this.user.isLoggedIn()) {
            AddFriendAuthResponsePacket addFriendAuthResponsePacket = new AddFriendAuthResponsePacket(this.user);
            addFriendAuthResponsePacket.setTo(n);
            addFriendAuthResponsePacket.setMessage(string);
            addFriendAuthResponsePacket.setAction((byte)49);
            this.pool.send(QQPort.MAIN.name, addFriendAuthResponsePacket, true);
        }
    }

    public void user_RemoveFromList(int n) {
        if (this.user.isLoggedIn()) {
            FriendDataOpPacket friendDataOpPacket = new FriendDataOpPacket(this.user);
            friendDataOpPacket.setSubCommand((byte)2);
            friendDataOpPacket.setQQ(n);
            this.pool.send(QQPort.MAIN.name, friendDataOpPacket, true);
        }
    }

    public void user_RemoveSelfFrom(int n) {
        if (this.user.isLoggedIn()) {
            RemoveSelfPacket removeSelfPacket = new RemoveSelfPacket(this.user);
            removeSelfPacket.setRemoveFrom(n);
            this.pool.send(QQPort.MAIN.name, removeSelfPacket, true);
        }
    }

    public char user_Search(int n) {
        if (this.user.isLoggedIn()) {
            SearchUserPacket searchUserPacket = new SearchUserPacket(this.user);
            searchUserPacket.setPage(n);
            this.pool.send(QQPort.MAIN.name, searchUserPacket, false);
            return searchUserPacket.getSequence();
        }
        return '\u0000';
    }

    public char user_Search(int n, String string, String string2, String string3) {
        if (this.user.isLoggedIn()) {
            SearchUserPacket searchUserPacket = new SearchUserPacket(this.user);
            if (string == null || string.trim().equals("")) {
                searchUserPacket.setSearchType((byte)50);
            } else {
                searchUserPacket.setSearchType((byte)51);
            }
            searchUserPacket.setPage(n);
            searchUserPacket.setQQStr(string);
            searchUserPacket.setNick(string2);
            searchUserPacket.setEmail(string3);
            this.pool.send(QQPort.MAIN.name, searchUserPacket, false);
            return searchUserPacket.getSequence();
        }
        return '\u0000';
    }

    public char user_SendAuth(int n, String string) {
        if (this.user.isLoggedIn()) {
            _08AuthorizePacket _08AuthorizePacket2 = new _08AuthorizePacket(this.user);
            _08AuthorizePacket2.setSubCommand((byte)2);
            _08AuthorizePacket2.setTo(n);
            _08AuthorizePacket2.setMessage(string);
            _08AuthorizePacket2.setPuzzleAuthInfo(this.user.getAuthToken());
            this.pool.send(QQPort.MAIN.name, _08AuthorizePacket2, true);
            return _08AuthorizePacket2.getSequence();
        }
        return '\u0000';
    }

    public void user_SetSearchMeByQQOnly() {
        if (this.user.isLoggedIn()) {
            PrivacyDataOpPacket privacyDataOpPacket = new PrivacyDataOpPacket(this.user);
            privacyDataOpPacket.setSubCommand((byte)3);
            privacyDataOpPacket.setOpCode((byte)1);
            this.pool.send(QQPort.MAIN.name, privacyDataOpPacket, false);
        }
    }

    public void user_ShareGeography() {
        if (this.user.isLoggedIn()) {
            PrivacyDataOpPacket privacyDataOpPacket = new PrivacyDataOpPacket(this.user);
            privacyDataOpPacket.setSubCommand((byte)4);
            privacyDataOpPacket.setOpCode((byte)1);
            this.pool.send(QQPort.MAIN.name, privacyDataOpPacket, false);
        }
    }

    public void user_UnsetSearchMeByQQOnly() {
        if (this.user.isLoggedIn()) {
            PrivacyDataOpPacket privacyDataOpPacket = new PrivacyDataOpPacket(this.user);
            privacyDataOpPacket.setSubCommand((byte)3);
            privacyDataOpPacket.setOpCode((byte)0);
            this.pool.send(QQPort.MAIN.name, privacyDataOpPacket, false);
        }
    }

    public void user_UnshareGeography() {
        if (this.user.isLoggedIn()) {
            PrivacyDataOpPacket privacyDataOpPacket = new PrivacyDataOpPacket(this.user);
            privacyDataOpPacket.setSubCommand((byte)4);
            privacyDataOpPacket.setOpCode((byte)0);
            this.pool.send(QQPort.MAIN.name, privacyDataOpPacket, false);
        }
    }

    public void user_UploadGroupNames(List<String> list) {
        if (this.user.isLoggedIn()) {
            GroupDataOpPacket groupDataOpPacket = new GroupDataOpPacket(this.user);
            groupDataOpPacket.setType((byte)2);
            groupDataOpPacket.setGroups(list);
            this.pool.send(QQPort.MAIN.name, groupDataOpPacket, true);
        }
    }

    public void user_UploadRemark(int n, FriendRemark friendRemark) {
        if (this.user.isLoggedIn()) {
            FriendDataOpPacket friendDataOpPacket = new FriendDataOpPacket(this.user);
            friendDataOpPacket.setRemark(friendRemark);
            friendDataOpPacket.setQQ(n);
            this.pool.send(QQPort.MAIN.name, friendDataOpPacket, true);
        }
    }

    public char weather_Get() {
        if (this.user.isLoggedIn()) {
            WeatherOpPacket weatherOpPacket = new WeatherOpPacket(this.user);
            weatherOpPacket.setIp(this.user.getIp());
            this.pool.send(QQPort.MAIN.name, weatherOpPacket, false);
            return weatherOpPacket.getSequence();
        }
        return '\u0000';
    }

    public char weather_Get(byte[] byArray) {
        if (this.user.isLoggedIn()) {
            WeatherOpPacket weatherOpPacket = new WeatherOpPacket(this.user);
            weatherOpPacket.setIp(byArray);
            this.pool.send(QQPort.MAIN.name, weatherOpPacket, false);
            return weatherOpPacket.getSequence();
        }
        return '\u0000';
    }

    public void login_RefreshPuzzle(byte[] byArray) {
        if (this.pool.hasConnection(QQPort.MAIN.name)) {
            _08LoginToken2Packet _08LoginToken2Packet2 = new _08LoginToken2Packet(this.user);
            _08LoginToken2Packet2.setSubCommand((byte)3);
            _08LoginToken2Packet2.setPuzzleToken(byArray);
            this.pool.send(QQPort.MAIN.name, _08LoginToken2Packet2, false);
        }
    }

    public String getMessage(QQEvent qQEvent) {
        String string = "";
        ReceiveIMPacket receiveIMPacket = this.processReceiveIM(qQEvent);
        try {
            string = new String(receiveIMPacket.normalIM.messageBytes, "GBK");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string;
    }

    public char user_AuthInfoOpPacket() {
        if (this.user.isLoggedIn()) {
            _08AuthInfoOpPacket _08AuthInfoOpPacket2 = new _08AuthInfoOpPacket(this.user);
            _08AuthInfoOpPacket2.setSubCommand((byte)1);
            if (this.isAddUser || this.isAddAdvancedUser) {
                _08AuthInfoOpPacket2.setSubSubCommand('\u0001');
                _08AuthInfoOpPacket2.setFriendQQ(this.getQqNum());
            } else {
                _08AuthInfoOpPacket2.setSubSubCommand('\u0007');
            }
            this.sendPacket(_08AuthInfoOpPacket2);
            return _08AuthInfoOpPacket2.getSequence();
        }
        return '\u0000';
    }

    public char user_AuthInfoOpPacket(String string, String string2) {
        if (this.user.isLoggedIn()) {
            _08AuthInfoOpPacket _08AuthInfoOpPacket2 = new _08AuthInfoOpPacket(this.user);
            _08AuthInfoOpPacket2.setSubCommand((byte)2);
            _08AuthInfoOpPacket2.setSubSubCommand('\u0002');
            _08AuthInfoOpPacket2.setFriendQQ(this.getQqNum());
            _08AuthInfoOpPacket2.setAuthString(string);
            _08AuthInfoOpPacket2.setCookie(string2);
            this.sendPacket(_08AuthInfoOpPacket2);
            return _08AuthInfoOpPacket2.getSequence();
        }
        return '\u0000';
    }

    public char user_AuthInfoOpPacket(int n) {
        if (this.user.isLoggedIn()) {
            _08AuthInfoOpPacket _08AuthInfoOpPacket2 = new _08AuthInfoOpPacket(this.user);
            _08AuthInfoOpPacket2.setSubCommand((byte)1);
            _08AuthInfoOpPacket2.setSubSubCommand('\u4200');
            _08AuthInfoOpPacket2.setFriendQQ(n);
            this.sendPacket(_08AuthInfoOpPacket2);
            return _08AuthInfoOpPacket2.getSequence();
        }
        return '\u0000';
    }

    public boolean isUserInfoChanged() {
        return this.isUserInfoChanged;
    }

    public void setUserInfoChanged(boolean bl) {
        this.isUserInfoChanged = bl;
    }

    public void setAddUser(boolean bl) {
        this.isAddUser = bl;
    }

    public void setAddAdvancedUser(boolean bl) {
        this.isAddAdvancedUser = bl;
    }

    public boolean isJoinCluster() {
        return this.isJoinCluster;
    }

    public void setJoinCluster(boolean bl) {
        this.isJoinCluster = bl;
    }

    public int getQqNum() {
        return this.qqNum;
    }

    public void setQqNum(int n) {
        this.qqNum = n;
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(int n) {
        this.clusterId = n;
    }

    public String getAuthMsg() {
        return this.authMsg;
    }

    public void setAuthMsg(String string) {
        this.authMsg = string;
    }

    public boolean isModifySig() {
        return this.isModifySig;
    }

    public void setModifySig(boolean bl) {
        this.isModifySig = bl;
    }

    public boolean isDelFriend() {
        return this.isDelFriend;
    }

    public void setDelFriend(boolean bl) {
        this.isDelFriend = bl;
    }
}

