/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlockHolder;
import net.kano.joscar.snaccmd.conn.ConnCommand;

public class EncryptionInfoAck
extends ConnCommand {
    private final ExtraInfoBlockHolder[] blocks;

    protected EncryptionInfoAck(SnacPacket packet) {
        super(35);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        this.blocks = ExtraInfoBlockHolder.readBlockHolders(snacData);
    }

    public EncryptionInfoAck(ExtraInfoBlockHolder[] blocks) {
        super(35);
        this.blocks = (ExtraInfoBlockHolder[])DefensiveTools.getSafeNonnullArrayCopy((Object[])blocks, (String)"blocks");
    }

    public final ExtraInfoBlockHolder[] getExtraInfoBlocks() {
        return (ExtraInfoBlockHolder[])this.blocks.clone();
    }

    public void writeData(OutputStream out) throws IOException {
        for (ExtraInfoBlockHolder block : this.blocks) {
            block.write(out);
        }
    }

    public String toString() {
        return "EncryptionInfoAck: blocks=" + Arrays.asList(this.blocks);
    }
}

