/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.coin;

import net.java.sip.communicator.impl.protocol.jabber.extensions.DefaultPacketExtensionProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.CallInfoPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.CoinIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.ConferenceMediaPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.ConferenceMediumProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.DescriptionProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.SIPDialogIDPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.SidebarsByValPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.StateProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.StateType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.URIPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.URIsPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.UserRolesPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.UsersProvider;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.xmlpull.v1.XmlPullParser;

public class CoinIQProvider
implements IQProvider {
    private final PacketExtensionProvider descriptionProvider = new DescriptionProvider();
    private final PacketExtensionProvider usersProvider = new UsersProvider();
    private final StateProvider stateProvider = new StateProvider();
    private final DefaultPacketExtensionProvider<URIsPacketExtension> urisProvider = new DefaultPacketExtensionProvider<URIsPacketExtension>(URIsPacketExtension.class);
    private final DefaultPacketExtensionProvider<SidebarsByValPacketExtension> sidebarsByValProvider = new DefaultPacketExtensionProvider<SidebarsByValPacketExtension>(SidebarsByValPacketExtension.class);

    public CoinIQProvider() {
        ProviderManager providerManager = ProviderManager.getInstance();
        providerManager.addExtensionProvider("roles", "", new DefaultPacketExtensionProvider<UserRolesPacketExtension>(UserRolesPacketExtension.class));
        providerManager.addExtensionProvider("uri", "", new DefaultPacketExtensionProvider<URIPacketExtension>(URIPacketExtension.class));
        providerManager.addExtensionProvider("sip", "", new DefaultPacketExtensionProvider<SIPDialogIDPacketExtension>(SIPDialogIDPacketExtension.class));
        providerManager.addExtensionProvider("medium", "", (Object)new ConferenceMediumProvider());
        providerManager.addExtensionProvider("available-media", "", new DefaultPacketExtensionProvider<ConferenceMediaPacketExtension>(ConferenceMediaPacketExtension.class));
        providerManager.addExtensionProvider("call-info", "", new DefaultPacketExtensionProvider<CallInfoPacketExtension>(CallInfoPacketExtension.class));
    }

    public IQ parseIQ(XmlPullParser parser) throws Exception {
        CoinIQ coinIQ = new CoinIQ();
        String entity = parser.getAttributeValue("", "entity");
        String version = parser.getAttributeValue("", "version");
        StateType state = StateType.full;
        String stateStr = parser.getAttributeValue("", "state");
        String sid = parser.getAttributeValue("", "sid");
        if (stateStr != null) {
            state = StateType.parseString(stateStr);
        }
        coinIQ.setEntity(entity);
        coinIQ.setVersion(Integer.parseInt(version));
        coinIQ.setState(state);
        coinIQ.setSID(sid);
        String elementName = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            elementName = parser.getName();
            if (eventType == 2) {
                PacketExtension childExtension;
                if (elementName.equals("conference-description")) {
                    childExtension = this.descriptionProvider.parseExtension(parser);
                    coinIQ.addExtension(childExtension);
                } else if (elementName.equals("users")) {
                    childExtension = this.usersProvider.parseExtension(parser);
                    coinIQ.addExtension(childExtension);
                } else if (elementName.equals("conference-state")) {
                    childExtension = this.stateProvider.parseExtension(parser);
                    coinIQ.addExtension(childExtension);
                } else if (elementName.equals("uris")) {
                    childExtension = this.urisProvider.parseExtension(parser);
                    coinIQ.addExtension(childExtension);
                } else if (elementName.equals("sidebars-by-val")) {
                    childExtension = this.sidebarsByValProvider.parseExtension(parser);
                    coinIQ.addExtension(childExtension);
                }
            }
            if (eventType != 3 || !parser.getName().equals("conference-info")) continue;
            done = true;
        }
        return coinIQ;
    }

    public static String parseText(XmlPullParser parser) throws Exception {
        boolean done = false;
        String text = null;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 4) {
                text = parser.getText();
                continue;
            }
            if (eventType != 3) continue;
            done = true;
        }
        return text;
    }
}

