/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.application;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.MediaLocator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.sf.fmj.media.cdp.GlobalCaptureDevicePlugger;
import net.sf.fmj.utility.LoggerSingleton;

public class CaptureDeviceBrowser
extends JPanel {
    private static final Logger logger = LoggerSingleton.logger;
    private final JComboBox deviceComboBox;
    private final JButton okButton;
    private final JButton cancelButton;
    private boolean okClicked = false;
    private Map<Integer, MediaLocator> deviceComboBoxMap = new HashMap<Integer, MediaLocator>();

    public static void main(String[] stringArray) {
        try {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "CaptureDeviceBrowser");
            logger.fine("" + CaptureDeviceBrowser.run(null));
            System.exit(0);
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "" + throwable, throwable);
        }
    }

    public static MediaLocator run(Frame frame) {
        JDialog jDialog = new JDialog();
        jDialog.setTitle("Select Capture Device");
        jDialog.setModal(true);
        Container container = jDialog.getContentPane();
        CaptureDeviceBrowser captureDeviceBrowser = new CaptureDeviceBrowser();
        container.add(captureDeviceBrowser);
        jDialog.pack();
        if (frame != null) {
            jDialog.setLocationRelativeTo(frame);
        }
        jDialog.setVisible(true);
        MediaLocator mediaLocator = captureDeviceBrowser.okClicked ? captureDeviceBrowser.getSelectedMediaLocator() : null;
        return mediaLocator;
    }

    public CaptureDeviceBrowser() {
        this.setLayout(new GridBagLayout());
        this.deviceComboBox = new JComboBox();
        this.deviceComboBox.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.deviceComboBox, gridBagConstraints);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CaptureDeviceBrowser.this.okClicked = true;
                CaptureDeviceBrowser.this.closeDialog();
            }
        });
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.okButton, gridBagConstraints2);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CaptureDeviceBrowser.this.closeDialog();
            }
        });
        this.add((Component)this.cancelButton, gridBagConstraints2);
        this.populate();
        this.okButton.setEnabled(!this.deviceComboBoxMap.isEmpty());
        this.setPreferredSize(new Dimension(300, 80));
    }

    private void closeDialog() {
        this.getParent().getParent().getParent().getParent().setVisible(false);
        ((JDialog)this.getParent().getParent().getParent().getParent()).dispose();
    }

    public MediaLocator getSelectedMediaLocator() {
        int n = this.deviceComboBox.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this.deviceComboBoxMap.get(n);
    }

    private void populate() {
        GlobalCaptureDevicePlugger.addCaptureDevices();
        Vector vector = CaptureDeviceManager.getDeviceList(null);
        if (vector == null || vector.size() == 0) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            CaptureDeviceInfo captureDeviceInfo = (CaptureDeviceInfo)vector.get(i);
            logger.fine("CaptureDeviceInfo: ");
            logger.fine(captureDeviceInfo.getName());
            logger.fine("" + captureDeviceInfo.getLocator());
            logger.fine("" + captureDeviceInfo.getFormats()[0]);
            this.deviceComboBox.addItem(captureDeviceInfo.getName());
            this.deviceComboBoxMap.put(new Integer(i), captureDeviceInfo.getLocator());
        }
    }
}

