/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol.javasound;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.protocol.javasound.JavaSoundUrlParserException;

public class JavaSoundUrlParser {
    private static final Pattern pattern = Pattern.compile("javasound://(([0-9]+)(/([0-9]+)(/([0-9]+)(/(big|little)(/(signed|unsigned))?)?)?)?)?");

    public static AudioFormat parse(String string) throws JavaSoundUrlParserException {
        if (string == null) {
            throw new JavaSoundUrlParserException(new NullPointerException());
        }
        if (!string.startsWith("javasound://")) {
            throw new JavaSoundUrlParserException("Expected URL to start with: javasound://");
        }
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new JavaSoundUrlParserException("URL does not match regular expression for javasound URLs");
        }
        int n = matcher.groupCount();
        double d = -1.0;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        try {
            if (matcher.group(2) != null && !matcher.group(2).equals("")) {
                d = Double.parseDouble(matcher.group(2));
            }
            if (matcher.group(4) != null && !matcher.group(4).equals("")) {
                n2 = Integer.parseInt(matcher.group(4));
            }
            if (matcher.group(6) != null && !matcher.group(6).equals("")) {
                n3 = Integer.parseInt(matcher.group(6));
            }
            if (matcher.group(8) != null && !matcher.group(8).equals("")) {
                int n6 = n4 = matcher.group(8).equals("big") ? 1 : 0;
            }
            if (matcher.group(10) != null && !matcher.group(10).equals("")) {
                n5 = matcher.group(10).equals("signed") ? 1 : 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new JavaSoundUrlParserException("Invalid number", numberFormatException);
        }
        return new AudioFormat("LINEAR", d, n2, n3, n4, n5);
    }
}

