/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.util.logging.Logger;
import net.sf.fmj.utility.LoggerSingleton;

public class SleepHelper {
    private static final Logger logger = LoggerSingleton.logger;
    private long mStart;
    private long tbStart;
    private boolean firstNonDiscard = true;
    public static long MILLI_TO_NANO = 1000000L;

    public long calculateSleep(long l) {
        long l2;
        long l3 = System.currentTimeMillis();
        if (this.firstNonDiscard) {
            this.mStart = l;
            this.tbStart = l3;
            this.firstNonDiscard = false;
            return 0L;
        }
        long l4 = l2 = l;
        long l5 = (long)((double)(l4 - this.mStart) / (1.0 * (double)MILLI_TO_NANO)) + this.tbStart;
        long l6 = l5 - l3;
        return l6;
    }

    public void reset() {
        this.mStart = 0L;
        this.tbStart = 0L;
        this.firstNonDiscard = true;
    }

    public void sleep(long l) throws InterruptedException {
        long l2 = this.calculateSleep(l);
        if (l2 > 0L) {
            logger.finer("Sleeping " + l2);
            Thread.sleep(l2);
        }
    }
}

