/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ffmpeg_java;

import com.sun.jna.Pointer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceCloneable;
import net.sf.ffmpeg_java.AVFormatLibrary;
import net.sf.ffmpeg_java.custom_protocol.CallbackURLProtocolHandler;
import net.sf.fmj.utility.LoggerSingleton;

public class PullDataSourceCallbackURLProtocolHandler
implements CallbackURLProtocolHandler {
    private static final Logger logger = LoggerSingleton.logger;
    private PullDataSource source;
    private PullSourceStream pss;
    private long curpos;
    public static final boolean TRACE = false;
    private boolean mustClone = false;
    private final boolean isSourceCloneable;
    private boolean opened = false;

    public PullDataSourceCallbackURLProtocolHandler(PullDataSource pullDataSource) {
        this.source = pullDataSource;
        this.isSourceCloneable = pullDataSource instanceof SourceCloneable;
    }

    public int close(AVFormatLibrary.URLContext uRLContext) {
        try {
            this.doClose();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
            return -1;
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "" + throwable, throwable);
            return -1;
        }
        return 0;
    }

    private void closeAndReopen() throws IOException {
        this.doClose();
        this.doOpen();
    }

    private void doClose() throws IOException {
        if (!this.opened) {
            return;
        }
        try {
            this.source.stop();
            this.source.disconnect();
        }
        finally {
            this.mustClone = true;
            this.opened = false;
        }
    }

    private void doOpen() throws IOException {
        if (this.opened) {
            return;
        }
        if (this.mustClone) {
            if (!this.isSourceCloneable) {
                logger.severe("PullSourceStreamCallbackURLProtocolHandler: cannot reopen because source is not SourceCloneable");
                throw new IOException("not SourceCloneable");
            }
            this.source = (PullDataSource)((SourceCloneable)((Object)this.source)).createClone();
        }
        this.source.connect();
        this.source.start();
        PullSourceStream[] pullSourceStreamArray = this.source.getStreams();
        if (pullSourceStreamArray.length < 1) {
            logger.warning("No streams");
            throw new IOException("No streams");
        }
        this.pss = pullSourceStreamArray[0];
        this.curpos = 0L;
        this.opened = true;
    }

    public int open(AVFormatLibrary.URLContext uRLContext, String string, int n) {
        if ((n & 2) != 0) {
            logger.severe("PullSourceStreamCallbackURLProtocolHandler: only read-only open supported");
            return -1;
        }
        if ((n & 1) != 0) {
            logger.severe("PullSourceStreamCallbackURLProtocolHandler: only read-only open supported");
            return -1;
        }
        try {
            this.doOpen();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
            return -1;
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "" + throwable, throwable);
            return -1;
        }
        return 0;
    }

    public int read(AVFormatLibrary.URLContext uRLContext, Pointer pointer, int n) {
        byte[] byArray = new byte[n];
        try {
            if (!this.opened) {
                logger.warning("Attempt to read with closed stream");
                return -1;
            }
            int n2 = this.pss.read(byArray, 0, n);
            pointer.write(0L, byArray, 0, n);
            this.curpos += (long)n2;
            return n2;
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
            return -1;
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "" + throwable, throwable);
            return -1;
        }
    }

    public long seek(AVFormatLibrary.URLContext uRLContext, long l, int n) {
        if (n == 65536) {
            long l2 = this.pss.getContentLength();
            return l2;
        }
        if (n == 2 && this.pss.getContentLength() < 0L) {
            return -1L;
        }
        boolean bl = this.pss instanceof Seekable;
        try {
            long l3;
            long l4;
            if (!bl) {
                if (n == 2) {
                    n = 0;
                    l += this.pss.getContentLength();
                }
                if (n == 1) {
                    n = 0;
                    l += this.curpos;
                }
                if (n == 0) {
                    if (this.pss.getContentLength() > 0L && l >= this.pss.getContentLength()) {
                        this.doClose();
                        this.curpos = l;
                        return this.curpos;
                    }
                    if (l >= this.curpos) {
                        n = 1;
                        l -= this.curpos;
                    } else {
                        n = 1;
                        this.closeAndReopen();
                    }
                }
                if (n == 1) {
                    byte[] byArray = new byte[1];
                    int n2 = 0;
                    while ((long)n2 < l) {
                        if (this.pss.read(byArray, 0, 1) < 0) {
                            logger.warning("attempt to seek past end of stream");
                            return -1L;
                        }
                        ++this.curpos;
                        ++n2;
                    }
                    return this.curpos;
                }
            }
            if (!bl) {
                return -1L;
            }
            Seekable seekable = (Seekable)((Object)this.pss);
            if (n == 0) {
                l4 = l;
            } else if (n == 1) {
                l4 = this.curpos + l;
            } else if (n == 2) {
                if (this.pss.getContentLength() < 0L) {
                    return -1L;
                }
                l4 = this.pss.getContentLength() + l;
            } else {
                logger.warning("seek: Invalid whence value: " + n);
                return -1L;
            }
            this.curpos = l3 = seekable.seek(l4);
            return l3;
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
            return -1L;
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "" + throwable, throwable);
            return -1L;
        }
    }

    public int write(AVFormatLibrary.URLContext uRLContext, Pointer pointer, int n) {
        logger.severe("write not supported");
        return -1;
    }
}

