/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.SyncPacketSend;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.InitiationListener;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5ClientForInitiator;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

public final class Socks5BytestreamManager
implements BytestreamManager {
    public static final String NAMESPACE = "http://jabber.org/protocol/bytestreams";
    private static final String SESSION_ID_PREFIX = "js5_";
    private static final Random randomGenerator;
    private static final Map<Connection, Socks5BytestreamManager> managers;
    private final Connection connection;
    private final Map<String, BytestreamListener> userListeners = new ConcurrentHashMap<String, BytestreamListener>();
    private final List<BytestreamListener> allRequestListeners = Collections.synchronizedList(new LinkedList());
    private final InitiationListener initiationListener;
    private int targetResponseTimeout = 10000;
    private int proxyConnectionTimeout = 10000;
    private final List<String> proxyBlacklist = Collections.synchronizedList(new LinkedList());
    private String lastWorkingProxy = null;
    private boolean proxyPrioritizationEnabled = true;
    private List<String> ignoredBytestreamRequests = Collections.synchronizedList(new LinkedList());

    public static synchronized Socks5BytestreamManager getBytestreamManager(Connection connection) {
        if (connection == null) {
            return null;
        }
        Socks5BytestreamManager manager = managers.get(connection);
        if (manager == null) {
            manager = new Socks5BytestreamManager(connection);
            managers.put(connection, manager);
            manager.activate();
        }
        return manager;
    }

    private Socks5BytestreamManager(Connection connection) {
        this.connection = connection;
        this.initiationListener = new InitiationListener(this);
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener listener) {
        this.allRequestListeners.add(listener);
    }

    @Override
    public void removeIncomingBytestreamListener(BytestreamListener listener) {
        this.allRequestListeners.remove(listener);
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener listener, String initiatorJID) {
        this.userListeners.put(initiatorJID, listener);
    }

    @Override
    public void removeIncomingBytestreamListener(String initiatorJID) {
        this.userListeners.remove(initiatorJID);
    }

    public void ignoreBytestreamRequestOnce(String sessionID) {
        this.ignoredBytestreamRequests.add(sessionID);
    }

    public synchronized void disableService() {
        ServiceDiscoveryManager serviceDiscoveryManager;
        this.connection.removePacketListener(this.initiationListener);
        this.initiationListener.shutdown();
        this.allRequestListeners.clear();
        this.userListeners.clear();
        this.lastWorkingProxy = null;
        this.proxyBlacklist.clear();
        this.ignoredBytestreamRequests.clear();
        managers.remove(this.connection);
        if (managers.size() == 0) {
            Socks5Proxy.getSocks5Proxy().stop();
        }
        if ((serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection)) != null) {
            serviceDiscoveryManager.removeFeature(NAMESPACE);
        }
    }

    public int getTargetResponseTimeout() {
        if (this.targetResponseTimeout <= 0) {
            this.targetResponseTimeout = 10000;
        }
        return this.targetResponseTimeout;
    }

    public void setTargetResponseTimeout(int targetResponseTimeout) {
        this.targetResponseTimeout = targetResponseTimeout;
    }

    public int getProxyConnectionTimeout() {
        if (this.proxyConnectionTimeout <= 0) {
            this.proxyConnectionTimeout = 10000;
        }
        return this.proxyConnectionTimeout;
    }

    public void setProxyConnectionTimeout(int proxyConnectionTimeout) {
        this.proxyConnectionTimeout = proxyConnectionTimeout;
    }

    public boolean isProxyPrioritizationEnabled() {
        return this.proxyPrioritizationEnabled;
    }

    public void setProxyPrioritizationEnabled(boolean proxyPrioritizationEnabled) {
        this.proxyPrioritizationEnabled = proxyPrioritizationEnabled;
    }

    @Override
    public Socks5BytestreamSession establishSession(String targetJID) throws XMPPException, IOException, InterruptedException {
        String sessionID = this.getNextSessionID();
        return this.establishSession(targetJID, sessionID);
    }

    @Override
    public Socks5BytestreamSession establishSession(String targetJID, String sessionID) throws XMPPException, IOException, InterruptedException {
        XMPPException discoveryException = null;
        if (!this.supportsSocks5(targetJID)) {
            throw new XMPPException(targetJID + " doesn't support SOCKS5 Bytestream");
        }
        ArrayList<String> proxies = new ArrayList<String>();
        try {
            proxies.addAll(this.determineProxies());
        }
        catch (XMPPException e) {
            discoveryException = e;
        }
        List<Bytestream.StreamHost> streamHosts = this.determineStreamHostInfos(proxies);
        if (streamHosts.isEmpty()) {
            throw discoveryException != null ? discoveryException : new XMPPException("no SOCKS5 proxies available");
        }
        String digest = Socks5Utils.createDigest(sessionID, this.connection.getUser(), targetJID);
        if (this.proxyPrioritizationEnabled && this.lastWorkingProxy != null) {
            Bytestream.StreamHost selectedStreamHost = null;
            for (Bytestream.StreamHost streamHost : streamHosts) {
                if (!streamHost.getJID().equals(this.lastWorkingProxy)) continue;
                selectedStreamHost = streamHost;
                break;
            }
            if (selectedStreamHost != null) {
                streamHosts.remove(selectedStreamHost);
                streamHosts.add(0, selectedStreamHost);
            }
        }
        Socks5Proxy socks5Proxy = Socks5Proxy.getSocks5Proxy();
        try {
            socks5Proxy.addTransfer(digest);
            Bytestream initiation = this.createBytestreamInitiation(sessionID, targetJID, streamHosts);
            Packet response = SyncPacketSend.getReply(this.connection, initiation, this.getTargetResponseTimeout());
            Bytestream.StreamHostUsed streamHostUsed = ((Bytestream)response).getUsedHost();
            Bytestream.StreamHost usedStreamHost = initiation.getStreamHost(streamHostUsed.getJID());
            if (usedStreamHost == null) {
                throw new XMPPException("Remote user responded with unknown host");
            }
            Socks5ClientForInitiator socks5Client = new Socks5ClientForInitiator(usedStreamHost, digest, this.connection, sessionID, targetJID);
            Socket socket = ((Socks5Client)socks5Client).getSocket(this.getProxyConnectionTimeout());
            this.lastWorkingProxy = usedStreamHost.getJID();
            Socks5BytestreamSession socks5BytestreamSession = new Socks5BytestreamSession(socket, usedStreamHost.getJID().equals(this.connection.getUser()));
            return socks5BytestreamSession;
        }
        catch (TimeoutException e) {
            throw new IOException("Timeout while connecting to SOCKS5 proxy");
        }
        finally {
            socks5Proxy.removeTransfer(digest);
        }
    }

    private boolean supportsSocks5(String targetJID) throws XMPPException {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        DiscoverInfo discoverInfo = serviceDiscoveryManager.discoverInfo(targetJID);
        return discoverInfo.containsFeature(NAMESPACE);
    }

    private List<String> determineProxies() throws XMPPException {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        ArrayList<String> proxies = new ArrayList<String>();
        DiscoverItems discoverItems = serviceDiscoveryManager.discoverItems(this.connection.getServiceName());
        Iterator<DiscoverItems.Item> itemIterator = discoverItems.getItems();
        block2: while (itemIterator.hasNext()) {
            DiscoverItems.Item item = itemIterator.next();
            if (this.proxyBlacklist.contains(item.getEntityID())) continue;
            try {
                DiscoverInfo proxyInfo = serviceDiscoveryManager.discoverInfo(item.getEntityID());
                Iterator<DiscoverInfo.Identity> identities = proxyInfo.getIdentities();
                while (identities.hasNext()) {
                    DiscoverInfo.Identity identity = identities.next();
                    if ("proxy".equalsIgnoreCase(identity.getCategory()) && "bytestreams".equalsIgnoreCase(identity.getType())) {
                        proxies.add(item.getEntityID());
                        continue block2;
                    }
                    this.proxyBlacklist.add(item.getEntityID());
                }
            }
            catch (XMPPException e) {
                this.proxyBlacklist.add(item.getEntityID());
            }
        }
        return proxies;
    }

    private List<Bytestream.StreamHost> determineStreamHostInfos(List<String> proxies) {
        ArrayList<Bytestream.StreamHost> streamHosts = new ArrayList<Bytestream.StreamHost>();
        List<Bytestream.StreamHost> localProxies = this.getLocalStreamHost();
        if (localProxies != null) {
            streamHosts.addAll(localProxies);
        }
        for (String proxy : proxies) {
            Bytestream streamHostRequest = this.createStreamHostRequest(proxy);
            try {
                Bytestream response = (Bytestream)SyncPacketSend.getReply(this.connection, streamHostRequest);
                streamHosts.addAll(response.getStreamHosts());
            }
            catch (XMPPException e) {
                this.proxyBlacklist.add(proxy);
            }
        }
        return streamHosts;
    }

    private Bytestream createStreamHostRequest(String proxy) {
        Bytestream request = new Bytestream();
        request.setType(IQ.Type.GET);
        request.setTo(proxy);
        return request;
    }

    private List<Bytestream.StreamHost> getLocalStreamHost() {
        Socks5Proxy socks5Server = Socks5Proxy.getSocks5Proxy();
        if (socks5Server.isRunning()) {
            List<String> addresses = socks5Server.getLocalAddresses();
            int port = socks5Server.getPort();
            if (addresses.size() >= 1) {
                ArrayList<Bytestream.StreamHost> streamHosts = new ArrayList<Bytestream.StreamHost>();
                for (String address : addresses) {
                    Bytestream.StreamHost streamHost = new Bytestream.StreamHost(this.connection.getUser(), address);
                    streamHost.setPort(port);
                    streamHosts.add(streamHost);
                }
                return streamHosts;
            }
        }
        return null;
    }

    private Bytestream createBytestreamInitiation(String sessionID, String targetJID, List<Bytestream.StreamHost> streamHosts) {
        Bytestream initiation = new Bytestream(sessionID);
        for (Bytestream.StreamHost streamHost : streamHosts) {
            initiation.addStreamHost(streamHost);
        }
        initiation.setType(IQ.Type.SET);
        initiation.setTo(targetJID);
        return initiation;
    }

    protected void replyRejectPacket(IQ packet) {
        XMPPError xmppError = new XMPPError(XMPPError.Condition.no_acceptable);
        IQ errorIQ = IQ.createErrorResponse(packet, xmppError);
        this.connection.sendPacket(errorIQ);
    }

    private void activate() {
        this.connection.addPacketListener(this.initiationListener, this.initiationListener.getFilter());
        this.enableService();
    }

    private void enableService() {
        ServiceDiscoveryManager manager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        if (!manager.includesFeature(NAMESPACE)) {
            manager.addFeature(NAMESPACE);
        }
    }

    private String getNextSessionID() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(SESSION_ID_PREFIX);
        buffer.append(Math.abs(randomGenerator.nextLong()));
        return buffer.toString();
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected BytestreamListener getUserListener(String initiator) {
        return this.userListeners.get(initiator);
    }

    protected List<BytestreamListener> getAllRequestListeners() {
        return this.allRequestListeners;
    }

    protected List<String> getIgnoredBytestreamRequests() {
        return this.ignoredBytestreamRequests;
    }

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(Connection connection) {
                final Socks5BytestreamManager manager = Socks5BytestreamManager.getBytestreamManager(connection);
                connection.addConnectionListener(new AbstractConnectionListener(){

                    @Override
                    public void connectionClosed() {
                        manager.disableService();
                    }
                });
            }
        });
        randomGenerator = new Random();
        managers = new HashMap<Connection, Socks5BytestreamManager>();
    }
}

