/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.Cache;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.Bytestream;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.packet.StreamInitiation;

public class Socks5TransferNegotiator
extends StreamNegotiator {
    protected static final String NAMESPACE = "http://jabber.org/protocol/bytestreams";
    private static final int CONNECT_FAILURE_THRESHOLD = 2;
    private static final long BLACKLIST_LIFETIME = 0x6DDD00L;
    public static boolean isAllowLocalProxyHost = true;
    private final XMPPConnection connection;
    private List<String> proxies;
    private List<String> streamHosts;
    private final Object proxyLock = new Object();
    private ProxyProcess proxyProcess;
    private final Object processLock = new Object();
    private final Cache addressBlacklist = new Cache(100, 0x6DDD00L);

    public Socks5TransferNegotiator(XMPPConnection connection) {
        this.connection = connection;
    }

    public PacketFilter getInitiationPacketFilter(String from, String sessionID) {
        return new AndFilter(new FromMatchesFilter(from), new BytestreamSIDFilter(sessionID));
    }

    InputStream negotiateIncomingStream(Packet streamInitiation) throws XMPPException {
        SelectedHostInfo selectedHost;
        Bytestream streamHostsInfo = (Bytestream)streamInitiation;
        if (streamHostsInfo.getType().equals(IQ.Type.ERROR)) {
            throw new XMPPException(streamHostsInfo.getError());
        }
        try {
            selectedHost = this.selectHost(streamHostsInfo);
        }
        catch (XMPPException ex) {
            if (ex.getXMPPError() != null) {
                IQ errorPacket = super.createError(streamHostsInfo.getTo(), streamHostsInfo.getFrom(), streamHostsInfo.getPacketID(), ex.getXMPPError());
                this.connection.sendPacket(errorPacket);
            }
            throw ex;
        }
        Bytestream streamResponse = this.createUsedHostConfirmation(selectedHost.selectedHost, streamHostsInfo.getFrom(), streamHostsInfo.getTo(), streamHostsInfo.getPacketID());
        this.connection.sendPacket(streamResponse);
        try {
            return selectedHost.establishedSocket.getInputStream();
        }
        catch (IOException e) {
            throw new XMPPException("Error establishing input stream", e);
        }
    }

    public InputStream createIncomingStream(StreamInitiation initiation) throws XMPPException {
        Packet streamInitiation = this.initiateIncomingStream(this.connection, initiation);
        return this.negotiateIncomingStream(streamInitiation);
    }

    private Bytestream createUsedHostConfirmation(Bytestream.StreamHost selectedHost, String initiator, String target, String packetID) {
        Bytestream streamResponse = new Bytestream();
        streamResponse.setTo(initiator);
        streamResponse.setFrom(target);
        streamResponse.setType(IQ.Type.RESULT);
        streamResponse.setPacketID(packetID);
        streamResponse.setUsedHost(selectedHost.getJID());
        return streamResponse;
    }

    private SelectedHostInfo selectHost(Bytestream streamHostsInfo) throws XMPPException {
        Iterator it = streamHostsInfo.getStreamHosts().iterator();
        Bytestream.StreamHost selectedHost = null;
        Socket socket = null;
        while (it.hasNext()) {
            selectedHost = (Bytestream.StreamHost)it.next();
            String address = selectedHost.getAddress();
            int failures = this.getConnectionFailures(address);
            if (failures >= 2) continue;
            try {
                socket = new Socket(address, selectedHost.getPort());
                this.establishSOCKS5ConnectionToProxy(socket, this.createDigest(streamHostsInfo.getSessionID(), streamHostsInfo.getFrom(), streamHostsInfo.getTo()));
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.incrementConnectionFailures(address);
                selectedHost = null;
                socket = null;
            }
        }
        if (selectedHost == null || socket == null || !socket.isConnected()) {
            String errorMessage = "Could not establish socket with any provided host";
            throw new XMPPException(errorMessage, new XMPPError(XMPPError.Condition.no_acceptable, errorMessage));
        }
        return new SelectedHostInfo(selectedHost, socket);
    }

    private void incrementConnectionFailures(String address) {
        Integer count = (Integer)this.addressBlacklist.get(address);
        count = count == null ? new Integer(1) : new Integer(count + 1);
        this.addressBlacklist.put(address, count);
    }

    private int getConnectionFailures(String address) {
        Integer count = (Integer)this.addressBlacklist.get(address);
        return count != null ? count : 0;
    }

    private String createDigest(String sessionID, String initiator, String target) {
        return StringUtils.hash(sessionID + StringUtils.parseName(initiator) + "@" + StringUtils.parseServer(initiator) + "/" + StringUtils.parseResource(initiator) + StringUtils.parseName(target) + "@" + StringUtils.parseServer(target) + "/" + StringUtils.parseResource(target));
    }

    public OutputStream createOutgoingStream(String streamID, String initiator, String target) throws XMPPException {
        Socket socket;
        try {
            socket = this.initBytestreamSocket(streamID, initiator, target);
        }
        catch (Exception e) {
            throw new XMPPException("Error establishing transfer socket", e);
        }
        if (socket != null) {
            try {
                return new BufferedOutputStream(socket.getOutputStream());
            }
            catch (IOException e) {
                throw new XMPPException("Error establishing output stream", e);
            }
        }
        return null;
    }

    private Socket initBytestreamSocket(String sessionID, String initiator, String target) throws Exception {
        String localIP;
        ProxyProcess process;
        try {
            process = this.establishListeningSocket();
        }
        catch (IOException io) {
            process = null;
        }
        try {
            localIP = this.discoverLocalIP();
        }
        catch (UnknownHostException e1) {
            localIP = null;
        }
        Bytestream query = this.createByteStreamInit(initiator, target, sessionID, localIP, process != null ? process.getPort() : 0);
        Socket conn = this.waitForUsedHostResponse((String)sessionID, (ProxyProcess)process, (String)this.createDigest((String)sessionID, (String)initiator, (String)target), (Bytestream)query).establishedSocket;
        this.cleanupListeningSocket();
        return conn;
    }

    private SelectedHostInfo waitForUsedHostResponse(String sessionID, ProxyProcess proxy, String digest, Bytestream query) throws XMPPException, IOException {
        SelectedHostInfo info = new SelectedHostInfo();
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(query.getPacketID()));
        this.connection.sendPacket(query);
        Packet packet = collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (packet == null || !(packet instanceof Bytestream)) {
            throw new XMPPException("Unexpected response from remote user");
        }
        Bytestream response = (Bytestream)packet;
        if (response.getType().equals(IQ.Type.ERROR)) {
            throw new XMPPException("Remote client returned error, stream hosts expected", response.getError());
        }
        Bytestream.StreamHostUsed used = response.getUsedHost();
        Bytestream.StreamHost usedHost = query.getStreamHost(used.getJID());
        if (usedHost == null) {
            throw new XMPPException("Remote user responded with unknown host");
        }
        if (used.getJID().equals(query.getFrom())) {
            info.establishedSocket = proxy.getSocket(digest);
            info.selectedHost = usedHost;
            return info;
        }
        info.establishedSocket = new Socket(usedHost.getAddress(), usedHost.getPort());
        this.establishSOCKS5ConnectionToProxy(info.establishedSocket, digest);
        Bytestream activate = Socks5TransferNegotiator.createByteStreamActivate(sessionID, response.getTo(), usedHost.getJID(), response.getFrom());
        collector = this.connection.createPacketCollector(new PacketIDFilter(activate.getPacketID()));
        this.connection.sendPacket(activate);
        IQ serverResponse = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (!serverResponse.getType().equals(IQ.Type.RESULT)) {
            info.establishedSocket.close();
            return null;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProxyProcess establishListeningSocket() throws IOException {
        Object object = this.processLock;
        synchronized (object) {
            if (this.proxyProcess == null) {
                this.proxyProcess = new ProxyProcess(new ServerSocket(7777));
                this.proxyProcess.start();
            }
        }
        this.proxyProcess.addTransfer();
        return this.proxyProcess;
    }

    private void cleanupListeningSocket() {
        if (this.proxyProcess == null) {
            return;
        }
        this.proxyProcess.removeTransfer();
    }

    private String discoverLocalIP() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bytestream createByteStreamInit(String from, String to, String sid, String localIP, int port) {
        Bytestream bs = new Bytestream();
        bs.setTo(to);
        bs.setFrom(from);
        bs.setSessionID(sid);
        bs.setType(IQ.Type.SET);
        bs.setMode(Bytestream.Mode.TCP);
        if (localIP != null && port > 0) {
            bs.addStreamHost(from, localIP, port);
        }
        Object object = this.proxyLock;
        synchronized (object) {
            if (this.proxies == null) {
                this.initProxies();
            }
        }
        if (this.streamHosts != null) {
            Iterator<String> it = this.streamHosts.iterator();
            while (it.hasNext()) {
                bs.addStreamHost((Bytestream.StreamHost)((Object)it.next()));
            }
        }
        return bs;
    }

    private String checkIsProxy(ServiceDiscoveryManager manager, DiscoverItems.Item item) {
        DiscoverInfo info;
        try {
            info = manager.discoverInfo(item.getEntityID());
        }
        catch (XMPPException e) {
            return null;
        }
        Iterator<DiscoverInfo.Identity> itx = info.getIdentities();
        while (itx.hasNext()) {
            DiscoverInfo.Identity identity = itx.next();
            if (!"proxy".equalsIgnoreCase(identity.getCategory()) || !"bytestreams".equalsIgnoreCase(identity.getType())) continue;
            return info.getFrom();
        }
        return null;
    }

    private void initProxies() {
        this.proxies = new ArrayList<String>();
        ServiceDiscoveryManager manager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        try {
            DiscoverItems discoItems = manager.discoverItems(this.connection.getServiceName());
            Iterator<DiscoverItems.Item> it = discoItems.getItems();
            while (it.hasNext()) {
                DiscoverItems.Item item = it.next();
                String proxy = this.checkIsProxy(manager, item);
                if (proxy == null) continue;
                this.proxies.add(proxy);
            }
        }
        catch (XMPPException e) {
            return;
        }
        if (this.proxies.size() > 0) {
            this.initStreamHosts();
        }
    }

    private void initStreamHosts() {
        ArrayList<String> streamHosts = new ArrayList<String>();
        Iterator<String> it = this.proxies.iterator();
        while (it.hasNext()) {
            String jid = it.next().toString();
            IQ query = new IQ(){

                public String getChildElementXML() {
                    return "<query xmlns=\"http://jabber.org/protocol/bytestreams\"/>";
                }
            };
            query.setType(IQ.Type.GET);
            query.setTo(jid);
            PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(query.getPacketID()));
            this.connection.sendPacket(query);
            Bytestream response = (Bytestream)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
            if (response != null) {
                streamHosts.addAll(response.getStreamHosts());
            }
            collector.cancel();
        }
        this.streamHosts = streamHosts;
    }

    private static Bytestream createByteStreamActivate(String sessionID, String from, String to, String target) {
        Bytestream activate = new Bytestream(sessionID);
        activate.setMode(null);
        activate.setToActivate(target);
        activate.setFrom(from);
        activate.setTo(to);
        activate.setType(IQ.Type.SET);
        return activate;
    }

    private String establishSocks5UploadConnection(Socket connection) throws XMPPException, IOException {
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        DataInputStream in = new DataInputStream(connection.getInputStream());
        int b = ((InputStream)in).read();
        if (b != 5) {
            throw new XMPPException("Only SOCKS5 supported");
        }
        b = ((InputStream)in).read();
        int[] auth = new int[b];
        for (int i = 0; i < b; ++i) {
            auth[i] = ((InputStream)in).read();
        }
        int authMethod = -1;
        for (int i = 0; i < auth.length; ++i) {
            int n = authMethod = auth[i] == 0 ? 0 : -1;
            if (authMethod == 0) break;
        }
        if (authMethod != 0) {
            throw new XMPPException("Authentication method not supported");
        }
        byte[] cmd = new byte[]{5, 0};
        ((OutputStream)out).write(cmd);
        String responseDigest = this.createIncomingSocks5Message(in);
        cmd = this.createOutgoingSocks5Message(0, responseDigest);
        if (!connection.isConnected()) {
            throw new XMPPException("Socket closed by remote user");
        }
        ((OutputStream)out).write(cmd);
        return responseDigest;
    }

    public String[] getNamespaces() {
        return new String[]{NAMESPACE};
    }

    private void establishSOCKS5ConnectionToProxy(Socket socket, String digest) throws IOException {
        byte[] cmd = new byte[]{5, 1, 0};
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        ((OutputStream)out).write(cmd);
        DataInputStream in = new DataInputStream(socket.getInputStream());
        byte[] response = new byte[2];
        ((InputStream)in).read(response);
        cmd = this.createOutgoingSocks5Message(1, digest);
        ((OutputStream)out).write(cmd);
        this.createIncomingSocks5Message(in);
    }

    private String createIncomingSocks5Message(InputStream in) throws IOException {
        byte[] cmd = new byte[5];
        in.read(cmd, 0, 5);
        byte[] addr = new byte[cmd[4]];
        in.read(addr, 0, addr.length);
        String digest = new String(addr);
        in.read();
        in.read();
        return digest;
    }

    private byte[] createOutgoingSocks5Message(int cmd, String digest) {
        byte[] addr = digest.getBytes();
        byte[] data = new byte[7 + addr.length];
        data[0] = 5;
        data[1] = (byte)cmd;
        data[2] = 0;
        data[3] = 3;
        data[4] = (byte)addr.length;
        System.arraycopy(addr, 0, data, 5, addr.length);
        data[data.length - 2] = 0;
        data[data.length - 1] = 0;
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Object object = this.processLock;
        synchronized (object) {
            if (this.proxyProcess != null) {
                this.proxyProcess.stop();
            }
        }
    }

    public void cancel() {
    }

    private static class BytestreamSIDFilter
    implements PacketFilter {
        private String sessionID;

        public BytestreamSIDFilter(String sessionID) {
            if (sessionID == null) {
                throw new IllegalArgumentException("StreamID cannot be null");
            }
            this.sessionID = sessionID;
        }

        public boolean accept(Packet packet) {
            if (!Bytestream.class.isInstance(packet)) {
                return false;
            }
            Bytestream bytestream = (Bytestream)packet;
            String sessionID = bytestream.getSessionID();
            return sessionID != null && sessionID.equals(this.sessionID);
        }
    }

    private class ProxyProcess
    implements Runnable {
        private final ServerSocket listeningSocket;
        private final Map connectionMap = new HashMap();
        private boolean done = false;
        private Thread thread = new Thread((Runnable)this, "File Transfer Connection Listener");
        private int transfers;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    this.listeningSocket.setSoTimeout(10000);
                }
                catch (SocketException e) {
                    e.printStackTrace();
                    try {
                        this.listeningSocket.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    return;
                }
                while (!this.done) {
                    Socket conn = null;
                    Object e2 = this;
                    synchronized (e2) {
                        while (this.transfers <= 0 && !this.done) {
                            this.transfers = -1;
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                    if (this.done) {
                        break;
                    }
                    try {
                        e2 = this.listeningSocket;
                        synchronized (e2) {
                            conn = this.listeningSocket.accept();
                        }
                        if (conn == null) continue;
                        String digest = Socks5TransferNegotiator.this.establishSocks5UploadConnection(conn);
                        Map e = this.connectionMap;
                        synchronized (e) {
                            this.connectionMap.put(digest, conn);
                        }
                    }
                    catch (SocketTimeoutException e22) {
                    }
                    catch (IOException e3) {
                    }
                    catch (XMPPException e4) {
                        e4.printStackTrace();
                        if (conn == null) continue;
                        try {
                            conn.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            finally {
                try {
                    this.listeningSocket.close();
                }
                catch (IOException e) {}
            }
        }

        public void start() {
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            this.done = true;
            Object object = this;
            synchronized (object) {
                this.notify();
            }
            object = this.listeningSocket;
            synchronized (object) {
                this.listeningSocket.notify();
            }
        }

        public int getPort() {
            return this.listeningSocket.getLocalPort();
        }

        ProxyProcess(ServerSocket listeningSocket) {
            this.listeningSocket = listeningSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket getSocket(String digest) {
            Map map = this.connectionMap;
            synchronized (map) {
                return (Socket)this.connectionMap.get(digest);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTransfer() {
            ProxyProcess proxyProcess = this;
            synchronized (proxyProcess) {
                if (this.transfers == -1) {
                    this.transfers = 1;
                    this.notify();
                } else {
                    ++this.transfers;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeTransfer() {
            ProxyProcess proxyProcess = this;
            synchronized (proxyProcess) {
                --this.transfers;
            }
        }
    }

    private static class SelectedHostInfo {
        protected XMPPException exception;
        protected Bytestream.StreamHost selectedHost;
        protected Socket establishedSocket;

        SelectedHostInfo(Bytestream.StreamHost selectedHost, Socket establishedSocket) {
            this.selectedHost = selectedHost;
            this.establishedSocket = establishedSocket;
        }

        public SelectedHostInfo() {
        }
    }
}

