/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.impl;

import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.queue.impl.QueueDataSerializerHook;
import com.hazelcast.queue.impl.QueueOperation;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;

public final class OfferBackupOperation
extends QueueOperation
implements BackupOperation,
IdentifiedDataSerializable {
    private Data data;
    private long itemId;

    public OfferBackupOperation() {
    }

    public OfferBackupOperation(String name, Data data, long itemId) {
        super(name);
        this.data = data;
        this.itemId = itemId;
    }

    @Override
    public void run() throws Exception {
        this.getOrCreateContainer().offerBackup(this.data, this.itemId);
        this.response = true;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        this.data.writeData(out);
        out.writeLong(this.itemId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.data = IOUtil.readData(in);
        this.itemId = in.readLong();
    }

    @Override
    public int getFactoryId() {
        return QueueDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 3;
    }
}

