/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.operations.client;

import com.hazelcast.multimap.impl.operations.client.TxnMultiMapRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.transaction.TransactionContext;
import java.io.IOException;
import java.security.Permission;

public class TxnMultiMapPutRequest
extends TxnMultiMapRequest {
    Data key;
    Data value;

    public TxnMultiMapPutRequest() {
    }

    public TxnMultiMapPutRequest(String name, Data key, Data value) {
        super(name);
        this.key = key;
        this.value = value;
    }

    @Override
    public Object innerCall() throws Exception {
        TransactionContext context = this.getEndpoint().getTransactionContext(this.txnId);
        return context.getMultiMap(this.name).put(this.key, this.value);
    }

    @Override
    public int getClassId() {
        return 19;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
        this.value.writeData(out);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
        this.value = new Data();
        this.value.readData(in);
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(this.name, "put");
    }
}

