/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.concurrent.lock.client.AbstractIsLockedRequest;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.ObjectNamespace;
import java.io.IOException;
import java.security.Permission;

public class MapIsLockedRequest
extends AbstractIsLockedRequest
implements RetryableRequest,
SecureRequest {
    private String name;

    public MapIsLockedRequest() {
    }

    public MapIsLockedRequest(String name, Data key) {
        super(key);
        this.name = name;
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 18;
    }

    @Override
    protected ObjectNamespace getNamespace() {
        return new DefaultObjectNamespace("hz:impl:mapService", this.name);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        super.write(writer);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        super.read(reader);
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "lock");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getDistributedObjectType() {
        return "hz:impl:mapService";
    }
}

