/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.util.ButtonUtil;
import com.install4j.runtime.util.DisplayTextArea;
import com.install4j.runtime.util.KeyboardUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class PasswordDialog
extends JDialog
implements ActionListener {
    private static final Icon ICON = GUIHelper.loadIcon("lock_open.png");
    private static final int TEXT_FIELD_WIDTH = 350;
    private JButton btnOk;
    private JButton btnCancel;
    private DisplayTextArea displayTextArea;
    private String header;
    private String footer;
    private String title;
    private InputTextValidator inputTextValidator;
    private boolean canceled = true;
    private JTextField textField;

    public static String getPassword(Window window, String string, String string2, String string3, InputTextValidator inputTextValidator) {
        PasswordDialog passwordDialog;
        if (window instanceof JDialog) {
            passwordDialog = new PasswordDialog((JDialog)window, string, string2, string3, inputTextValidator);
        } else if (window instanceof JFrame || window == null) {
            passwordDialog = new PasswordDialog((JFrame)window, string, string2, string3, inputTextValidator);
        } else {
            throw new IllegalArgumentException();
        }
        passwordDialog.setVisible(true);
        passwordDialog.dispose();
        if (!passwordDialog.isCanceled()) {
            return passwordDialog.getInput();
        }
        return null;
    }

    public PasswordDialog(JFrame jFrame, String string, String string2, String string3, InputTextValidator inputTextValidator) {
        super(jFrame);
        this.init(string, string2, string3, inputTextValidator);
    }

    public PasswordDialog(JDialog jDialog, String string, String string2, String string3, InputTextValidator inputTextValidator) {
        super(jDialog);
        this.init(string, string2, string3, inputTextValidator);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnOk) {
            this.doOk();
        } else if (object == this.btnCancel) {
            this.doCancel();
        }
    }

    public String getInput() {
        return this.textField.getText();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.canceled = true;
        }
        super.setVisible(bl);
    }

    private void init(String string, String string2, String string3, InputTextValidator inputTextValidator) {
        this.header = string;
        this.footer = string2;
        this.title = string3;
        this.inputTextValidator = inputTextValidator;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
        this.setupAccelerators();
    }

    private void setupControls() {
        this.textField = new JPasswordField();
        Dimension dimension = this.textField.getPreferredSize();
        dimension.width = 350;
        this.textField.setPreferredSize(dimension);
        this.btnOk = new JButton("OK");
        this.btnCancel = new JButton("Cancel");
    }

    private void setupComponent() {
        this.setModal(true);
        this.setTitle(this.title);
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.createContentPanel());
        this.getRootPane().setDefaultButton(this.btnOk);
        this.pack();
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getWidth()) / 2;
        int n2 = (dimension.height - this.getHeight()) / 2;
        this.setLocation(n, n2);
    }

    private JPanel createContentPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        jPanel.add((Component)new JLabel(ICON), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)new JLabel(this.header), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.textField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        if (this.footer != null) {
            this.displayTextArea = new DisplayTextArea();
            this.displayTextArea.setText(this.footer);
            jPanel.add((Component)this.displayTextArea, gridBagConstraints);
            ++gridBagConstraints.gridy;
        } else {
            jPanel.add((Component)new JPanel(), gridBagConstraints);
        }
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)ButtonUtil.createHorizontalButtonBox(new Component[]{this.btnOk, this.btnCancel}, 1), gridBagConstraints);
        return jPanel;
    }

    protected void setupEventHandlers() {
        this.btnOk.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PasswordDialog.this.doCancel();
            }

            public void windowActivated(WindowEvent windowEvent) {
                PasswordDialog.this.textField.requestFocus();
            }
        });
    }

    private void doOk() {
        if (this.inputTextValidator != null && !this.inputTextValidator.isValidInputText(this.getInput(), this)) {
            this.textField.requestFocus();
            return;
        }
        this.canceled = false;
        this.setVisible(false);
    }

    private void doCancel() {
        this.canceled = true;
        this.setVisible(false);
    }

    private void setupAccelerators() {
        KeyboardUtil.addAccelerator(1, this.btnCancel, (JComponent)this.getContentPane(), this, 27, 0);
    }

    public static void main(String[] stringArray) {
        PasswordDialog.getPassword(null, "Please enter your password:", "You must be a member of the Administrator group to install a service. You must be a member of the Administrator group to install a service. You must be a member of the Administrator group to install a service.", "Enter Password", null);
        System.exit(0);
    }

    public static interface InputTextValidator {
        public boolean isValidInputText(String var1, PasswordDialog var2);
    }
}

